/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageReferenceSet
extends ReferenceSetBase<PsiPackageReference> {
    public PackageReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "<init>"));
        }
        super(str, element, startInElement, '.');
    }

    @NotNull
    protected PsiPackageReference createReference(TextRange range, int index) {
        PsiPackageReference psiPackageReference = new PsiPackageReference(this, range, index);
        if (psiPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet", "createReference"));
        }
        return psiPackageReference;
    }

    public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, final String packageName) {
        if (context != null) {
            return ContainerUtil.filter((Object[])context.getSubPackages(), (Condition)new Condition<PsiPackage>(){

                public boolean value(PsiPackage aPackage) {
                    return Comparing.equal((String)aPackage.getName(), (String)packageName);
                }
            });
        }
        return Collections.emptyList();
    }

    public Collection<PsiPackage> resolvePackage() {
        PsiPackageReference packageReference = (PsiPackageReference)this.getLastReference();
        if (packageReference == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Object[])packageReference.multiResolve(false), (Function)new NullableFunction<ResolveResult, PsiPackage>(){

            public PsiPackage fun(ResolveResult resolveResult) {
                return (PsiPackage)resolveResult.getElement();
            }
        });
    }

    public Set<PsiPackage> getInitialContext() {
        return Collections.singleton(JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage(""));
    }
}

