/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlTextManipulator
extends AbstractElementManipulator<XmlText> {
    public XmlText handleContentChange(@NotNull XmlText text, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String newValue;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "handleContentChange"));
        }
        String value = text.getValue();
        if (range.equals((Object)this.getRangeInElement(text))) {
            newValue = newContent;
        } else {
            StringBuilder replacement = new StringBuilder(value);
            replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
            newValue = replacement.toString();
        }
        if (Comparing.equal((String)value, (String)newValue)) {
            return text;
        }
        if (!newValue.isEmpty()) {
            text.setValue(newValue);
        } else {
            text.deleteChildRange(text.getFirstChild(), text.getLastChild());
        }
        return text;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlText text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "getRangeInElement"));
        }
        TextRange textRange = XmlTextManipulator.getValueRange(text);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        String value = xmlText.getValue();
        int i = value.indexOf(value);
        int start = xmlText.displayToPhysical(i);
        return value.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i + value.length() - 1) + 1);
    }
}

