/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PlainFileManipulator
extends AbstractElementManipulator<PsiPlainTextFile> {
    public PsiPlainTextFile handleContentChange(@NotNull PsiPlainTextFile file, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PlainFileManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PlainFileManipulator", "handleContentChange"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newContent);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        return file;
    }
}

