/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiExpression classAccess;
        PsiElement methodCall;
        PsiElement expressionList;
        String value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression && (value = JavaReflectionReferenceProvider.getValue((PsiLiteralExpression)element)) != null && (expressionList = element.getParent()) instanceof PsiExpressionList && (methodCall = expressionList.getParent()) != null && (classAccess = JavaReflectionReferenceProvider.getContext(methodCall)) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new JavaLangClassMemberReference((PsiLiteralExpression)element, classAccess)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiExpression getContext(PsiElement methodCall) {
        PsiClassObjectAccessExpression expression = (PsiClassObjectAccessExpression)PsiTreeUtil.findChildOfType((PsiElement)methodCall, PsiClassObjectAccessExpression.class);
        return expression == null ? (PsiExpression)PsiTreeUtil.findChildOfType((PsiElement)methodCall, PsiMethodCallExpression.class) : expression;
    }

    @Nullable
    private static String getValue(PsiLiteralExpression element) {
        Object value = element.getValue();
        return value instanceof String ? (String)value : null;
    }
}

