/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME.getName());
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private static final Comparator<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>> PRIORITY_COMPARATOR = new Comparator<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>>(){

        @Override
        public int compare(ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext> o1, ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext> o2) {
            return Comparing.compare((double)o2.priority, (double)o1.priority);
        }
    };
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = new FactoryMap<Language, PsiReferenceRegistrarImpl>(){

        protected PsiReferenceRegistrarImpl create(Language language) {
            PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl();
            for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguage(language)) {
                contributor.registerReferenceProviders((PsiReferenceRegistrar)registrar);
            }
            List referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguage(language);
            for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
                ElementPattern pattern = providerBean.createElementPattern();
                if (pattern == null) continue;
                registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                    PsiReferenceProvider myProvider;

                    @NotNull
                    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2$1", "getReferencesByElement"));
                        }
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2$1", "getReferencesByElement"));
                        }
                        if (this.myProvider == null) {
                            this.myProvider = providerBean.instantiate();
                            if (this.myProvider == null) {
                                this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                            }
                        }
                        PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement(element, context);
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2$1", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                });
            }
            registrar.markInitialized();
            return registrar;
        }
    };

    @Override
    public synchronized PsiReferenceRegistrarImpl getRegistrar(Language language) {
        return this.myRegistrars.get(language);
    }

    @Override
    protected PsiReference[] doGetReferencesFromProviders(PsiElement context, PsiReferenceService.Hints hints) {
        List<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>> providersForContextLanguage = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints);
        List<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>> providersForAllLanguages = this.getRegistrar(Language.ANY).getPairsByElement(context, hints);
        int providersCount = providersForContextLanguage.size() + providersForAllLanguages.size();
        if (providersCount == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (providersCount == 1) {
            ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext> firstProvider = (providersForAllLanguages.isEmpty() ? providersForContextLanguage : providersForAllLanguages).get(0);
            return ((PsiReferenceProvider)firstProvider.provider).getReferencesByElement(context, (ProcessingContext)firstProvider.processingContext);
        }
        List list = ContainerUtil.concat(providersForContextLanguage, providersForAllLanguages);
        ProviderBinding.ProviderInfo[] providers = list.toArray(new ProviderBinding.ProviderInfo[list.size()]);
        Arrays.sort(providers, PRIORITY_COMPARATOR);
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        double maxPriority = providers[0].priority;
        block2: for (ProviderBinding.ProviderInfo trinity : providers) {
            PsiReference[] refs;
            try {
                refs = ((PsiReferenceProvider)trinity.provider).getReferencesByElement(context, (ProcessingContext)trinity.processingContext);
            }
            catch (IndexNotReadyException ex) {
                continue;
            }
            if (trinity.priority != maxPriority) {
                for (PsiReference ref : refs) {
                    for (PsiReference reference : result) {
                        if (ref == null || !ReferenceRange.containsRangeInElement((PsiReference)reference, (TextRange)ref.getRangeInElement())) continue;
                        continue block2;
                    }
                }
            }
            for (PsiReference ref : refs) {
                if (ref == null) continue;
                result.add(ref);
            }
        }
        return result.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(result, (Object[])new PsiReference[result.size()]);
    }
}

