/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDClassComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDMethodComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDParser {
    private static final String PRE_TAG_START = "<pre>";
    private static final String PRE_TAG_END = "</pre>";
    private static final String P_END_TAG = "</p>";
    private static final String P_START_TAG = "<p>";
    private static final String SELF_CLOSED_P_TAG = "<p/>";
    private final CodeStyleSettings mySettings;
    private final LanguageLevel myLanguageLevel;
    private static final char lineSeparator = '\n';
    private static final TagParser[] tagParsers = new TagParser[]{new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag = JDTag.SEE.tagEqual(tag);
            if (isMyTag) {
                c.addSeeAlso(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag = JDTag.SINCE.tagEqual(tag);
            if (isMyTag) {
                c.setSince(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDClassComment && JDTag.VERSION.tagEqual(tag);
            if (isMyTag) {
                ((JDClassComment)c).setVersion(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag = JDTag.DEPRECATED.tagEqual(tag);
            if (isMyTag) {
                c.setDeprecated(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDMethodComment && JDTag.RETURN.tagEqual(tag);
            if (isMyTag) {
                JDMethodComment mc = (JDMethodComment)c;
                mc.setReturnTag(line);
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDParamListOwnerComment && JDTag.PARAM.tagEqual(tag);
            if (isMyTag) {
                char ch;
                int idx;
                JDParamListOwnerComment mc = (JDParamListOwnerComment)c;
                for (idx = 0; idx < line.length() && !Character.isWhitespace(ch = line.charAt(idx)); ++idx) {
                }
                if (idx == line.length()) {
                    mc.addParameter(line, "");
                } else {
                    String name = line.substring(0, idx);
                    String desc = line.substring(idx).trim();
                    mc.addParameter(name, desc);
                }
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDMethodComment && (JDTag.THROWS.tagEqual(tag) || JDTag.EXCEPTION.tagEqual(tag));
            if (isMyTag) {
                char ch;
                int idx;
                JDMethodComment mc = (JDMethodComment)c;
                for (idx = 0; idx < line.length() && !Character.isWhitespace(ch = line.charAt(idx)); ++idx) {
                }
                if (idx == line.length()) {
                    mc.addThrow(line, "");
                } else {
                    String name = line.substring(0, idx);
                    String desc = line.substring(idx).trim();
                    mc.addThrow(name, desc);
                }
            }
            return isMyTag;
        }
    }, new TagParser(){

        @Override
        boolean parse(String tag, String line, JDComment c) {
            boolean isMyTag;
            boolean bl = isMyTag = c instanceof JDClassComment && JDTag.AUTHOR.tagEqual(tag);
            if (isMyTag) {
                JDClassComment cl = (JDClassComment)c;
                cl.addAuthor(line.trim());
            }
            return isMyTag;
        }
    }};

    public JDParser(@NotNull CodeStyleSettings settings, @NotNull LanguageLevel languageLevel) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "<init>"));
        }
        this.mySettings = settings;
        this.myLanguageLevel = languageLevel;
    }

    @NotNull
    public JDComment parse(@Nullable String text, @NotNull JDComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "parse"));
        }
        if (text == null) {
            JDComment jDComment = comment;
            if (jDComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "parse"));
            }
            return jDComment;
        }
        ArrayList<Boolean> markers = new ArrayList<Boolean>();
        List<String> l = this.toArray(text, "\n", markers);
        if (text.indexOf(10) >= 0) {
            comment.setMultiLine(true);
        }
        if (l == null) {
            JDComment jDComment = comment;
            if (jDComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "parse"));
            }
            return jDComment;
        }
        int size = l.size();
        if (size == 0) {
            JDComment jDComment = comment;
            if (jDComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "parse"));
            }
            return jDComment;
        }
        for (int i = 0; i < size; ++i) {
            String line = l.get(i);
            if (!(line = line.trim()).isEmpty() && line.charAt(0) == '*') {
                line = ((Boolean)markers.get(i)).booleanValue() ? (line.length() > 1 && line.charAt(1) == ' ' ? line.substring(2) : line.substring(1)) : line.substring(1).trim();
            }
            l.set(i, line);
        }
        StringBuilder sb = new StringBuilder();
        String tag = null;
        for (int i = 0; i <= size; ++i) {
            String line;
            String string = line = i == size ? null : l.get(i);
            if (i == size || !line.isEmpty()) {
                if (i == size || line.charAt(0) == '@') {
                    if (tag == null) {
                        comment.setDescription(sb.toString());
                    } else {
                        TagParser parser;
                        int j;
                        String myline = sb.toString();
                        for (j = 0; j < tagParsers.length && !(parser = tagParsers[j]).parse(tag, myline, comment); ++j) {
                        }
                        if (j == tagParsers.length) {
                            comment.addUnknownTag("@" + tag + " " + myline);
                        }
                    }
                    if (i >= size) continue;
                    int last_idx = line.indexOf(32);
                    if (last_idx == -1) {
                        tag = line.substring(1);
                        line = "";
                    } else {
                        tag = line.substring(1, last_idx);
                        line = line.substring(last_idx).trim();
                    }
                    sb.setLength(0);
                    sb.append(line);
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
                continue;
            }
            if (sb.length() <= 0) continue;
            sb.append('\n');
        }
        JDComment jDComment = comment;
        if (jDComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "parse"));
        }
        return jDComment;
    }

    @Nullable
    private List<String> toArray(@Nullable String s, @NotNull String separators, @Nullable List<Boolean> markers) {
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "toArray"));
        }
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        boolean p2nl = markers != null && this.mySettings.JD_P_AT_EMPTY_LINES;
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, separators, true);
        boolean first = true;
        int preCount = 0;
        int curPos = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            curPos += token.length();
            if (separators.contains(token)) {
                if (!first) {
                    list.add("");
                    if (markers != null) {
                        markers.add(preCount > 0);
                    }
                }
                first = false;
                continue;
            }
            first = true;
            if (p2nl && JDParser.isParaTag(token) && s.indexOf(P_END_TAG, curPos) < 0) {
                list.add("");
                markers.add(preCount > 0);
                continue;
            }
            if (preCount == 0) {
                token = token.trim();
            }
            list.add(token);
            if (markers == null) continue;
            if (token.contains(PRE_TAG_START)) {
                ++preCount;
            }
            markers.add(preCount > 0);
            if (!token.contains(PRE_TAG_END)) continue;
            --preCount;
        }
        return list;
    }

    private static boolean isParaTag(@NotNull String token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "isParaTag"));
        }
        String withoutWS = JDParser.removeWhiteSpacesFrom(token).toLowerCase();
        return withoutWS.equals(SELF_CLOSED_P_TAG) || withoutWS.equals(P_START_TAG);
    }

    @NotNull
    private static String removeWhiteSpacesFrom(@NotNull String token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "removeWhiteSpacesFrom"));
        }
        StringBuilder result = new StringBuilder();
        for (char c : token.toCharArray()) {
            if (c == ' ') continue;
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "removeWhiteSpacesFrom"));
        }
        return string;
    }

    @Nullable
    private List<String> toArrayWrapping(@Nullable String s, int width) {
        ArrayList<String> list = new ArrayList<String>();
        List<Pair<String, Boolean>> pairs = this.splitToParagraphs(s);
        if (pairs == null) {
            return null;
        }
        block0: for (Pair<String, Boolean> pair : pairs) {
            String seq = (String)pair.getFirst();
            boolean isMarked = (Boolean)pair.getSecond();
            if (seq.isEmpty()) {
                list.add("");
                continue;
            }
            while (true) {
                if (seq.length() < width) {
                    seq = isMarked ? seq : seq.trim();
                    list.add(seq);
                    continue block0;
                }
                int wrapPos = Math.min(seq.length() - 1, width);
                if ((wrapPos = seq.lastIndexOf(32, wrapPos)) <= 2 * width / 3) {
                    wrapPos = Math.min(seq.length() - 1, width);
                    wrapPos = seq.indexOf(32, wrapPos);
                }
                if (wrapPos >= seq.length() - 1 || wrapPos < 0) {
                    seq = isMarked ? seq : seq.trim();
                    list.add(seq);
                    continue block0;
                }
                list.add(seq.substring(0, wrapPos));
                seq = seq.substring(wrapPos + 1);
            }
        }
        return list;
    }

    @Nullable
    private List<Pair<String, Boolean>> splitToParagraphs(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        ArrayList<Pair<String, Boolean>> result = new ArrayList<Pair<String, Boolean>>();
        StringBuilder sb = new StringBuilder();
        ArrayList<Boolean> markers = new ArrayList<Boolean>();
        List<String> list = this.toArray(s, "\n", markers);
        Boolean[] marks = markers.toArray(new Boolean[markers.size()]);
        markers.clear();
        assert (list != null);
        for (int i = 0; i < list.size(); ++i) {
            String s1 = list.get(i);
            if (marks[i].booleanValue()) {
                if (sb.length() != 0) {
                    result.add((Pair<String, Boolean>)new Pair((Object)sb.toString(), (Object)false));
                    sb.setLength(0);
                }
                result.add((Pair<String, Boolean>)new Pair((Object)s1, (Object)marks[i]));
                continue;
            }
            if (s1.isEmpty()) {
                if (sb.length() != 0) {
                    result.add((Pair<String, Boolean>)new Pair((Object)sb.toString(), (Object)false));
                    sb.setLength(0);
                }
                result.add((Pair<String, Boolean>)new Pair((Object)"", (Object)marks[i]));
                continue;
            }
            if (this.mySettings.JD_PRESERVE_LINE_FEEDS) {
                result.add((Pair<String, Boolean>)new Pair((Object)s1, (Object)marks[i]));
                continue;
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(s1);
        }
        if (!this.mySettings.JD_PRESERVE_LINE_FEEDS && sb.length() != 0) {
            result.add((Pair<String, Boolean>)new Pair((Object)sb.toString(), (Object)false));
        }
        return result;
    }

    @NotNull
    protected StringBuilder formatJDTagDescription(@Nullable String s, @NotNull CharSequence prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "formatJDTagDescription"));
        }
        StringBuilder stringBuilder = this.formatJDTagDescription(s, prefix, false, 0);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "formatJDTagDescription"));
        }
        return stringBuilder;
    }

    private static boolean lineHasUnclosedPreTag(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "lineHasUnclosedPreTag"));
        }
        return StringUtil.getOccurrenceCount((String)line, (String)PRE_TAG_START) > StringUtil.getOccurrenceCount((String)line, (String)PRE_TAG_END);
    }

    @NotNull
    protected StringBuilder formatJDTagDescription(@Nullable String str, @NotNull CharSequence prefix, boolean firstLineShorter, int firstLinePrefixLength) {
        List<String> list;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "formatJDTagDescription"));
        }
        StringBuilder sb = new StringBuilder();
        if (this.mySettings.WRAP_COMMENTS) {
            list = this.toArrayWrapping(str, this.mySettings.RIGHT_MARGIN - prefix.length());
            if (firstLineShorter && list != null && !list.isEmpty() && list.get(0).length() > this.mySettings.RIGHT_MARGIN - firstLinePrefixLength) {
                list = new ArrayList<String>();
                String firstLine = this.toArrayWrapping(str, this.mySettings.RIGHT_MARGIN - firstLinePrefixLength).get(0);
                list.add(firstLine);
                str = str.substring(firstLine.length());
                boolean unclosedPreTag = JDParser.lineHasUnclosedPreTag(firstLine);
                if (unclosedPreTag) {
                    str = PRE_TAG_START + str.replaceAll("^\\s+", "");
                }
                List<String> subList = this.toArrayWrapping(str, this.mySettings.RIGHT_MARGIN - prefix.length());
                if (unclosedPreTag && subList != null && !subList.isEmpty()) {
                    String firstLineTagRemoved = subList.get(0).substring(PRE_TAG_START.length());
                    subList.set(0, firstLineTagRemoved);
                }
                if (subList != null) {
                    list.addAll(subList);
                }
            }
        } else {
            list = this.toArray(str, "\n", new ArrayList<Boolean>());
        }
        if (list == null) {
            sb.append('\n');
        } else {
            boolean insidePreTag = false;
            for (int i = 0; i < list.size(); ++i) {
                String line = list.get(i);
                if (line.isEmpty() && !this.mySettings.JD_KEEP_EMPTY_LINES) continue;
                if (i != 0) {
                    sb.append(prefix);
                }
                if (line.isEmpty() && this.mySettings.JD_P_AT_EMPTY_LINES && !insidePreTag) {
                    if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                        sb.append(P_START_TAG);
                    } else {
                        sb.append(SELF_CLOSED_P_TAG);
                    }
                } else {
                    sb.append(line);
                    if (PRE_TAG_START.equals(line)) {
                        insidePreTag = true;
                    } else if (PRE_TAG_END.equals(line)) {
                        insidePreTag = false;
                    }
                }
                sb.append('\n');
            }
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser", "formatJDTagDescription"));
        }
        return stringBuilder;
    }

    static abstract class TagParser {
        TagParser() {
        }

        abstract boolean parse(String var1, String var2, JDComment var3);
    }
}

