/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDClassComment
extends JDParamListOwnerComment {
    private List<String> myAuthorsList;
    private String myVersion;

    public JDClassComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "<init>"));
        }
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        JDTag tag;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "generateSpecial"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "generateSpecial"));
        }
        super.generateSpecial(prefix, sb);
        if (!JDClassComment.isNull(this.myAuthorsList)) {
            tag = JDTag.AUTHOR;
            for (String author : this.myAuthorsList) {
                sb.append(prefix);
                sb.append(tag.getWithEndWhitespace());
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(author, tag.getDescriptionPrefix(prefix)));
            }
        }
        if (!JDClassComment.isNull(this.myVersion)) {
            sb.append(prefix);
            tag = JDTag.VERSION;
            sb.append(tag.getWithEndWhitespace());
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myVersion, tag.getDescriptionPrefix(prefix)));
        }
    }

    public void addAuthor(@NotNull String author) {
        if (author == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "addAuthor"));
        }
        if (this.myAuthorsList == null) {
            this.myAuthorsList = ContainerUtilRt.newArrayList();
        }
        this.myAuthorsList.add(author);
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "setVersion"));
        }
        this.myVersion = version;
    }
}

