/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;

public class JavaIndentHelper
extends IndentHelperImpl {
    @Override
    protected int getIndentInner(Project project, FileType fileType, ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev = element.getTreePrev();
            while (prev instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder(prev.getElementType())) {
                ASTNode lastCompositePrev = prev;
                if ((prev = prev.getLastChildNode()) != null) continue;
                return this.getIndentInner(project, fileType, lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text = prev.getText();
            int index = Math.max(text.lastIndexOf(10), text.lastIndexOf(13));
            if (index >= 0) {
                return JavaIndentHelper.getIndent(project, fileType, text.substring(index + 1), includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(project, fileType, prev, includeNonSpace, recursionLevel + 1) + JavaIndentHelper.getIndent(project, fileType, text, includeNonSpace);
            }
            if (element.getElementType() == JavaElementType.CODE_BLOCK) {
                parent = element.getTreeParent();
                if (parent.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                    parent = parent.getTreeParent();
                }
                if (parent.getElementType() != JavaElementType.CODE_BLOCK) {
                    return this.getIndentInner(project, fileType, parent, includeNonSpace, recursionLevel + 1);
                }
            } else if (element.getElementType() == JavaTokenType.LBRACE) {
                return this.getIndentInner(project, fileType, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
            }
            ASTNode child = prev;
            for (parent = prev.getTreeParent(); parent != null && child.getTreePrev() == null; parent = parent.getTreeParent()) {
                child = parent;
            }
            if (parent == null) {
                return JavaIndentHelper.getIndent(project, fileType, text, includeNonSpace);
            }
            if (prev.getTreeParent().getElementType() == JavaElementType.LABELED_STATEMENT) {
                return this.getIndentInner(project, fileType, prev, true, recursionLevel + 1) + JavaIndentHelper.getIndent(project, fileType, text, true);
            }
            return this.getIndentInner(project, fileType, prev, includeNonSpace, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(project, fileType, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }
}

