/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleManagerImpl
extends JavaCodeStyleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl");
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String FIND_PREFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    @NonNls
    private static final String SET_PREFIX = "set";
    private final Project myProject;

    public JavaCodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        return this.shortenClassReferences(element, 0);
    }

    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            return element;
        }
        boolean addImports = (flags & 0x1000) == 0;
        boolean incompleteCode = (flags & 0x2000) != 0;
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), addImports, incompleteCode, this.myProject);
            return SourceTreeToPsiMap.treeToPsiNotNull(reference);
        }
        return element;
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        ReferenceAdjuster adjuster;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "shortenClassReferences"));
        }
        CheckUtil.checkWritable(element);
        if (SourceTreeToPsiMap.hasTreeElement(element) && (adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            adjuster.processRange(element.getNode(), startOffset, endOffset, this.myProject);
        }
    }

    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "qualifyClassReferences"));
        }
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), false, false, true, true);
            return SourceTreeToPsiMap.treeToPsiNotNull(reference);
        }
        return element;
    }

    public void optimizeImports(@NotNull PsiFile file) throws IncorrectOperationException {
        PsiImportList importList;
        PsiImportList newList;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "optimizeImports"));
        }
        CheckUtil.checkWritable((PsiElement)file);
        if (file instanceof PsiJavaFile && (newList = this.prepareOptimizeImportsResult((PsiJavaFile)file)) != null && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            importList.replace((PsiElement)newList);
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "prepareOptimizeImportsResult"));
        }
        return new ImportHelper(this.getSettings()).prepareOptimizeImportsResult(file);
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "addImport"));
        }
        return new ImportHelper(this.getSettings()).addImport(file, refClass);
    }

    public void removeRedundantImports(@NotNull PsiJavaFile file) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "removeRedundantImports"));
        }
        Collection<PsiImportStatementBase> redundant = this.findRedundantImports(file);
        if (redundant == null) {
            return;
        }
        for (PsiImportStatementBase importStatement : redundant) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || ref.resolve() == null) continue;
            importStatement.delete();
        }
    }

    @Nullable
    public Collection<PsiImportStatementBase> findRedundantImports(final PsiJavaFile file) {
        THashSet redundant;
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            return null;
        }
        Object[] imports = importList.getAllImportStatements();
        if (imports.length == 0) {
            return null;
        }
        THashSet allImports = new THashSet(Arrays.asList(imports));
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            redundant = ContainerUtil.newIdentityTroveSet();
            ContainerUtil.addAll((Collection)redundant, (Object[])imports);
            redundant.removeAll((Collection<?>)allImports);
            for (Object importStatement : imports) {
                if (!(importStatement instanceof JspxImportStatement) || !importStatement.isForeignFileImport()) continue;
                redundant.remove(importStatement);
            }
        } else {
            redundant = allImports;
            List roots = file.getViewProvider().getAllFiles();
            for (PsiFile root : roots) {
                root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Collection)redundant){
                    final /* synthetic */ Collection val$redundant;
                    {
                        this.val$redundant = collection;
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        PsiElement resolveScope;
                        JavaResolveResult resolveResult;
                        if (!reference.isQualified() && !this.inTheSamePackage(file, (resolveResult = reference.advancedResolve(false)).getElement()) && (resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
                            PsiImportStatementBase importStatementBase = (PsiImportStatementBase)resolveScope;
                            this.val$redundant.remove(importStatementBase);
                        }
                        super.visitReferenceElement(reference);
                    }

                    private boolean inTheSamePackage(PsiJavaFile file2, PsiElement element) {
                        PsiFile containingFile;
                        if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                            return Comparing.strEqual((String)file2.getPackageName(), (String)((PsiJavaFile)containingFile).getPackageName());
                        }
                        return false;
                    }
                });
            }
        }
        return redundant;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "findEntryIndex"));
        }
        return new ImportHelper(this.getSettings()).findEntryIndex(statement);
    }

    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestCompiledParameterName"));
        }
        return new SuggestedNameInfo(this.suggestVariableNameByType(type, VariableKind.PARAMETER, true, true)){};
    }

    public SuggestedNameInfo suggestVariableName(final @NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type, boolean correctKeywords) {
        NamesByExprInfo namesByExpr;
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestVariableName"));
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (expr != null && type == null) {
            type = expr.getType();
        }
        if (propertyName != null) {
            Object[] namesByName = this.getSuggestionsByName(propertyName, kind, false, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByName, kind, propertyName, null);
            ContainerUtil.addAll(names, (Object[])namesByName);
        }
        if (expr != null) {
            namesByExpr = this.suggestVariableNameByExpression(expr, kind, correctKeywords);
            if (namesByExpr.propertyName != null) {
                JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesByExpr.names, kind, namesByExpr.propertyName, null);
            }
            ContainerUtil.addAll(names, (Object[])namesByExpr.names);
        } else {
            namesByExpr = null;
        }
        if (type != null) {
            Object[] namesByType = this.suggestVariableNameByType(type, kind, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByType, kind, null, type);
            ContainerUtil.addAll(names, (Object[])namesByType);
        }
        final String _propertyName = propertyName != null ? propertyName : (namesByExpr != null ? namesByExpr.propertyName : null);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(names, kind, _propertyName, type);
        String[] namesArray = ArrayUtil.toStringArray(names);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind, _propertyName, type);
        final PsiType _type = type;
        return new SuggestedNameInfo(namesArray){

            public void nameChosen(String name) {
                if (_propertyName != null || _type != null && _type.isValid()) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name, (VariableKind)kind, (String)_propertyName, (PsiType)_type);
                }
            }
        };
    }

    private static void addNamesFromStatistics(Set<String> names, VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type) {
        String[] allNames = JavaStatisticsManager.getAllVariableNamesUsed((VariableKind)variableKind, (String)propertyName, (PsiType)type);
        int maxFrequency = 0;
        for (String name : allNames) {
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            maxFrequency = Math.max(maxFrequency, count);
        }
        int frequencyLimit = Math.max(5, maxFrequency / 2);
        for (String name : allNames) {
            if (names.contains(name)) continue;
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
            if (LOG.isDebugEnabled()) {
                LOG.debug("new name:" + name + " count:" + count);
                LOG.debug("frequencyLimit:" + frequencyLimit);
            }
            if (count < frequencyLimit) continue;
            names.add(name);
        }
        if (propertyName != null && type != null) {
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, propertyName, null);
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, null, type);
        }
    }

    private String[] suggestVariableNameByType(PsiType type, VariableKind variableKind, boolean correctKeywords) {
        return this.suggestVariableNameByType(type, variableKind, correctKeywords, false);
    }

    private String[] suggestVariableNameByType(PsiType type, VariableKind variableKind, boolean correctKeywords, boolean skipIndices) {
        String typeName;
        String longTypeName = skipIndices ? type.getCanonicalText() : JavaCodeStyleManagerImpl.getLongTypeName(type);
        CodeStyleSettings.TypeToNameMap map = this.getMapByVariableKind(variableKind);
        if (map != null && longTypeName != null) {
            String name;
            if (type.equals(PsiType.NULL)) {
                longTypeName = "java.lang.Object";
            }
            if ((name = map.nameByType(longTypeName)) != null && this.isIdentifier(name)) {
                return new String[]{name};
            }
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        if (!skipIndices) {
            this.suggestNamesForCollectionInheritors(type, variableKind, suggestions, correctKeywords);
            this.suggestNamesFromGenericParameters(type, variableKind, suggestions, correctKeywords);
        }
        if ((typeName = JavaCodeStyleManagerImpl.getTypeName(type, !skipIndices)) != null) {
            typeName = JavaCodeStyleManagerImpl.normalizeTypeName(typeName);
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(typeName, variableKind, type instanceof PsiArrayType, correctKeywords));
        }
        return ArrayUtil.toStringArray(suggestions);
    }

    private void suggestNamesFromGenericParameters(PsiType type, VariableKind variableKind, Collection<String> suggestions, boolean correctKeywords) {
        PsiType[] parameters;
        if (!(type instanceof PsiClassType)) {
            return;
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        for (PsiType parameter : parameters = ((PsiClassType)type).getParameters()) {
            String typeName;
            if (!(parameter instanceof PsiClassType) || (typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(parameter))) == null) continue;
            fullNameBuilder.append(typeName);
        }
        String baseName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(type));
        if (baseName != null) {
            fullNameBuilder.append(baseName);
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(fullNameBuilder.toString(), variableKind, false, correctKeywords));
        }
    }

    private void suggestNamesForCollectionInheritors(PsiType type, VariableKind variableKind, Collection<String> suggestions, boolean correctKeywords) {
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
        if (componentType == null || componentType.equals(type)) {
            return;
        }
        String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(componentType));
        if (typeName != null) {
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(typeName, variableKind, true, correctKeywords));
        }
    }

    @Nullable
    private static String normalizeTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @Nullable
    private static String getTypeName(PsiType type) {
        return JavaCodeStyleManagerImpl.getTypeName(type, true);
    }

    @Nullable
    private static String getTypeName(PsiType type, boolean withIndices) {
        if ((type = type.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            String className = classType.getClassName();
            if (className != null || !withIndices) {
                return className;
            }
            PsiClass aClass = classType.resolve();
            return aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getClassName() : null;
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getPresentableText();
        }
        if (type instanceof PsiWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiWildcardType)type).getExtendsBound(), withIndices);
        }
        if (type instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiIntersectionType)type).getRepresentative(), withIndices);
        }
        if (type instanceof PsiCapturedWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName((PsiType)((PsiCapturedWildcardType)type).getWildcard(), withIndices);
        }
        if (type instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiDisjunctionType)type).getLeastUpperBound(), withIndices);
        }
        return null;
    }

    @Nullable
    private static String getLongTypeName(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type).resolve();
            if (aClass == null) {
                return null;
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                return baseClass != null ? baseClass.getQualifiedName() : null;
            }
            return aClass.getQualifiedName();
        }
        if (type instanceof PsiArrayType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiArrayType)type).getComponentType()) + "[]";
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getPresentableText();
        }
        if (type instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type).getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type).getWildcard().getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiIntersectionType)type).getRepresentative());
        }
        if (type instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiDisjunctionType)type).getLeastUpperBound());
        }
        return null;
    }

    private NamesByExprInfo suggestVariableNameByExpression(PsiExpression expr, VariableKind variableKind, boolean correctKeywords) {
        LinkedHashSet names = new LinkedHashSet();
        Object[] fromLiterals = this.suggestVariableNameFromLiterals(expr, variableKind, correctKeywords);
        if (fromLiterals != null) {
            ContainerUtil.addAll(names, (Object[])fromLiterals);
        }
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionOnly((PsiExpression)expr, (VariableKind)variableKind, (boolean)correctKeywords, (boolean)false).names);
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionPlace((PsiExpression)expr, (VariableKind)variableKind, (boolean)correctKeywords).names);
        PsiType type = expr.getType();
        if (type != null) {
            ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByType(type, variableKind, correctKeywords));
        }
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionOnly((PsiExpression)expr, (VariableKind)variableKind, (boolean)correctKeywords, (boolean)true).names);
        String[] namesArray = ArrayUtil.toStringArray(names);
        String propertyName = this.suggestVariableNameByExpressionOnly((PsiExpression)expr, (VariableKind)variableKind, (boolean)correctKeywords, (boolean)false).propertyName != null ? this.suggestVariableNameByExpressionOnly((PsiExpression)expr, (VariableKind)variableKind, (boolean)correctKeywords, (boolean)false).propertyName : this.suggestVariableNameByExpressionPlace((PsiExpression)expr, (VariableKind)variableKind, (boolean)correctKeywords).propertyName;
        return new NamesByExprInfo(propertyName, namesArray);
    }

    @Nullable
    private String[] suggestVariableNameFromLiterals(PsiExpression expr, VariableKind variableKind, boolean correctKeywords) {
        PsiElement[] literals = PsiTreeUtil.collectElements((PsiElement)expr, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiElement exprList;
                if (JavaCodeStyleManagerImpl.isStringPsiLiteral(element) && StringUtil.isJavaIdentifier((String)StringUtil.unquoteString((String)element.getText())) && (exprList = element.getParent()) instanceof PsiExpressionList) {
                    PsiElement call = exprList.getParent();
                    if (call instanceof PsiNewExpression) {
                        return true;
                    }
                    if (call instanceof PsiMethodCallExpression) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (literals.length == 1) {
            String text = StringUtil.unquoteString((String)literals[0].getText());
            return this.getSuggestionsByName(text, variableKind, expr.getType() instanceof PsiArrayType, correctKeywords);
        }
        return null;
    }

    private NamesByExprInfo suggestVariableNameByExpressionOnly(PsiExpression expr, VariableKind variableKind, boolean correctKeywords, boolean useAllMethodNames) {
        if (expr instanceof PsiMethodCallExpression) {
            String[] words;
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)expr).getMethodExpression();
            String methodName = methodExpr.getReferenceName();
            if (methodName != null && (words = NameUtil.nameToWords((String)methodName)).length > 0) {
                String firstWord = words[0];
                if (GET_PREFIX.equals(firstWord) || IS_PREFIX.equals(firstWord) || FIND_PREFIX.equals(firstWord) || CREATE_PREFIX.equals(firstWord)) {
                    if (words.length > 1) {
                        String propertyName = methodName.substring(firstWord.length());
                        Object[] names = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                        PsiExpression qualifierExpression = methodExpr.getQualifierExpression();
                        if (qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiVariable) {
                            names = (String[])ArrayUtil.append((Object[])names, (Object)StringUtil.sanitizeJavaIdentifier((String)this.changeIfNotIdentifier(qualifierExpression.getText() + StringUtil.capitalize((String)propertyName))));
                        }
                        return new NamesByExprInfo(propertyName, (String[])names);
                    }
                } else if (words.length == 1 || useAllMethodNames) {
                    return new NamesByExprInfo(methodName, this.getSuggestionsByName(methodName, variableKind, false, correctKeywords));
                }
            }
        } else if (expr instanceof PsiReferenceExpression) {
            String propertyName = ((PsiReferenceExpression)expr).getReferenceName();
            PsiElement refElement = ((PsiReferenceExpression)expr).resolve();
            if (refElement instanceof PsiVariable) {
                VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                propertyName = this.variableNameToPropertyName(propertyName, refVariableKind);
            }
            if (refElement != null && propertyName != null) {
                String[] names = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                return new NamesByExprInfo(propertyName, names);
            }
        } else if (expr instanceof PsiArrayAccessExpression) {
            PsiExpression arrayExpr = ((PsiArrayAccessExpression)expr).getArrayExpression();
            if (arrayExpr instanceof PsiReferenceExpression) {
                String name;
                String arrayName = ((PsiReferenceExpression)arrayExpr).getReferenceName();
                PsiElement refElement = ((PsiReferenceExpression)arrayExpr).resolve();
                if (refElement instanceof PsiVariable) {
                    VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                    arrayName = this.variableNameToPropertyName(arrayName, refVariableKind);
                }
                if (arrayName != null && (name = StringUtil.unpluralize((String)arrayName)) != null) {
                    String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
                    return new NamesByExprInfo(name, names);
                }
            }
        } else if (expr instanceof PsiLiteralExpression && variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String stringValue;
            String[] names;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            Object value = literalExpression.getValue();
            if (value instanceof String && (names = JavaCodeStyleManagerImpl.getSuggestionsByValue(stringValue = (String)value)).length > 0) {
                return new NamesByExprInfo(null, JavaCodeStyleManagerImpl.constantValueToConstantName(names));
            }
        } else {
            String text;
            if (expr instanceof PsiParenthesizedExpression) {
                return this.suggestVariableNameByExpressionOnly(((PsiParenthesizedExpression)expr).getExpression(), variableKind, correctKeywords, useAllMethodNames);
            }
            if (expr instanceof PsiTypeCastExpression) {
                return this.suggestVariableNameByExpressionOnly(((PsiTypeCastExpression)expr).getOperand(), variableKind, correctKeywords, useAllMethodNames);
            }
            if (expr instanceof PsiLiteralExpression && this.isIdentifier(text = StringUtil.stripQuotesAroundValue((String)expr.getText()))) {
                return new NamesByExprInfo(text, this.getSuggestionsByName(text, variableKind, false, correctKeywords));
            }
        }
        return new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private static String constantValueToConstantName(String[] names) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                result.append("_");
            }
            result.append(names[i]);
        }
        return result.toString();
    }

    private static String[] getSuggestionsByValue(String stringValue) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        boolean prevIsUpperCase = false;
        for (int i = 0; i < stringValue.length(); ++i) {
            char c = stringValue.charAt(i);
            if (Character.isUpperCase(c)) {
                if (currentWord.length() > 0 && !prevIsUpperCase) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                currentWord.append(c);
            } else if (Character.isLowerCase(c)) {
                currentWord.append(Character.toUpperCase(c));
            } else if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isJavaIdentifierStart(c) || currentWord.length() > 0 || !result.isEmpty()) {
                    currentWord.append(c);
                }
            } else if (currentWord.length() > 0) {
                result.add(currentWord.toString());
                currentWord = new StringBuffer();
            }
            prevIsUpperCase = Character.isUpperCase(c);
        }
        if (currentWord.length() > 0) {
            result.add(currentWord.toString());
        }
        return ArrayUtil.toStringArray(result);
    }

    private NamesByExprInfo suggestVariableNameByExpressionPlace(PsiExpression expr, VariableKind variableKind, boolean correctKeywords) {
        String name;
        PsiExpression leftExpression;
        PsiAssignmentExpression assignmentExpression;
        if (expr.getParent() instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)expr.getParent();
            PsiElement listParent = list.getParent();
            PsiSubstitutor subst = PsiSubstitutor.EMPTY;
            PsiMethod method = null;
            if (listParent instanceof PsiMethodCallExpression) {
                JavaResolveResult resolveResult = ((PsiMethodCallExpression)listParent).getMethodExpression().advancedResolve(false);
                method = (PsiMethod)resolveResult.getElement();
                subst = resolveResult.getSubstitutor();
            } else {
                if (listParent instanceof PsiAnonymousClass) {
                    listParent = listParent.getParent();
                }
                if (listParent instanceof PsiNewExpression) {
                    method = ((PsiNewExpression)listParent).resolveConstructor();
                }
            }
            if (method != null) {
                String name2;
                PsiParameter[] parameters;
                PsiElement navElement = method.getNavigationElement();
                if (navElement instanceof PsiMethod) {
                    method = (PsiMethod)navElement;
                }
                PsiExpression[] expressions = list.getExpressions();
                int index = -1;
                for (int i = 0; i < expressions.length; ++i) {
                    if (expressions[i] != expr) continue;
                    index = i;
                    break;
                }
                if (index < (parameters = method.getParameterList().getParameters()).length && (name2 = parameters[index].getName()) != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)subst.substitute(parameters[index].getType()), (PsiExpression)expr)) {
                    String firstWord;
                    String methodName;
                    String[] words;
                    name2 = this.variableNameToPropertyName(name2, VariableKind.PARAMETER);
                    String[] names = this.getSuggestionsByName(name2, variableKind, false, correctKeywords);
                    if (expressions.length == 1 && (words = NameUtil.nameToWords((String)(methodName = method.getName()))).length > 0 && SET_PREFIX.equals(firstWord = words[0])) {
                        String propertyName = methodName.substring(firstWord.length());
                        String[] setterNames = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                        names = ArrayUtil.mergeArrays((String[])names, (String[])setterNames);
                    }
                    return new NamesByExprInfo(name2, names);
                }
            }
        } else if (expr.getParent() instanceof PsiAssignmentExpression && variableKind == VariableKind.PARAMETER && expr == (assignmentExpression = (PsiAssignmentExpression)expr.getParent()).getRExpression() && (leftExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)leftExpression).getQualifier() == null && (name = leftExpression.getText()) != null) {
            PsiElement resolve = ((PsiReferenceExpression)leftExpression).resolve();
            if (resolve instanceof PsiVariable) {
                name = this.variableNameToPropertyName(name, this.getVariableKind((PsiVariable)resolve));
            }
            String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
            return new NamesByExprInfo(name, names);
        }
        return new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public String variableNameToPropertyName(String name, VariableKind variableKind) {
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != '_') {
                    if (Character.isLowerCase(c)) {
                        return this.variableNameToPropertyNameInner(name, variableKind);
                    }
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (++i >= name.length()) continue;
                c = name.charAt(i);
                buffer.append(c);
            }
            return buffer.toString();
        }
        return this.variableNameToPropertyNameInner(name, variableKind);
    }

    private String variableNameToPropertyNameInner(String name, VariableKind variableKind) {
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        boolean doDecapitalize = false;
        int pLength = prefix.length();
        if (pLength > 0 && name.startsWith(prefix) && name.length() > pLength && (!Character.isLetter(prefix.charAt(pLength - 1)) || Character.isUpperCase(name.charAt(pLength)))) {
            name = name.substring(pLength);
            doDecapitalize = true;
        }
        if (name.endsWith(suffix) && name.length() > suffix.length()) {
            name = name.substring(0, name.length() - suffix.length());
            doDecapitalize = true;
        }
        if (doDecapitalize) {
            name = Introspector.decapitalize(name);
        }
        return name;
    }

    public String propertyNameToVariableName(String propertyName, VariableKind variableKind) {
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String[] words = NameUtil.nameToWords((String)propertyName);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (i > 0) {
                    buffer.append("_");
                }
                buffer.append(StringUtil.toUpperCase((String)word));
            }
            return buffer.toString();
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String name = propertyName;
        if (!(name.isEmpty() || prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_'))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        name = prefix + name + this.getSuffixByVariableKind(variableKind);
        name = this.changeIfNotIdentifier(name);
        return name;
    }

    private String[] getSuggestionsByName(String name, VariableKind variableKind, boolean isArray, boolean correctKeywords) {
        boolean upperCaseStyle = variableKind == VariableKind.STATIC_FINAL_FIELD;
        boolean preferLongerNames = this.getSettings().PREFER_LONGER_NAMES;
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : NameUtil.getSuggestionsByName((String)name, (String)prefix, (String)suffix, (boolean)upperCaseStyle, (boolean)preferLongerNames, (boolean)isArray)) {
            answer.add(correctKeywords ? this.changeIfNotIdentifier(suggestion) : suggestion);
        }
        return ArrayUtil.toStringArray(answer);
    }

    public String suggestUniqueVariableName(String baseName, PsiElement place, boolean lookForward) {
        String name;
        int index = 0;
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMethod.class});
        block2: while (true) {
            name = baseName;
            if (index > 0) {
                name = name + index;
            }
            ++index;
            if (!PsiUtil.isVariableNameUnique((String)name, (PsiElement)place)) continue;
            if (!lookForward) break;
            final String name1 = name;
            for (PsiElement run = scope; run != null; run = run.getNextSibling()) {
                class CancelException
                extends RuntimeException {
                    CancelException() {
                    }
                }
                try {
                    run.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitAnonymousClass(PsiAnonymousClass aClass) {
                        }

                        public void visitVariable(PsiVariable variable) {
                            if (name1.equals(variable.getName())) {
                                throw new CancelException();
                            }
                        }
                    });
                    continue;
                }
                catch (CancelException e) {
                    continue block2;
                }
            }
            break;
        }
        return name;
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        String[] names = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names.length);
        for (String name : names) {
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual((String)(placeName = ((PsiNamedElement)place).getName()), (String)name)) {
                uniqueNames.add(name);
                continue;
            }
            uniqueNames.add(this.suggestUniqueVariableName(name, place, lookForward));
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray(uniqueNames)){

            public void nameChosen(String name) {
                baseNameInfo.nameChosen(name);
            }
        };
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "suggestUniqueVariableName"));
        }
        return suggestedNameInfo;
    }

    private static void sortVariableNameSuggestions(String[] names, final VariableKind variableKind, final @Nullable String propertyName, final @Nullable PsiType type) {
        if (names.length <= 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorting names:" + variableKind);
            if (propertyName != null) {
                LOG.debug("propertyName:" + propertyName);
            }
            if (type != null) {
                LOG.debug("type:" + type);
            }
            for (String name : names) {
                int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                LOG.debug(name + " : " + count);
            }
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int count1 = JavaStatisticsManager.getVariableNameUseCount((String)s1, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                int count2 = JavaStatisticsManager.getVariableNameUseCount((String)s2, (VariableKind)variableKind, (String)propertyName, (PsiType)type);
                return count2 - count1;
            }
        };
        Arrays.sort(names, comparator);
    }

    @NotNull
    public String getPrefixByVariableKind(VariableKind variableKind) {
        String prefix = "";
        switch (variableKind) {
            case FIELD: {
                prefix = this.getSettings().FIELD_NAME_PREFIX;
                break;
            }
            case STATIC_FIELD: {
                prefix = this.getSettings().STATIC_FIELD_NAME_PREFIX;
                break;
            }
            case PARAMETER: {
                prefix = this.getSettings().PARAMETER_NAME_PREFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                prefix = this.getSettings().LOCAL_VARIABLE_NAME_PREFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                prefix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        String string = prefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getPrefixByVariableKind"));
        }
        return string;
    }

    @NotNull
    public String getSuffixByVariableKind(VariableKind variableKind) {
        String suffix = "";
        switch (variableKind) {
            case FIELD: {
                suffix = this.getSettings().FIELD_NAME_SUFFIX;
                break;
            }
            case STATIC_FIELD: {
                suffix = this.getSettings().STATIC_FIELD_NAME_SUFFIX;
                break;
            }
            case PARAMETER: {
                suffix = this.getSettings().PARAMETER_NAME_SUFFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                suffix = this.getSettings().LOCAL_VARIABLE_NAME_SUFFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                suffix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (suffix == null) {
            suffix = "";
        }
        String string = suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl", "getSuffixByVariableKind"));
        }
        return string;
    }

    @Nullable
    private CodeStyleSettings.TypeToNameMap getMapByVariableKind(VariableKind variableKind) {
        if (variableKind == VariableKind.FIELD) {
            return this.getSettings().FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.STATIC_FIELD) {
            return this.getSettings().STATIC_FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.PARAMETER) {
            return this.getSettings().PARAMETER_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.LOCAL_VARIABLE) {
            return this.getSettings().LOCAL_VARIABLE_TYPE_TO_NAME;
        }
        return null;
    }

    @NonNls
    private String changeIfNotIdentifier(String name) {
        if (!this.isIdentifier(name)) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    private boolean isIdentifier(String name) {
        return PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name, LanguageLevel.HIGHEST);
    }

    private CodeStyleSettings getSettings() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject);
    }

    public static boolean isStringPsiLiteral(PsiElement element) {
        if (element instanceof PsiLiteralExpression) {
            String text = element.getText();
            return text.length() > 1 && StringUtil.isQuotedString((String)text);
        }
        return false;
    }

    private static class NamesByExprInfo {
        final String[] names;
        final String propertyName;

        public NamesByExprInfo(String propertyName, String ... names) {
            this.names = names;
            this.propertyName = propertyName;
        }
    }
}

