/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeInsight.ImportFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ImportHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.ImportHelper");
    private final CodeStyleSettings mySettings;
    @NonNls
    private static final String JAVA_LANG_PACKAGE = "java.lang";

    public ImportHelper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "<init>"));
        }
        this.mySettings = settings;
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "prepareOptimizeImportsResult"));
        }
        ArrayList<PsiElement> nonImports = new ArrayList<PsiElement>();
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>(ImportHelper.collectNamesToImport(file, nonImports));
        Collections.sort(names, new Comparator<Pair<String, Boolean>>(){

            @Override
            public int compare(Pair<String, Boolean> o1, Pair<String, Boolean> o2) {
                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            }
        });
        List<Pair<String, Boolean>> resultList = ImportHelper.sortItemsAccordingToSettings(names, this.mySettings);
        THashSet classesOrPackagesToImportOnDemand = new THashSet();
        ImportHelper.collectOnDemandImports(resultList, (Set<String>)classesOrPackagesToImportOnDemand, this.mySettings);
        Set<String> classesToUseSingle = ImportHelper.findSingleImports(file, resultList, (Set<String>)classesOrPackagesToImportOnDemand);
        THashSet toReimport = new THashSet();
        ImportHelper.calcClassesConflictingViaOnDemandImports(file, (Collection<String>)classesOrPackagesToImportOnDemand, file.getResolveScope(), (Set<String>)toReimport);
        classesToUseSingle.addAll((Collection<String>)toReimport);
        try {
            StringBuilder text = ImportHelper.buildImportListText(resultList, (Set<String>)classesOrPackagesToImportOnDemand, classesToUseSingle);
            for (PsiElement nonImport : nonImports) {
                text.append("\n").append(nonImport.getText());
            }
            String ext = StdFileTypes.JAVA.getDefaultExtension();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)file.getProject());
            PsiJavaFile dummyFile = (PsiJavaFile)factory.createFileFromText("_Dummy_." + ext, (FileType)StdFileTypes.JAVA, (CharSequence)text);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file.getProject());
            codeStyleManager.reformat((PsiElement)dummyFile);
            PsiImportList newImportList = dummyFile.getImportList();
            PsiImportList result = (PsiImportList)newImportList.copy();
            PsiImportList oldList = file.getImportList();
            if (oldList.isReplaceEquivalent(result)) {
                return null;
            }
            if (!nonImports.isEmpty()) {
                PsiElement element;
                for (PsiElement firstPrevious = newImportList.getPrevSibling(); firstPrevious != null && firstPrevious.getPrevSibling() != null; firstPrevious = firstPrevious.getPrevSibling()) {
                }
                for (element = firstPrevious; element != null && element != newImportList; element = element.getNextSibling()) {
                    result.add(element.copy());
                }
                for (element = newImportList.getNextSibling(); element != null; element = element.getNextSibling()) {
                    result.add(element.copy());
                }
            }
            return result;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static void collectOnDemandImports(List<Pair<String, Boolean>> resultList, final Set<String> classesOrPackagesToImportOnDemand, final CodeStyleSettings settings) {
        TObjectIntHashMap packageToCountMap = new TObjectIntHashMap();
        TObjectIntHashMap classToCountMap = new TObjectIntHashMap();
        for (Pair<String, Boolean> pair : resultList) {
            int count;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name);
            if (packageOrClassName.isEmpty()) continue;
            if (isStatic.booleanValue()) {
                count = classToCountMap.get((Object)packageOrClassName);
                classToCountMap.put((Object)packageOrClassName, count + 1);
                continue;
            }
            count = packageToCountMap.get((Object)packageOrClassName);
            packageToCountMap.put((Object)packageOrClassName, count + 1);
        }
        class MyVisitorProcedure
        implements TObjectIntProcedure<String> {
            private final boolean myIsVisitingPackages;

            MyVisitorProcedure(boolean isVisitingPackages) {
                this.myIsVisitingPackages = isVisitingPackages;
            }

            public boolean execute(String packageOrClassName, int count) {
                if (ImportHelper.isToUseImportOnDemand(packageOrClassName, count, !this.myIsVisitingPackages, settings)) {
                    classesOrPackagesToImportOnDemand.add(packageOrClassName);
                }
                return true;
            }
        }
        classToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(false));
        packageToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(true));
    }

    public static List<Pair<String, Boolean>> sortItemsAccordingToSettings(List<Pair<String, Boolean>> names, CodeStyleSettings settings) {
        int[] entryForName = ArrayUtil.newIntArray((int)names.size());
        PackageEntry[] entries = settings.IMPORT_LAYOUT_TABLE.getEntries();
        for (int i = 0; i < names.size(); ++i) {
            Pair<String, Boolean> pair = names.get(i);
            String packageName = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            entryForName[i] = ImportHelper.findEntryIndex(packageName, isStatic, entries);
        }
        ArrayList<Pair<String, Boolean>> resultList = new ArrayList<Pair<String, Boolean>>(names.size());
        for (int i = 0; i < entries.length; ++i) {
            for (int j = 0; j < names.size(); ++j) {
                if (entryForName[j] != i) continue;
                resultList.add(names.get(j));
                names.set(j, null);
            }
        }
        for (Pair<String, Boolean> name : names) {
            if (name == null) continue;
            resultList.add(name);
        }
        return resultList;
    }

    @NotNull
    private static Set<String> findSingleImports(@NotNull PsiJavaFile file, @NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> onDemandImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        if (onDemandImports == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        GlobalSearchScope resolveScope = file.getResolveScope();
        THashSet namesToUseSingle = new THashSet();
        String thisPackageName = file.getPackageName();
        THashSet implicitlyImportedPackages = new THashSet(Arrays.asList(file.getImplicitlyImportedPackages()));
        PsiManager manager = file.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        ArrayList<PsiClass> onDemandElements = new ArrayList<PsiClass>(onDemandImports.size());
        ArrayList<String> onDemandImportsList = new ArrayList<String>(onDemandImports);
        for (String string : onDemandImportsList) {
            PsiClass aClass = facade.findClass(string, resolveScope);
            onDemandElements.add(aClass);
        }
        for (Pair pair : names) {
            String langPackageClass;
            String thisPackageClass;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String prefix = ImportHelper.getPackageOrClassName(name);
            if (prefix.isEmpty()) continue;
            boolean isImplicitlyImported = implicitlyImportedPackages.contains(prefix);
            if (!onDemandImports.contains(prefix) && !isImplicitlyImported) continue;
            String shortName = PsiNameHelper.getShortClassName((String)name);
            String string = thisPackageClass = !thisPackageName.isEmpty() ? thisPackageName + "." + shortName : shortName;
            if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(thisPackageClass, resolveScope) != null) {
                namesToUseSingle.add(name);
                continue;
            }
            if (!isImplicitlyImported && facade.findClass(langPackageClass = "java.lang." + shortName, resolveScope) != null) {
                namesToUseSingle.add(name);
                continue;
            }
            for (int i = 0; i < onDemandImportsList.size(); ++i) {
                String onDemandName = (String)onDemandImportsList.get(i);
                if (prefix.equals(onDemandName)) continue;
                if (isStatic.booleanValue()) {
                    PsiMethod[] methods;
                    PsiElement element = (PsiElement)onDemandElements.get(i);
                    PsiClass aClass = (PsiClass)element;
                    if (aClass == null) continue;
                    PsiField field = aClass.findFieldByName(shortName, true);
                    if (field != null && field.hasModifierProperty("static")) {
                        namesToUseSingle.add(name);
                        continue;
                    }
                    PsiClass inner = aClass.findInnerClassByName(shortName, true);
                    if (inner != null && inner.hasModifierProperty("static")) {
                        namesToUseSingle.add(name);
                        continue;
                    }
                    for (PsiMethod method : methods = aClass.findMethodsByName(shortName, true)) {
                        if (!method.hasModifierProperty("static")) continue;
                        namesToUseSingle.add(name);
                    }
                    continue;
                }
                PsiClass aClass = facade.findClass(onDemandName + "." + shortName, resolveScope);
                if (aClass == null) continue;
                namesToUseSingle.add(name);
            }
        }
        THashSet tHashSet = namesToUseSingle;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        return tHashSet;
    }

    private static void calcClassesConflictingViaOnDemandImports(PsiJavaFile file, Collection<String> onDemandImportsList, GlobalSearchScope resolveScope, Set<String> namesToUseSingle) {
        ArrayList<String> onDemands = new ArrayList<String>(Arrays.asList(file.getImplicitlyImportedPackages()));
        for (String onDemand : onDemandImportsList) {
            if (onDemands.contains(onDemand)) continue;
            onDemands.add(onDemand);
        }
        if (onDemands.size() < 2) {
            return;
        }
        THashMap classNames = new THashMap();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        for (int i = onDemands.size() - 1; i >= 0; --i) {
            String onDemand = (String)onDemands.get(i);
            PsiPackage aPackage = facade.findPackage(onDemand);
            if (aPackage == null) {
                onDemands.remove(i);
                continue;
            }
            PsiClass[] psiClasses = aPackage.getClasses(resolveScope);
            THashSet set = new THashSet(psiClasses.length);
            for (PsiClass psiClass : psiClasses) {
                set.add(psiClass.getName());
            }
            classNames.put(onDemand, set);
        }
        THashSet conflicts = new THashSet();
        for (int i = 0; i < onDemands.size(); ++i) {
            String on1 = (String)onDemands.get(i);
            for (int j = i + 1; j < onDemands.size(); ++j) {
                String on2 = (String)onDemands.get(j);
                THashSet inter = new THashSet((Collection)classNames.get(on1));
                inter.retainAll((Collection)classNames.get(on2));
                conflicts.addAll(inter);
            }
        }
        if (!conflicts.isEmpty() && !(file instanceof PsiCompiledElement)) {
            file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)conflicts, namesToUseSingle){
                final /* synthetic */ Set val$conflicts;
                final /* synthetic */ Set val$namesToUseSingle;
                {
                    this.val$conflicts = set;
                    this.val$namesToUseSingle = set2;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    if (reference.getQualifier() != null) {
                        return;
                    }
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass && this.val$conflicts.contains(((PsiClass)element).getName())) {
                        String fqn = ((PsiClass)element).getQualifiedName();
                        this.val$namesToUseSingle.add(fqn);
                    }
                }
            });
        }
    }

    @NotNull
    private static StringBuilder buildImportListText(@NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> packagesOrClassesToImportOnDemand, @NotNull Set<String> namesToUseSingle) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        if (packagesOrClassesToImportOnDemand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        if (namesToUseSingle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        THashSet importedPackagesOrClasses = new THashSet();
        StringBuilder buffer = new StringBuilder();
        for (Pair<String, Boolean> pair : names) {
            boolean useOnDemand;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name);
            boolean implicitlyImported = JAVA_LANG_PACKAGE.equals(packageOrClassName);
            boolean bl = useOnDemand = implicitlyImported || packagesOrClassesToImportOnDemand.contains(packageOrClassName);
            if (useOnDemand && namesToUseSingle.remove(name)) {
                useOnDemand = false;
            }
            Pair current = Pair.create((Object)packageOrClassName, (Object)isStatic);
            if (useOnDemand && (importedPackagesOrClasses.contains(current) || implicitlyImported)) continue;
            buffer.append("import ");
            if (isStatic.booleanValue()) {
                buffer.append("static ");
            }
            if (useOnDemand) {
                importedPackagesOrClasses.add(current);
                buffer.append(packageOrClassName);
                buffer.append(".*");
            } else {
                buffer.append(name);
            }
            buffer.append(";\n");
        }
        for (String remainingSingle : namesToUseSingle) {
            buffer.append("import ");
            buffer.append(remainingSingle);
            buffer.append(";\n");
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        return stringBuilder;
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        PsiPackage conflictPackageRef;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addImport"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        PsiResolveHelper helper = facade.getResolveHelper();
        String className = refClass.getQualifiedName();
        if (className == null) {
            return true;
        }
        if (!ImportFilter.shouldImport((PsiFile)file, (String)className)) {
            return false;
        }
        String packageName = ImportHelper.getPackageOrClassName(className);
        String shortName = PsiNameHelper.getShortClassName((String)className);
        PsiClass conflictSingleRef = ImportHelper.findSingleImportByShortName(file, shortName);
        if (conflictSingleRef != null) {
            return className.equals(conflictSingleRef.getQualifiedName());
        }
        PsiClass curRefClass = helper.resolveReferencedClass(shortName, (PsiElement)file);
        if (file.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)curRefClass)) {
            return true;
        }
        boolean useOnDemand = true;
        if (packageName.isEmpty()) {
            useOnDemand = false;
        }
        if ((conflictPackageRef = ImportHelper.findImportOnDemand(file, packageName)) != null) {
            useOnDemand = false;
        }
        ArrayList<PsiClass> classesToReimport = new ArrayList<PsiClass>();
        List<PsiJavaCodeReferenceElement> importRefs = ImportHelper.getImportsFromPackage(file, packageName);
        if (useOnDemand) {
            if (this.mySettings.USE_SINGLE_CLASS_IMPORTS && importRefs.size() + 1 < this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND && !this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(packageName)) {
                useOnDemand = false;
            }
            if (curRefClass != null) {
                useOnDemand = true;
            }
            if (useOnDemand) {
                PsiElement[] onDemandRefs = file.getOnDemandImports(false, true);
                ArrayList<String> refTexts = new ArrayList<String>(onDemandRefs.length);
                for (PsiElement ref : onDemandRefs) {
                    String refName = ref instanceof PsiClass ? ((PsiClass)ref).getQualifiedName() : ((PsiPackage)ref).getQualifiedName();
                    refTexts.add(refName);
                }
                ImportHelper.calcClassesToReimport(file, facade, helper, packageName, classesToReimport, refTexts);
            }
        }
        if (useOnDemand && curRefClass != null && refClass.getContainingClass() != null && this.mySettings.INSERT_INNER_CLASS_IMPORTS && JAVA_LANG_PACKAGE.equals(StringUtil.getPackageName((String)curRefClass.getQualifiedName()))) {
            return false;
        }
        try {
            PsiImportList importList = file.getImportList();
            PsiImportStatement statement = useOnDemand ? factory.createImportStatementOnDemand(packageName) : factory.createImportStatement(refClass);
            importList.add((PsiElement)statement);
            if (useOnDemand) {
                for (PsiJavaCodeReferenceElement ref : importRefs) {
                    PsiImportStatement importStatement;
                    LOG.assertTrue(ref.getParent() instanceof PsiImportStatement);
                    if (!ref.isValid() || (importStatement = (PsiImportStatement)ref.getParent()).isForeignFileImport()) continue;
                    classesToReimport.add((PsiClass)ref.resolve());
                    importStatement.delete();
                }
            }
            for (PsiClass aClass : classesToReimport) {
                if (aClass == null) continue;
                this.addImport(file, aClass);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static void calcClassesToReimport(PsiJavaFile file, JavaPsiFacade facade, PsiResolveHelper helper, String packageName, List<PsiClass> classesToReimport, Collection<String> onDemandRefs) {
        if (onDemandRefs.isEmpty()) {
            return;
        }
        PsiPackage aPackage = facade.findPackage(packageName);
        if (aPackage != null) {
            PsiDirectory[] dirs = aPackage.getDirectories();
            GlobalSearchScope resolveScope = file.getResolveScope();
            for (PsiDirectory dir : dirs) {
                PsiFile[] files;
                for (PsiFile aFile : files = dir.getFiles()) {
                    if (!(aFile instanceof PsiJavaFile)) continue;
                    String name = aFile.getVirtualFile().getNameWithoutExtension();
                    for (String refName : onDemandRefs) {
                        String conflictClassName2;
                        PsiClass conflictClass2;
                        String conflictClassName = refName + "." + name;
                        PsiClass conflictClass = facade.findClass(conflictClassName, resolveScope);
                        if (conflictClass == null || !helper.isAccessible((PsiMember)conflictClass, (PsiElement)file, null) || (conflictClass2 = facade.findClass(conflictClassName2 = packageName + "." + name, resolveScope)) == null || !helper.isAccessible((PsiMember)conflictClass2, (PsiElement)file, null) || ReferencesSearch.search((PsiElement)conflictClass, (SearchScope)new LocalSearchScope((PsiElement)file), (boolean)false).findFirst() == null) continue;
                        classesToReimport.add(conflictClass);
                    }
                }
            }
        }
    }

    @NotNull
    private static List<PsiJavaCodeReferenceElement> getImportsFromPackage(@NotNull PsiJavaFile file, @NotNull String packageName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getImportsFromPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getImportsFromPackage"));
        }
        PsiClass[] refs = file.getSingleClassImports(true);
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiClass ref1 : refs) {
            PsiJavaCodeReferenceElement ref;
            String className = ref1.getQualifiedName();
            if (!ImportHelper.getPackageOrClassName(className).equals(packageName) || (ref = file.findImportReferenceTo(ref1)) == null) continue;
            array.add(ref);
        }
        ArrayList<PsiJavaCodeReferenceElement> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getImportsFromPackage"));
        }
        return arrayList;
    }

    private static PsiClass findSingleImportByShortName(final @NotNull PsiJavaFile file, @NotNull String shortClassName) {
        String className;
        PsiClass[] refs;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImportByShortName"));
        }
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImportByShortName"));
        }
        for (PsiClass ref : refs = file.getSingleClassImports(true)) {
            className = ref.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return ref;
        }
        for (PsiClass aClass : file.getClasses()) {
            className = aClass.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return aClass;
        }
        String packageName = file.getPackageName();
        if (!StringUtil.isEmptyOrSpaces((String)packageName)) {
            String fqn = packageName + "." + shortClassName;
            final PsiClass aClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(fqn, file.getResolveScope());
            if (aClass != null) {
                final boolean[] foundRef = new boolean[]{false};
                file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (foundRef[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        if (file.getManager().areElementsEquivalent(reference.resolve(), (PsiElement)aClass)) {
                            foundRef[0] = true;
                        }
                        super.visitReferenceElement(reference);
                    }
                });
                if (foundRef[0]) {
                    return aClass;
                }
            }
        }
        return null;
    }

    private static PsiPackage findImportOnDemand(@NotNull PsiJavaFile file, @NotNull String packageName) {
        PsiElement[] refs;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findImportOnDemand"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findImportOnDemand"));
        }
        for (PsiElement ref : refs = file.getOnDemandImports(false, true)) {
            if (!(ref instanceof PsiPackage) || !((PsiPackage)ref).getQualifiedName().equals(packageName)) continue;
            return (PsiPackage)ref;
        }
        return null;
    }

    public ASTNode getDefaultAnchor(@NotNull PsiImportList list, @NotNull PsiImportStatementBase statement) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getDefaultAnchor"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getDefaultAnchor"));
        }
        PsiJavaCodeReferenceElement ref = statement.getImportReference();
        if (ref == null) {
            return null;
        }
        int entryIndex = this.findEntryIndex(statement);
        PsiImportStatementBase[] allStatements = list.getAllImportStatements();
        int[] entries = ArrayUtil.newIntArray((int)allStatements.length);
        ArrayList<PsiImportStatementBase> statements = new ArrayList<PsiImportStatementBase>();
        for (int i = 0; i < allStatements.length; ++i) {
            int entryIndex1;
            PsiImportStatementBase statement1 = allStatements[i];
            entries[i] = entryIndex1 = this.findEntryIndex(statement1);
            if (entryIndex1 != entryIndex) continue;
            statements.add(statement1);
        }
        if (statements.isEmpty()) {
            int index;
            for (index = entries.length - 1; index >= 0 && entries[index] >= entryIndex; --index) {
            }
            return ++index < entries.length ? SourceTreeToPsiMap.psiElementToTree((PsiElement)allStatements[index]) : null;
        }
        String refText = ref.getCanonicalText();
        if (statement.isOnDemand()) {
            refText = refText + ".";
        }
        PsiImportStatementBase insertBefore = null;
        PsiImportStatementBase insertAfter = null;
        for (PsiImportStatementBase statement1 : statements) {
            int comp;
            PsiJavaCodeReferenceElement ref1 = statement1.getImportReference();
            if (ref1 == null) continue;
            String refTextThis = ref1.getCanonicalText();
            if (statement1.isOnDemand()) {
                refTextThis = refTextThis + ".";
            }
            if ((comp = Comparing.compare((Comparable)((Object)refText), (Comparable)((Object)refTextThis))) < 0 && insertBefore == null) {
                insertBefore = statement1;
            }
            if (comp <= 0) continue;
            insertAfter = statement1;
        }
        if (insertBefore != null) {
            return insertBefore.getNode();
        }
        if (insertAfter != null) {
            return insertAfter.getNode().getTreeNext();
        }
        return null;
    }

    public int getEmptyLinesBetween(@NotNull PsiImportStatementBase statement1, @NotNull PsiImportStatementBase statement2) {
        int index2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getEmptyLinesBetween"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getEmptyLinesBetween"));
        }
        int index1 = this.findEntryIndex(statement1);
        if (index1 == (index2 = this.findEntryIndex(statement2))) {
            return 0;
        }
        if (index1 > index2) {
            int t = index1;
            index1 = index2;
            index2 = t;
        }
        PackageEntry[] entries = this.mySettings.IMPORT_LAYOUT_TABLE.getEntries();
        int maxSpace = 0;
        for (int i = index1 + 1; i < index2; ++i) {
            if (entries[i] != PackageEntry.BLANK_LINE_ENTRY) continue;
            int space = 0;
            do {
                ++space;
            } while (entries[++i] == PackageEntry.BLANK_LINE_ENTRY);
            maxSpace = Math.max(maxSpace, space);
        }
        return maxSpace;
    }

    private static boolean isToUseImportOnDemand(@NotNull String packageName, int classCount, boolean isStaticImportNeeded, CodeStyleSettings settings) {
        int limitCount;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isToUseImportOnDemand"));
        }
        if (!settings.USE_SINGLE_CLASS_IMPORTS) {
            return true;
        }
        int n = limitCount = isStaticImportNeeded ? settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND : settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
        if (classCount >= limitCount) {
            return true;
        }
        if (packageName.isEmpty()) {
            return false;
        }
        PackageEntryTable table = settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
        return table != null && table.contains(packageName);
    }

    private static int findEntryIndex(@NotNull String packageName, boolean isStatic, @NotNull PackageEntry[] entries) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findEntryIndex"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findEntryIndex"));
        }
        PackageEntry bestEntry = null;
        int bestEntryIndex = -1;
        int allOtherStaticIndex = -1;
        int allOtherIndex = -1;
        for (int i = 0; i < entries.length; ++i) {
            PackageEntry entry = entries[i];
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStaticIndex = i;
            }
            if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
                allOtherIndex = i;
            }
            if (!entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) continue;
            bestEntry = entry;
            bestEntryIndex = i;
        }
        if (bestEntryIndex == -1 && isStatic && allOtherStaticIndex == -1 && allOtherIndex != -1) {
            bestEntryIndex = allOtherIndex;
        }
        return bestEntryIndex;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        String packageName;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findEntryIndex"));
        }
        PsiJavaCodeReferenceElement ref = statement.getImportReference();
        if (ref == null) {
            return -1;
        }
        if (statement.isOnDemand()) {
            packageName = ref.getCanonicalText();
        } else {
            String className = ref.getCanonicalText();
            packageName = ImportHelper.getPackageOrClassName(className);
        }
        return ImportHelper.findEntryIndex(packageName, statement instanceof PsiImportStaticStatement, this.mySettings.IMPORT_LAYOUT_TABLE.getEntries());
    }

    @NotNull
    private static Collection<Pair<String, Boolean>> collectNamesToImport(@NotNull PsiJavaFile file, List<PsiElement> comments) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        THashSet names = new THashSet();
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, comments, file, (PsiFile)jspFile);
        if (jspFile != null) {
            PsiFile[] files;
            for (PsiFile includingFile : files = (PsiFile[])ArrayUtil.mergeArrays((Object[])JspSpiUtil.getIncludingFiles(jspFile), (Object[])JspSpiUtil.getIncludedFiles(jspFile))) {
                PsiFile javaRoot = includingFile.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
                if (!(javaRoot instanceof PsiJavaFile) || file == javaRoot) continue;
                ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, comments, (PsiJavaFile)javaRoot, (PsiFile)jspFile);
            }
        }
        ImportHelper.addUnresolvedImportNames((Set<Pair<String, Boolean>>)names, file);
        THashSet tHashSet = names;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        return tHashSet;
    }

    private static void collectNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull List<PsiElement> comments, @NotNull PsiJavaFile file, PsiFile context) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        String packageName = file.getPackageName();
        List roots = file.getViewProvider().getAllFiles();
        for (PsiFile root : roots) {
            ImportHelper.addNamesToImport(names, comments, (PsiElement)root, packageName, context);
        }
    }

    private static void addNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull List<PsiElement> comments, @NotNull PsiElement scope, @NotNull String thisPackageName, PsiFile context) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (thisPackageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (scope instanceof PsiImportList) {
            return;
        }
        LinkedList<PsiElement> stack = new LinkedList<PsiElement>();
        stack.add(scope);
        while (!stack.isEmpty()) {
            PsiElement child = (PsiElement)stack.removeFirst();
            if (child instanceof PsiImportList) {
                for (PsiElement psiElement : child.getChildren()) {
                    IElementType elementType;
                    ASTNode node;
                    if (psiElement == null || (node = psiElement.getNode()) == null || (elementType = node.getElementType()) == null || ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(elementType) || JavaJspElementType.WHITE_SPACE_BIT_SET.contains(elementType)) continue;
                    comments.add(psiElement);
                }
                continue;
            }
            if (child instanceof PsiLiteralExpression) continue;
            ContainerUtil.addAll(stack, (Object[])child.getChildren());
            for (PsiElement psiElement : child.getReferences()) {
                String qName;
                PsiElement currentFileResolveScope;
                PsiJavaReference javaReference;
                if (!(psiElement instanceof PsiJavaReference) || (javaReference = (PsiJavaReference)psiElement) instanceof JavaClassReference && ((JavaClassReference)javaReference).getContextReference() != null) continue;
                PsiJavaCodeReferenceElement referenceElement = null;
                if (psiElement instanceof PsiJavaCodeReferenceElement && ((referenceElement = (PsiJavaCodeReferenceElement)child).getQualifier() != null || psiElement instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)psiElement).getKind() == 6)) continue;
                JavaResolveResult resolveResult = javaReference.advancedResolve(true);
                PsiElement refElement = resolveResult.getElement();
                if (refElement == null && referenceElement != null) {
                    refElement = ResolveClassUtil.resolveClass(referenceElement);
                }
                if (refElement == null || !((currentFileResolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) || context != null && (!currentFileResolveScope.isValid() || currentFileResolveScope instanceof JspxImportStatement && context != ((JspxImportStatement)currentFileResolveScope).getDeclarationFile())) continue;
                if (referenceElement != null && currentFileResolveScope instanceof PsiImportStaticStatement) {
                    String refName;
                    PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
                    String name = importStaticStatement.getImportReference().getCanonicalText();
                    if (importStaticStatement.isOnDemand() && (refName = referenceElement.getReferenceName()) != null) {
                        name = name + "." + refName;
                    }
                    names.add((Pair<String, Boolean>)Pair.create((Object)name, (Object)Boolean.TRUE));
                    continue;
                }
                if (!(refElement instanceof PsiClass) || ImportHelper.hasPackage(qName = ((PsiClass)refElement).getQualifiedName(), thisPackageName)) continue;
                names.add((Pair<String, Boolean>)Pair.create((Object)qName, (Object)Boolean.FALSE));
            }
        }
    }

    private static void addUnresolvedImportNames(@NotNull Set<Pair<String, Boolean>> namesToImport, @NotNull PsiJavaFile file) {
        if (namesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addUnresolvedImportNames"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addUnresolvedImportNames"));
        }
        PsiImportList importList = file.getImportList();
        PsiImportStatementBase[] imports = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashMap unresolvedNames = new THashMap();
        THashSet unresolvedOnDemand = new THashSet();
        for (PsiImportStatementBase anImport : imports) {
            JavaResolveResult[] results;
            PsiJavaCodeReferenceElement ref = anImport.getImportReference();
            if (ref == null || (results = ref.multiResolve(false)).length != 0) continue;
            String text = ref.getCanonicalText();
            if (anImport.isOnDemand()) {
                text = text + ".*";
            }
            Pair pair = Pair.create((Object)text, (Object)(anImport instanceof PsiImportStaticStatement));
            if (anImport.isOnDemand()) {
                unresolvedOnDemand.add(pair);
                continue;
            }
            unresolvedNames.put(ref.getReferenceName(), pair);
        }
        if (file.getViewProvider().getLanguages().size() > 1 && file.getViewProvider().getBaseLanguage() != JavaLanguage.INSTANCE) {
            namesToImport.addAll((Collection<Pair<String, Boolean>>)unresolvedOnDemand);
            namesToImport.addAll(unresolvedNames.values());
            return;
        }
        boolean[] hasResolveProblem = new boolean[]{false};
        for (PsiClass aClass : file.getClasses()) {
            if (aClass instanceof PsiCompiledElement) continue;
            aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)unresolvedNames, hasResolveProblem, namesToImport){
                final /* synthetic */ Map val$unresolvedNames;
                final /* synthetic */ boolean[] val$hasResolveProblem;
                final /* synthetic */ Set val$namesToImport;
                {
                    this.val$unresolvedNames = map;
                    this.val$hasResolveProblem = blArray;
                    this.val$namesToImport = set;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    String name = reference.getReferenceName();
                    Pair pair = (Pair)this.val$unresolvedNames.get(name);
                    if (reference.multiResolve(false).length == 0) {
                        this.val$hasResolveProblem[0] = true;
                        if (pair != null) {
                            this.val$namesToImport.add(pair);
                            this.val$unresolvedNames.remove(name);
                        }
                    }
                    super.visitReferenceElement(reference);
                }
            });
        }
        if (hasResolveProblem[0]) {
            namesToImport.addAll((Collection<Pair<String, Boolean>>)unresolvedOnDemand);
        }
    }

    public static boolean isImplicitlyImported(@NotNull String className, @NotNull PsiJavaFile file) {
        String[] packageNames;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isImplicitlyImported"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isImplicitlyImported"));
        }
        for (String packageName : packageNames = file.getImplicitlyImportedPackages()) {
            if (!ImportHelper.hasPackage(className, packageName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPackage(@NotNull String className, @NotNull String packageName) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "hasPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "hasPackage"));
        }
        if (!className.startsWith(packageName)) {
            return false;
        }
        if (className.length() == packageName.length()) {
            return false;
        }
        if (!packageName.isEmpty() && className.charAt(packageName.length()) != '.') {
            return false;
        }
        return className.indexOf(46, packageName.length() + 1) < 0;
    }

    @NotNull
    private static String getPackageOrClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getPackageOrClassName"));
        }
        int dotIndex = className.lastIndexOf(46);
        String string = dotIndex < 0 ? "" : className.substring(0, dotIndex);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getPackageOrClassName"));
        }
        return string;
    }
}

