/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleFacadeImpl
extends CodeStyleFacade {
    private final Project myProject;

    public CodeStyleFacadeImpl() {
        this(null);
    }

    public CodeStyleFacadeImpl(Project project) {
        this.myProject = project;
    }

    public int getIndentSize(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentSize(fileType);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/CodeStyleFacadeImpl", "getLineIndent"));
        }
        if (this.myProject == null) {
            return null;
        }
        return CodeStyleManager.getInstance((Project)this.myProject).getLineIndent(document, offset);
    }

    public String getLineSeparator() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getLineSeparator();
    }

    public boolean projectUsesOwnSettings() {
        return this.myProject != null && CodeStyleSettingsManager.getInstance((Project)this.myProject).USE_PER_PROJECT_SETTINGS;
    }

    public boolean isUnsuitableCodeStyleConfigurable(Configurable c) {
        return false;
    }

    public int getRightMargin() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).RIGHT_MARGIN;
    }

    public boolean isWrapWhenTypingReachesRightMargin() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    public int getTabSize(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getTabSize(fileType);
    }

    public boolean isSmartTabs(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).isSmartTabs(fileType);
    }

    public boolean useTabCharacter(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).useTabCharacter(fileType);
    }
}

