/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private SoftReference<PsiAnnotationMemberValue> myCachedDefaultValue = null;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "hasModifierProperty"));
        }
        return "abstract".equals(name) || "public".equals(name) || super.hasModifierProperty(name);
    }

    @Override
    protected void dropCached() {
        this.myCachedDefaultValue = null;
    }

    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String text = stub.getDefaultValueText();
            if (StringUtil.isEmpty((String)text)) {
                return null;
            }
            PsiAnnotationMemberValue value = (PsiAnnotationMemberValue)SoftReference.dereference(this.myCachedDefaultValue);
            if (value != null) {
                return value;
            }
            String annoText = "@interface _Dummy_ { Class foo() default " + text + "; }";
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getProject());
            PsiJavaFile file = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)annoText);
            value = ((PsiAnnotationMethod)file.getClasses()[0].getMethods()[0]).getDefaultValue();
            this.myCachedDefaultValue = new SoftReference((Object)value);
            return value;
        }
        this.myCachedDefaultValue = null;
        ASTNode node = this.getNode().findChildByRole(248);
        if (node == null) {
            return null;
        }
        return (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationMethod((PsiAnnotationMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

