/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final MyModificationTracker myTreeChangeTracker;
    private CachedValue<PsiMethod[]> myConstructorsCache;
    private CachedValue<PsiField[]> myFieldsCache;
    private CachedValue<PsiMethod[]> myMethodsCache;
    private CachedValue<PsiClass[]> myInnerClassesCache;
    private CachedValue<Map<String, PsiField>> myFieldsMapCache;
    private CachedValue<Map<String, List<PsiMethod>>> myMethodsMapCache;
    private CachedValue<Map<String, PsiClass>> myInnerClassesMapCache;

    public ClassInnerStuffCache(PsiExtensibleClass aClass) {
        this.myClass = aClass;
        this.myTreeChangeTracker = new MyModificationTracker();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] constructors;
        CachedValue cache = this.myConstructorsCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myConstructorsCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

                public CachedValueProvider.Result<PsiMethod[]> compute() {
                    return CachedValueProvider.Result.create((Object)PsiImplUtil.getConstructors(ClassInnerStuffCache.this.myClass), (Object[])dependencies);
                }
            }, false);
        }
        PsiMethod[] psiMethodArray = (constructors = (PsiMethod[])cache.getValue()) != null ? constructors : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getConstructors"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] fields;
        CachedValue cache = this.myFieldsCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myFieldsCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiField[]>(){

                public CachedValueProvider.Result<PsiField[]> compute() {
                    return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getAllFields(), (Object[])dependencies);
                }
            }, false);
        }
        PsiField[] psiFieldArray = (fields = (PsiField[])cache.getValue()) != null ? fields : PsiField.EMPTY_ARRAY;
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] methods;
        CachedValue cache = this.myMethodsCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myMethodsCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

                public CachedValueProvider.Result<PsiMethod[]> compute() {
                    return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getAllMethods(), (Object[])dependencies);
                }
            }, false);
        }
        PsiMethod[] psiMethodArray = (methods = (PsiMethod[])cache.getValue()) != null ? methods : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] classes;
        CachedValue cache = this.myInnerClassesCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myInnerClassesCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiClass[]>(){

                public CachedValueProvider.Result<PsiClass[]> compute() {
                    return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getAllInnerClasses(), (Object[])dependencies);
                }
            }, false);
        }
        PsiClass[] psiClassArray = (classes = (PsiClass[])cache.getValue()) != null ? classes : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (!checkBases) {
            Map cachedFields;
            CachedValue cache = this.myFieldsMapCache;
            if (cache == null) {
                CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
                final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
                this.myFieldsMapCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiField>>(){

                    public CachedValueProvider.Result<Map<String, PsiField>> compute() {
                        return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getFieldsMap(), (Object[])dependencies);
                    }
                }, false);
            }
            return (cachedFields = (Map)cache.getValue()) != null ? (PsiField)cachedFields.get(name) : null;
        }
        return PsiClassImplUtil.findFieldByName(this.myClass, name, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        if (!checkBases) {
            List methods;
            Map cachedMethods;
            CachedValue cache = this.myMethodsMapCache;
            if (cache == null) {
                CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
                final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
                this.myMethodsMapCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, List<PsiMethod>>>(){

                    public CachedValueProvider.Result<Map<String, List<PsiMethod>>> compute() {
                        return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getMethodsMap(), (Object[])dependencies);
                    }
                }, false);
            }
            if ((cachedMethods = (Map)cache.getValue()) != null && (methods = (List)cachedMethods.get(name)) != null && !methods.isEmpty()) {
                PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
                if (psiMethodArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "findMethodsByName"));
                }
                return psiMethodArray;
            }
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "findMethodsByName"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (!checkBases) {
            Map inners;
            CachedValue cache = this.myInnerClassesMapCache;
            if (cache == null) {
                CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
                final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
                this.myInnerClassesMapCache = cache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiClass>>(){

                    public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                        return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getInnerClassesMap(), (Object[])dependencies);
                    }
                }, false);
            }
            return (inners = (Map)cache.getValue()) != null ? (PsiClass)inners.get(name) : null;
        }
        return PsiClassImplUtil.findInnerByName(this.myClass, name, checkBases);
    }

    private PsiField[] getAllFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class);
        return (PsiField[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
    }

    private PsiMethod[] getAllMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class);
        return (PsiMethod[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    private PsiClass[] getAllInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class);
        return (PsiClass[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
    }

    @Nullable
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            return null;
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields) {
            String name = field.getName();
            if (field instanceof ExternallyDefinedPsiElement && cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        return cachedFields;
    }

    @Nullable
    private Map<String, List<PsiMethod>> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            return null;
        }
        THashMap cachedMethods = new THashMap();
        for (PsiMethod method : methods) {
            ArrayList<PsiMethod> list = (ArrayList<PsiMethod>)cachedMethods.get(method.getName());
            if (list == null) {
                list = new ArrayList<PsiMethod>(1);
                cachedMethods.put(method.getName(), list);
            }
            list.add(method);
        }
        return cachedMethods;
    }

    @Nullable
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes = this.getInnerClasses();
        if (classes.length == 0) {
            return null;
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes) {
            String name = psiClass.getName();
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        return cachedInners;
    }

    public void dropCaches() {
        this.myTreeChangeTracker.myCount++;
    }

    private static class MyModificationTracker
    implements ModificationTracker {
        private long myCount = 0L;

        private MyModificationTracker() {
        }

        public long getModificationCount() {
            return this.myCount;
        }
    }
}

