/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.CustomPropertyScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SimpleAccessorReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SimpleAccessorReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/SimpleAccessorReferenceSearcher", "processQuery"));
        }
        PsiElement refElement = queryParameters.getElementToSearch();
        if (!(refElement instanceof PsiMethod)) {
            return;
        }
        SimpleAccessorReferenceSearcher.addPropertyAccessUsages((PsiMethod)refElement, queryParameters.getEffectiveSearchScope(), queryParameters.getOptimizer());
    }

    static void addPropertyAccessUsages(PsiMethod method, SearchScope scope, SearchRequestCollector collector) {
        String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
        if (StringUtil.isNotEmpty((String)propertyName)) {
            GlobalSearchScope additional = GlobalSearchScope.EMPTY_SCOPE;
            for (CustomPropertyScopeProvider provider : (CustomPropertyScopeProvider[])Extensions.getExtensions(CustomPropertyScopeProvider.EP_NAME)) {
                additional = additional.union(provider.getScope(method.getProject()));
            }
            assert (propertyName != null);
            SearchScope propScope = scope.intersectWith(method.getUseScope()).intersectWith((SearchScope)additional);
            collector.searchWord(propertyName, propScope, (short)8, true, (PsiElement)method);
        }
    }
}

