/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.DefaultResultConsumer;
import com.intellij.concurrency.DoWhile;
import com.intellij.concurrency.FinallyFuture;
import com.intellij.concurrency.Iterate;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.concurrency.SameThreadExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.PsiSearchHelperImpl");
    private final PsiManagerEx myManager;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getUseScope"));
        }
        SearchScope scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : (UseScopeEnlarger[])UseScopeEnlarger.EP_NAME.getExtensions()) {
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getUseScope"));
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull PsiManagerEx manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "<init>"));
        }
        this.myManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findCommentsContainingIdentifier"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findCommentsContainingIdentifier"));
        }
        final ArrayList results = new ArrayList();
        this.processCommentsContainingIdentifier(identifier, searchScope, new Processor<PsiElement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(PsiElement element) {
                ArrayList arrayList = results;
                synchronized (arrayList) {
                    results.add(element);
                }
                return true;
            }
        });
        ArrayList arrayList = results;
        // MONITORENTER : arrayList
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(results);
        // MONITOREXIT : arrayList
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findCommentsContainingIdentifier"));
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, final @NotNull Processor<PsiElement> processor) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCommentsContainingIdentifier"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCommentsContainingIdentifier"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCommentsContainingIdentifier"));
        }
        TextOccurenceProcessor occurrenceProcessor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                if (CommentUtilCore.isCommentTextElement(element) && element.findReferenceAt(offsetInElement) == null) {
                    return processor.process((Object)element);
                }
                return true;
            }
        };
        return this.processElementsWithWord(occurrenceProcessor, searchScope, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        return this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        AsyncFuture<Boolean> result = this.processElementsWithWordAsync(processor, searchScope, text, searchContext, caseSensitive, processInjectedPsi, null);
        return (Boolean)AsyncUtil.get(result);
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = this.processElementsWithWordAsync(processor, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope), null);
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        return asyncFuture;
    }

    @NotNull
    private AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively, boolean processInjectedPsi, @Nullable String containerName) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (text.isEmpty()) {
            AsyncFuture asyncFuture = AsyncFutureFactory.wrapException((Throwable)new IllegalArgumentException("Cannot search for elements with empty text"));
            if (asyncFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
            }
            return asyncFuture;
        }
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, caseSensitively, true, searchContext == 4);
            AsyncFuture<Boolean> asyncFuture = this.processElementsWithTextInGlobalScopeAsync(processor, (GlobalSearchScope)searchScope, searcher, searchContext, caseSensitively, containerName, progress, processInjectedPsi);
            if (asyncFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
            }
            return asyncFuture;
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        StringSearcher searcher = new StringSearcher(text, caseSensitively, true, searchContext == 4);
        Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(processor, progress, processInjectedPsi, searcher);
        AsyncFuture<Boolean> asyncFuture = PsiSearchHelperImpl.wrapInFuture(Arrays.asList(scopeElements), progress, localProcessor);
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        return asyncFuture;
    }

    private static <T> AsyncFuture<Boolean> wrapInFuture(@NotNull List<T> files, ProgressIndicator progress, @NotNull Processor<T> processor) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "wrapInFuture"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "wrapInFuture"));
        }
        AsyncFutureResult asyncFutureResult = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        try {
            boolean result = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files, progress, true, true, processor);
            asyncFutureResult.set((Object)result);
        }
        catch (Throwable t) {
            asyncFutureResult.setException(t);
        }
        return asyncFutureResult;
    }

    private static boolean shouldProcessInjectedPsi(SearchScope scope) {
        return scope instanceof LocalSearchScope ? !((LocalSearchScope)scope).isIgnoreInjectedPsi() : true;
    }

    @NotNull
    private static Processor<PsiElement> localProcessor(final @NotNull TextOccurenceProcessor processor, final ProgressIndicator progress, final boolean processInjectedPsi, final @NotNull StringSearcher searcher) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        Processor<PsiElement> processor2 = new Processor<PsiElement>(){

            public boolean process(final PsiElement scopeElement) {
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return LowLevelSearchUtil.processElementsContainingWordInElement(processor, scopeElement, searcher, processInjectedPsi, progress);
                    }
                });
            }

            public String toString() {
                return processor.toString();
            }
        };
        if (processor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        return processor2;
    }

    @NotNull
    private AsyncFuture<Boolean> processElementsWithTextInGlobalScopeAsync(@NotNull TextOccurenceProcessor processor, @NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, String containerName, ProgressIndicator progress, boolean processInjectedPsi) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScopeAsync"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScopeAsync"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScopeAsync"));
        }
        if (Thread.holdsLock(PsiLock.LOCK)) {
            throw new AssertionError((Object)"You must not run search from within updating PSI activity. Please consider invokeLatering it instead.");
        }
        if (progress != null) {
            progress.pushState();
            progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        }
        String text = searcher.getPattern();
        THashSet fileSet = new THashSet();
        this.getFilesWithText(scope, searchContext, caseSensitively, text, progress, (Collection<VirtualFile>)fileSet);
        if (progress != null) {
            progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{text}));
        }
        Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(processor, progress, processInjectedPsi, searcher);
        if (containerName != null) {
            ArrayList<VirtualFile> intersectionWithContainerFiles = new ArrayList<VirtualFile>();
            this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, progress, intersectionWithContainerFiles);
            if (!intersectionWithContainerFiles.isEmpty()) {
                AsyncFuture<Boolean> result;
                int totalSize = fileSet.size();
                AsyncFuture<Boolean> intersectionResult = this.processPsiFileRootsAsync(intersectionWithContainerFiles, totalSize, 0, progress, localProcessor);
                try {
                    if (((Boolean)intersectionResult.get()).booleanValue()) {
                        fileSet.removeAll(intersectionWithContainerFiles);
                        if (fileSet.isEmpty()) {
                            result = intersectionResult;
                        } else {
                            AsyncFuture<Boolean> restResult = this.processPsiFileRootsAsync(new ArrayList<VirtualFile>((Collection<VirtualFile>)fileSet), totalSize, intersectionWithContainerFiles.size(), progress, localProcessor);
                            result = PsiSearchHelperImpl.bind(intersectionResult, restResult);
                        }
                    } else {
                        result = intersectionResult;
                    }
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    result = AsyncFutureFactory.wrapException((Throwable)cause);
                }
                catch (InterruptedException e) {
                    result = AsyncFutureFactory.wrapException((Throwable)e);
                }
                FinallyFuture<Boolean> finallyFuture = PsiSearchHelperImpl.popStateAfter(result, progress);
                if (finallyFuture == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScopeAsync"));
                }
                return finallyFuture;
            }
        }
        AsyncFuture<Boolean> result = fileSet.isEmpty() ? AsyncFutureFactory.wrap((Object)Boolean.TRUE) : this.processPsiFileRootsAsync(new ArrayList<VirtualFile>((Collection<VirtualFile>)fileSet), fileSet.size(), 0, progress, localProcessor);
        FinallyFuture<Boolean> finallyFuture = PsiSearchHelperImpl.popStateAfter(result, progress);
        if (finallyFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScopeAsync"));
        }
        return finallyFuture;
    }

    @NotNull
    private static FinallyFuture<Boolean> popStateAfter(@NotNull AsyncFuture<Boolean> result, final ProgressIndicator progress) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "popStateAfter"));
        }
        FinallyFuture finallyFuture = new FinallyFuture(result, new Runnable(){

            @Override
            public void run() {
                if (progress != null) {
                    progress.popState();
                }
            }
        });
        if (finallyFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "popStateAfter"));
        }
        return finallyFuture;
    }

    @NotNull
    private static AsyncFuture<Boolean> bind(@NotNull AsyncFuture<Boolean> first, final @NotNull AsyncFuture<Boolean> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bind"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bind"));
        }
        final AsyncFutureResult totalResult = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        first.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Boolean>(){

            public void onSuccess(Boolean value) {
                second.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new DefaultResultConsumer(totalResult));
            }

            public void onFailure(Throwable t) {
                totalResult.setException(t);
            }
        });
        AsyncFutureResult asyncFutureResult = totalResult;
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bind"));
        }
        return asyncFutureResult;
    }

    private static <T> T tryRead(final Computable<T> computable) throws CannotRunReadActionException {
        final Ref result = new Ref();
        if (((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(new Runnable(){

            @Override
            public void run() {
                result.set(computable.compute());
            }
        })) {
            return (T)result.get();
        }
        throw new CannotRunReadActionException();
    }

    @NotNull
    private AsyncFuture<Boolean> processPsiFileRootsAsync(@NotNull List<VirtualFile> files, final int totalSize, int alreadyProcessedFiles, final ProgressIndicator progress, final @NotNull Processor<? super PsiFile> localProcessor) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processPsiFileRootsAsync"));
        }
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processPsiFileRootsAsync"));
        }
        this.myManager.startBatchFilesProcessingMode();
        final AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
        final AtomicBoolean canceled = new AtomicBoolean(false);
        AsyncFutureResult asyncFutureResult = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final List<VirtualFile> failedFiles = Collections.synchronizedList(new SmartList());
        try {
            boolean completed = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files, progress, false, false, new Processor<VirtualFile>(){

                public boolean process(VirtualFile vfile) {
                    try {
                        TooManyUsagesStatus.getFrom(progress).pauseProcessingIfTooManyUsages();
                        PsiSearchHelperImpl.this.processVirtualFile(vfile, progress, (Processor<? super PsiFile>)localProcessor, canceled, counter, totalSize);
                    }
                    catch (CannotRunReadActionException action) {
                        failedFiles.add(vfile);
                    }
                    return !canceled.get();
                }
            });
            if (!failedFiles.isEmpty()) {
                for (final VirtualFile vfile : failedFiles) {
                    PsiSearchHelperImpl.checkCanceled(progress);
                    TooManyUsagesStatus.getFrom(progress).pauseProcessingIfTooManyUsages();
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiSearchHelperImpl.this.processVirtualFile(vfile, progress, (Processor<? super PsiFile>)localProcessor, canceled, counter, totalSize);
                        }
                    });
                }
            }
            asyncFutureResult.set((Object)completed);
            this.myManager.finishBatchFilesProcessingMode();
        }
        catch (Throwable t) {
            asyncFutureResult.setException(t);
        }
        AsyncFutureResult asyncFutureResult2 = asyncFutureResult;
        if (asyncFutureResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processPsiFileRootsAsync"));
        }
        return asyncFutureResult2;
    }

    private void processVirtualFile(final @NotNull VirtualFile vfile, final ProgressIndicator progress, final @NotNull Processor<? super PsiFile> localProcessor, final @NotNull AtomicBoolean canceled, @NotNull AtomicInteger counter, int totalSize) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (canceled == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (counter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        final PsiFile file = PsiSearchHelperImpl.tryRead(new Computable<PsiFile>(){

            public PsiFile compute() {
                return vfile.isValid() ? PsiSearchHelperImpl.this.myManager.findFile(vfile) : null;
            }
        });
        if (file != null && !(file instanceof PsiBinaryFile)) {
            if (FileDocumentManager.getInstance().getCachedDocument(vfile) == null) {
                try {
                    vfile.contentsToByteArray();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            PsiSearchHelperImpl.tryRead(new Computable<Void>(){

                public Void compute() {
                    if (PsiSearchHelperImpl.this.myManager.getProject().isDisposed()) {
                        throw new ProcessCanceledException();
                    }
                    List psiRoots = file.getViewProvider().getAllFiles();
                    THashSet processed = new THashSet(psiRoots.size() * 2, 0.5f);
                    for (PsiFile psiRoot : psiRoots) {
                        PsiSearchHelperImpl.checkCanceled(progress);
                        assert (psiRoot != null) : "One of the roots of file " + file + " is null. All roots: " + psiRoots + "; ViewProvider: " + file.getViewProvider() + "; Virtual file: " + file.getViewProvider().getVirtualFile();
                        if (!processed.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)psiRoot)) continue;
                        canceled.set(true);
                        break;
                    }
                    return null;
                }
            });
        }
        if (progress != null && progress.isRunning()) {
            double fraction = (double)counter.incrementAndGet() / (double)totalSize;
            progress.setFraction(fraction);
        }
    }

    private static void checkCanceled(ProgressIndicator progress) {
        if (progress != null) {
            progress.checkCanceled();
        } else {
            ProgressManager.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, final ProgressIndicator progress, @NotNull Collection<VirtualFile> result) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getFilesWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getFilesWithText"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getFilesWithText"));
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            CommonProcessors.CollectProcessor<VirtualFile> processor = new CommonProcessors.CollectProcessor<VirtualFile>(result){

                public boolean process(VirtualFile file) {
                    PsiSearchHelperImpl.checkCanceled(progress);
                    return super.process((Object)file);
                }
            };
            boolean success = this.processFilesWithText(scope, searchContext, caseSensitively, text, (Processor<VirtualFile>)processor);
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public boolean processFilesWithText(@NotNull GlobalSearchScope scope, final short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<VirtualFile> processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesWithText"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesWithText"));
        }
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(text, caseSensitively);
        if (entries.isEmpty()) {
            return true;
        }
        Condition<Integer> contextMatches = new Condition<Integer>(){

            public boolean value(Integer integer) {
                return (integer & searchContext) != 0;
            }
        };
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, contextMatches, entries, processor);
    }

    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findFilesWithPlainTextWords"));
        }
        PsiFile[] psiFileArray = CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findFilesWithPlainTextWords"));
        }
        return psiFileArray;
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor, searchScope);
    }

    public boolean processUsagesInNonJavaFiles(final @Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, final @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (initialScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        final String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        final GlobalSearchScope theSearchScope = (GlobalSearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GlobalSearchScope>(){

            public GlobalSearchScope compute() {
                if (originalElement != null && PsiSearchHelperImpl.this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                    return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)PsiSearchHelperImpl.this.myManager.getProject()));
                }
                return initialScope;
            }
        });
        PsiFile[] files = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return CacheManager.SERVICE.getInstance(PsiSearchHelperImpl.this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true);
            }
        });
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        int patternLength = searcher.getPattern().length();
        if (progress != null) {
            progress.pushState();
            progress.setText(PsiBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
        }
        final SearchScope useScope = (SearchScope)new ReadAction<SearchScope>(){

            protected void run(Result<SearchScope> result) {
                if (originalElement != null) {
                    result.setResult((Object)PsiSearchHelperImpl.this.getUseScope(originalElement));
                }
            }
        }.execute().getResultObject();
        Ref cancelled = new Ref((Object)Boolean.FALSE);
        for (int i = 0; i < files.length; ++i) {
            PsiSearchHelperImpl.checkCanceled(progress);
            final PsiFile psiFile = files[i];
            if (psiFile instanceof PsiBinaryFile) continue;
            final CharSequence text = (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence>(){

                public CharSequence compute() {
                    return psiFile.getViewProvider().getContents();
                }
            });
            char[] textArray = (char[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<char[]>(){

                public char[] compute() {
                    return CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
                }
            });
            int index = LowLevelSearchUtil.searchWord(text, textArray, 0, text.length(), searcher, progress);
            while (index >= 0) {
                final int finalIndex = index;
                boolean isReferenceOK = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        PsiReference referenceAt = psiFile.findReferenceAt(finalIndex);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    }
                });
                if (isReferenceOK && !processor.process(psiFile, index, index + patternLength)) {
                    cancelled.set((Object)Boolean.TRUE);
                    break;
                }
                index = LowLevelSearchUtil.searchWord(text, textArray, index + patternLength, text.length(), searcher, progress);
            }
            if (((Boolean)cancelled.get()).booleanValue()) break;
            if (progress == null) continue;
            progress.setFraction((double)(i + 1) / (double)files.length);
        }
        if (progress != null) {
            progress.popState();
        }
        return (Boolean)cancelled.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWord"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWord"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWord"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)1, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInText"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInText"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInText"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)16, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInComments"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInComments"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInComments"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)2, scope, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInLiterals"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInLiterals"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInLiterals"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)4, scope, true);
    }

    public boolean processRequests(@NotNull SearchRequestCollector request, @NotNull Processor<PsiReference> processor) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequests"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequests"));
        }
        return (Boolean)AsyncUtil.get(this.processRequestsAsync(request, processor));
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> processor) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequestsAsync"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequestsAsync"));
        }
        final HashMap collectors = ContainerUtil.newHashMap();
        collectors.put(collector, processor);
        PsiSearchHelperImpl.appendCollectorsFromQueryRequests(collectors);
        final ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        DoWhile doWhile = new DoWhile(){

            @NotNull
            protected AsyncFuture<Boolean> body() {
                final AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
                MultiMap globals = new MultiMap();
                final ArrayList customs = ContainerUtil.newArrayList();
                final LinkedHashSet locals = ContainerUtil.newLinkedHashSet();
                THashMap localProcessors = new THashMap();
                PsiSearchHelperImpl.distributePrimitives(collectors, locals, (MultiMap<Set<IdIndexEntry>, RequestWithProcessor>)globals, customs, (Map)localProcessors, progress);
                AsyncFuture future = PsiSearchHelperImpl.this.processGlobalRequestsOptimizedAsync((MultiMap<Set<IdIndexEntry>, RequestWithProcessor>)globals, progress, (Map)localProcessors);
                future.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new DefaultResultConsumer<Boolean>(result){

                    public void onSuccess(Boolean value) {
                        if (!value.booleanValue()) {
                            result.set((Object)value);
                        } else {
                            Iterate<RequestWithProcessor> iterate = new Iterate<RequestWithProcessor>((Iterable)locals){

                                @NotNull
                                protected AsyncFuture<Boolean> process(RequestWithProcessor local) {
                                    AsyncFuture asyncFuture = PsiSearchHelperImpl.this.processSingleRequestAsync(local.request, (Processor<PsiReference>)local.refProcessor);
                                    if (asyncFuture == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl$19$1$1", "process"));
                                    }
                                    return asyncFuture;
                                }
                            };
                            iterate.getResult().addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new DefaultResultConsumer<Boolean>(result){

                                public void onSuccess(Boolean value) {
                                    if (!value.booleanValue()) {
                                        result.set((Object)false);
                                        return;
                                    }
                                    for (Computable custom : customs) {
                                        if (((Boolean)custom.compute()).booleanValue()) continue;
                                        result.set((Object)false);
                                        return;
                                    }
                                    result.set((Object)true);
                                }
                            });
                        }
                    }
                });
                AsyncFutureResult asyncFutureResult = result;
                if (asyncFutureResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl$19", "body"));
                }
                return asyncFutureResult;
            }

            protected boolean condition() {
                return PsiSearchHelperImpl.appendCollectorsFromQueryRequests(collectors);
            }
        };
        AsyncFutureResult asyncFutureResult = doWhile.getResult();
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequestsAsync"));
        }
        return asyncFutureResult;
    }

    private static boolean appendCollectorsFromQueryRequests(@NotNull Map<SearchRequestCollector, Processor<PsiReference>> collectors) {
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "appendCollectorsFromQueryRequests"));
        }
        boolean changed = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            SearchRequestCollector each = queue.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                request.runQuery();
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, (Processor<PsiReference>)request.processor);
                queue.addLast(request.collector);
                changed = true;
            }
        }
        return changed;
    }

    @NotNull
    private AsyncFuture<Boolean> processGlobalRequestsOptimizedAsync(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors) {
        AsyncFuture<Boolean> result;
        Collection requests;
        if (singles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimizedAsync"));
        }
        if (localProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimizedAsync"));
        }
        if (singles.isEmpty()) {
            AsyncFuture asyncFuture = AsyncFutureFactory.wrap((Object)true);
            if (asyncFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimizedAsync"));
            }
            return asyncFuture;
        }
        if (singles.size() == 1 && (requests = singles.values()).size() == 1) {
            RequestWithProcessor theOnly = (RequestWithProcessor)requests.iterator().next();
            AsyncFuture<Boolean> asyncFuture = this.processSingleRequestAsync(theOnly.request, theOnly.refProcessor);
            if (asyncFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimizedAsync"));
            }
            return asyncFuture;
        }
        if (progress != null) {
            progress.pushState();
            progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        }
        MultiMap<VirtualFile, RequestWithProcessor> intersectionCandidateFiles = PsiSearchHelperImpl.createMultiMap();
        MultiMap<VirtualFile, RequestWithProcessor> restCandidateFiles = PsiSearchHelperImpl.createMultiMap();
        this.collectFiles(singles, progress, intersectionCandidateFiles, restCandidateFiles);
        if (intersectionCandidateFiles.isEmpty() && restCandidateFiles.isEmpty()) {
            AsyncFuture asyncFuture = AsyncFutureFactory.wrap((Object)true);
            if (asyncFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimizedAsync"));
            }
            return asyncFuture;
        }
        if (progress != null) {
            TreeSet<String> allWords = new TreeSet<String>();
            for (RequestWithProcessor singleRequest : localProcessors.keySet()) {
                allWords.add(singleRequest.request.word);
            }
            progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.getPresentableWordsDescription(allWords)}));
        }
        if (intersectionCandidateFiles.isEmpty()) {
            result = this.processCandidatesAsync(progress, localProcessors, restCandidateFiles, restCandidateFiles.size(), 0);
        } else {
            int totalSize = restCandidateFiles.size() + intersectionCandidateFiles.size();
            AsyncFuture<Boolean> intersectionResult = this.processCandidatesAsync(progress, localProcessors, intersectionCandidateFiles, totalSize, 0);
            try {
                if (((Boolean)intersectionResult.get()).booleanValue()) {
                    AsyncFuture<Boolean> restResult = this.processCandidatesAsync(progress, localProcessors, restCandidateFiles, totalSize, intersectionCandidateFiles.size());
                    result = PsiSearchHelperImpl.bind(intersectionResult, restResult);
                } else {
                    result = intersectionResult;
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                result = AsyncFutureFactory.wrapException((Throwable)cause);
            }
            catch (InterruptedException e) {
                result = AsyncFutureFactory.wrapException((Throwable)e);
            }
        }
        FinallyFuture<Boolean> finallyFuture = PsiSearchHelperImpl.popStateAfter(result, progress);
        if (finallyFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimizedAsync"));
        }
        return finallyFuture;
    }

    @NotNull
    private AsyncFuture<Boolean> processCandidatesAsync(ProgressIndicator progress, final @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors, final @NotNull MultiMap<VirtualFile, RequestWithProcessor> candidateFiles, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCandidatesAsync"));
        }
        if (candidateFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCandidatesAsync"));
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(candidateFiles.keySet());
        AsyncFuture<Boolean> asyncFuture = this.processPsiFileRootsAsync(files, totalSize, alreadyProcessedFiles, progress, (Processor<? super PsiFile>)new Processor<PsiFile>(){

            public boolean process(final PsiFile psiRoot) {
                return (Boolean)PsiSearchHelperImpl.tryRead((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        VirtualFile vfile = psiRoot.getVirtualFile();
                        for (RequestWithProcessor singleRequest : candidateFiles.get((Object)vfile)) {
                            Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                            if (localProcessor.process((Object)psiRoot)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
        });
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCandidatesAsync"));
        }
        return asyncFuture;
    }

    @NotNull
    private static String getPresentableWordsDescription(@NotNull Set<String> allWords) {
        if (allWords == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getPresentableWordsDescription"));
        }
        StringBuilder result = new StringBuilder();
        for (String string : allWords) {
            if (string == null || string.isEmpty()) continue;
            if (result.length() > 50) {
                result.append("...");
                break;
            }
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getPresentableWordsDescription"));
        }
        return string;
    }

    @NotNull
    private static TextOccurenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<PsiReference> consumer) {
        if (singleRequest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "adaptProcessor"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "adaptProcessor"));
        }
        SearchScope searchScope = singleRequest.searchScope;
        final boolean ignoreInjectedPsi = searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        TextOccurenceProcessor textOccurenceProcessor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                    return true;
                }
                return wrapped.processTextOccurrence(element, offsetInElement, consumer);
            }

            public String toString() {
                return consumer.toString();
            }
        };
        if (textOccurenceProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "adaptProcessor"));
        }
        return textOccurenceProcessor;
    }

    private void collectFiles(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, ProgressIndicator progress, final @NotNull MultiMap<VirtualFile, RequestWithProcessor> intersectionResult, final @NotNull MultiMap<VirtualFile, RequestWithProcessor> restResult) {
        if (singles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        if (intersectionResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        if (restResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        for (Set keys : singles.keySet()) {
            if (keys.isEmpty()) continue;
            final Collection data = singles.get((Object)keys);
            final GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(data);
            final Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, data, keys);
            ArrayList files = new ArrayList();
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(files);
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys, (Processor<VirtualFile>)processor);
            for (final VirtualFile file : files) {
                PsiSearchHelperImpl.checkCanceled(progress);
                for (final IdIndexEntry entry : keys) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)entry, file, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Integer>(){

                                public boolean process(VirtualFile file, Integer value) {
                                    int mask = value;
                                    for (RequestWithProcessor single : data) {
                                        PsiSearchRequest request = single.request;
                                        if ((mask & request.searchContext) == 0 || !((GlobalSearchScope)request.searchScope).contains(file)) continue;
                                        MultiMap result = intersectionWithContainerNameFiles == null || !intersectionWithContainerNameFiles.contains(file) ? restResult : intersectionResult;
                                        result.putValue((Object)file, (Object)single);
                                    }
                                    return true;
                                }
                            }, commonScope);
                        }
                    });
                }
            }
        }
    }

    @Nullable(value="null means we did not find common container files")
    private Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<RequestWithProcessor> data, @NotNull Set<IdIndexEntry> keys) {
        if (commonScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "intersectionWithContainerNameFiles"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "intersectionWithContainerNameFiles"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "intersectionWithContainerNameFiles"));
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (RequestWithProcessor r : data) {
            String name = r.request.containerName;
            if (name == null) continue;
            if (commonName == null) {
                commonName = r.request.containerName;
                searchContext = r.request.searchContext;
                caseSensitive = r.request.caseSensitive;
                continue;
            }
            if (commonName.equals(name)) {
                searchContext = (short)(searchContext | r.request.searchContext);
                caseSensitive &= r.request.caseSensitive;
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        THashSet containerFiles = new THashSet();
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries.isEmpty()) {
            return null;
        }
        entries.addAll(keys);
        final short finalSearchContext = searchContext;
        Condition<Integer> contextMatches = new Condition<Integer>(){

            public boolean value(Integer context) {
                return (context & finalSearchContext) != 0;
            }
        };
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, contextMatches, entries, (Processor<VirtualFile>)new CommonProcessors.CollectProcessor((Collection)containerFiles));
        return containerFiles;
    }

    @NotNull
    private static MultiMap<VirtualFile, RequestWithProcessor> createMultiMap() {
        MultiMap multiMap = MultiMap.createSmartList();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "createMultiMap"));
        }
        return multiMap;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<RequestWithProcessor> requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "uniteScopes"));
        }
        GlobalSearchScope commonScope = null;
        for (RequestWithProcessor r : requests) {
            GlobalSearchScope scope = (GlobalSearchScope)r.request.searchScope;
            commonScope = commonScope == null ? scope : commonScope.uniteWith(scope);
        }
        assert (commonScope != null);
        GlobalSearchScope globalSearchScope = commonScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "uniteScopes"));
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull List<Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors, ProgressIndicator progress) {
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (locals == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (singles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (customs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (localProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        for (Map.Entry<SearchRequestCollector, Processor<PsiReference>> entry : collectors.entrySet()) {
            final Processor<PsiReference> processor = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                SearchScope scope = primitive.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor);
                    continue;
                }
                List words = StringUtil.getWordsInStringLongestFirst((String)primitive.word);
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(words.size() * 2);
                for (String word : words) {
                    key.add(new IdIndexEntry(word, primitive.caseSensitive));
                }
                PsiSearchHelperImpl.registerRequest(singles.getModifiable(key), primitive, processor);
            }
            for (final Processor customAction : collector.takeCustomSearchActions()) {
                customs.add(new Computable<Boolean>(){

                    public Boolean compute() {
                        return customAction.process((Object)processor);
                    }
                });
            }
        }
        for (Map.Entry<Object, Object> entry : singles.entrySet()) {
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                TextOccurenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(adapted, progress, true, searcher);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<PsiReference> processor) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "registerRequest"));
        }
        if (primitive == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "registerRequest"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "registerRequest"));
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor);
        for (RequestWithProcessor existing : collection) {
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    @NotNull
    private AsyncFuture<Boolean> processSingleRequestAsync(@NotNull PsiSearchRequest single, @NotNull Processor<PsiReference> consumer) {
        if (single == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processSingleRequestAsync"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processSingleRequestAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = this.processElementsWithWordAsync(PsiSearchHelperImpl.adaptProcessor(single, consumer), single.searchScope, single.word, single.searchContext, single.caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope), single.containerName);
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processSingleRequestAsync"));
        }
        return asyncFuture;
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, final @Nullable ProgressIndicator progress) {
        boolean cheap;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
        }
        final AtomicInteger count = new AtomicInteger();
        Processor<VirtualFile> processor = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
            }

            public boolean process(VirtualFile file) {
                PsiSearchHelperImpl.checkCanceled(progress);
                if (Comparing.equal((Object)file, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int value = count.incrementAndGet();
                return value < 10;
            }
        };
        List<IdIndexEntry> keys = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys, processor);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = count.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, final @NotNull GlobalSearchScope scope, final @Nullable Condition<Integer> checker, final @NotNull Collection<IdIndexEntry> keys, final @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        final FileIndexFacade index = FileIndexFacade.getInstance((Project)project);
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys, scope, checker, (Processor)new Processor<VirtualFile>(){

                    public boolean process(VirtualFile file) {
                        return !index.shouldBeFound(scope, file) || processor.process((Object)file);
                    }
                });
            }
        });
    }

    @NotNull
    private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getWordEntries"));
        }
        List words = StringUtil.getWordsInStringLongestFirst((String)name);
        if (words.isEmpty()) {
            List<IdIndexEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getWordEntries"));
            }
            return list;
        }
        ArrayList<IdIndexEntry> keys = new ArrayList<IdIndexEntry>(words.size());
        for (String word : words) {
            keys.add(new IdIndexEntry(word, caseSensitively));
        }
        ArrayList<IdIndexEntry> arrayList = keys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getWordEntries"));
        }
        return arrayList;
    }

    private static class RequestWithProcessor {
        @NotNull
        final PsiSearchRequest request;
        @NotNull
        Processor<PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest first, @NotNull Processor<PsiReference> second) {
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "<init>"));
            }
            if (second == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "<init>"));
            }
            this.request = first;
            this.refProcessor = second;
        }

        boolean uniteWith(final @NotNull RequestWithProcessor another) {
            if (another == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "uniteWith"));
            }
            if (this.request.equals((Object)another.request)) {
                final Processor<PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = new Processor<PsiReference>(){

                        public boolean process(PsiReference psiReference) {
                            return myProcessor.process((Object)psiReference) && another.refProcessor.process((Object)psiReference);
                        }
                    };
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }
    }

    private static class CannotRunReadActionException
    extends RuntimeException {
        private CannotRunReadActionException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

