/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodReferencesSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        PsiMethod method;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "execute"));
        }
        PsiElement refElement = p.getElementToSearch();
        if (PsiUtil.isAnnotationMethod((PsiElement)refElement) && "value".equals((method = (PsiMethod)refElement).getName()) && method.getParameterList().getParametersCount() == 0) {
            Query query = ReferencesSearch.search((PsiElement)method.getContainingClass(), (SearchScope)p.getScope(), (boolean)p.isIgnoreAccessScope());
            return query.forEach(PsiAnnotationMethodReferencesSearcher.createImplicitDefaultAnnotationMethodConsumer(consumer));
        }
        return true;
    }

    public static ReadActionProcessor<PsiReference> createImplicitDefaultAnnotationMethodConsumer(final Processor<PsiReference> consumer) {
        return new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference reference) {
                PsiReference t;
                PsiNameValuePair[] members;
                PsiJavaCodeReferenceElement javaReference;
                return !(reference instanceof PsiJavaCodeReferenceElement) || !((javaReference = (PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnnotation) || (members = ((PsiAnnotation)javaReference.getParent()).getParameterList().getAttributes()).length != 1 || members[0].getNameIdentifier() != null || (t = members[0].getReference()) == null || consumer.process((Object)t);
            }
        };
    }
}

