/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.IndexPatternSearcher;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import org.jetbrains.annotations.NotNull;

public class IndexPatternSearchImpl
extends IndexPatternSearch {
    public IndexPatternSearchImpl() {
        this.registerExecutor(new IndexPatternSearcher());
    }

    protected int getOccurrencesCountImpl(@NotNull PsiFile file, @NotNull IndexPatternProvider provider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        int count = TodoCacheManager.SERVICE.getInstance(file.getProject()).getTodoCount(file.getVirtualFile(), provider);
        if (count != -1) {
            return count;
        }
        return IndexPatternSearchImpl.search((PsiFile)file, (IndexPatternProvider)provider).findAll().size();
    }

    protected int getOccurrencesCountImpl(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        int count = TodoCacheManager.SERVICE.getInstance(file.getProject()).getTodoCount(file.getVirtualFile(), pattern);
        if (count != -1) {
            return count;
        }
        return IndexPatternSearchImpl.search((PsiFile)file, (IndexPattern)pattern).findAll().size();
    }
}

