/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class CachesBasedRefSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public CachesBasedRefSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        PsiMetaData metaData;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/CachesBasedRefSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/CachesBasedRefSearcher", "processQuery"));
        }
        PsiElement refElement = p.getElementToSearch();
        String text = null;
        if (refElement instanceof PsiFileSystemItem && !(refElement instanceof SyntheticFileSystemItem)) {
            VirtualFile vFile = ((PsiFileSystemItem)refElement).getVirtualFile();
            if (vFile != null) {
                text = vFile.getNameWithoutExtension();
            }
        } else if (refElement instanceof PsiNamedElement) {
            text = ((PsiNamedElement)refElement).getName();
            if (refElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)refElement).getMetaData()) != null) {
                text = metaData.getName();
            }
        }
        if (text == null && refElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)refElement).getMetaData()) != null) {
            text = metaData.getName();
        }
        if (StringUtil.isNotEmpty((String)text)) {
            SearchScope searchScope = p.getEffectiveSearchScope();
            p.getOptimizer().searchWord(text, searchScope, refElement.getLanguage().isCaseSensitive(), refElement);
        }
    }
}

