/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.migration;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.migration.PsiMigrationImpl;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MigrationElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;

    public MigrationElementFinder(Project project) {
        this.myProject = project;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/migration/MigrationElementFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/migration/MigrationElementFinder", "findClass"));
        }
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            return migration.getMigrationClass(qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass migrationClass;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/migration/MigrationElementFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/migration/MigrationElementFinder", "findClasses"));
        }
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null && (migrationClass = migration.getMigrationClass(qualifiedName)) != null) {
            PsiClass[] psiClassArray = new PsiClass[]{migrationClass};
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/migration/MigrationElementFinder", "findClasses"));
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/migration/MigrationElementFinder", "findClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/migration/MigrationElementFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/migration/MigrationElementFinder", "getClasses"));
        }
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            List<PsiClass> classes = migration.getMigrationClasses(psiPackage.getQualifiedName());
            PsiClass[] psiClassArray = classes.toArray(new PsiClass[classes.size()]);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/migration/MigrationElementFinder", "getClasses"));
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/migration/MigrationElementFinder", "getClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/migration/MigrationElementFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/migration/MigrationElementFinder", "getSubPackages"));
        }
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            List<PsiPackage> packages = migration.getMigrationPackages(psiPackage.getQualifiedName());
            PsiPackage[] psiPackageArray = packages.toArray(new PsiPackage[packages.size()]);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/migration/MigrationElementFinder", "getSubPackages"));
            }
            return psiPackageArray;
        }
        if (PsiPackage.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/migration/MigrationElementFinder", "getSubPackages"));
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/migration/MigrationElementFinder", "findPackage"));
        }
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            return migration.getMigrationPackage(qualifiedName);
        }
        return null;
    }
}

