/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.codeInsight.completion.originInfo.OriginInfoAwareElement;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightMethodBuilder
extends LightElement
implements PsiMethod,
OriginInfoAwareElement {
    private final String myName;
    private Computable<PsiType> myReturnType;
    private final PsiModifierList myModifierList;
    private final PsiParameterList myParameterList;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiReferenceList myThrowsList;
    private Icon myBaseIcon;
    private PsiClass myContainingClass;
    private boolean myConstructor;
    private String myMethodKind = "LightMethodBuilder";
    private String myOriginInfo = null;

    public LightMethodBuilder(PsiClass constructedClass, Language language) {
        this(constructedClass.getManager(), language, constructedClass.getName());
        this.setContainingClass(constructedClass);
    }

    public LightMethodBuilder(PsiManager manager, String name) {
        this(manager, (Language)JavaLanguage.INSTANCE, name);
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name) {
        this(manager, language, name, new LightParameterListBuilder(manager, language), new LightModifierList(manager, language, new String[0]));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name, PsiParameterList parameterList, PsiModifierList modifierList) {
        this(manager, language, name, parameterList, modifierList, new LightReferenceListBuilder(manager, language, PsiReferenceList.Role.THROWS_LIST), new LightTypeParameterListBuilder(manager, language));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name, PsiParameterList parameterList, PsiModifierList modifierList, PsiReferenceList throwsList, PsiTypeParameterList typeParameterList) {
        super(manager, language);
        this.myName = name;
        this.myParameterList = parameterList;
        this.myModifierList = modifierList;
        this.myThrowsList = throwsList;
        this.myTypeParameterList = typeParameterList;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "setName"));
        }
        String className = this.myContainingClass == null ? "null" : this.myContainingClass.getQualifiedName();
        throw new UnsupportedOperationException("Please don't rename light methods: writable=" + this.isWritable() + "; class=" + ((Object)((Object)this)).getClass() + "; name=" + this.getName() + "; inClass=" + className);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getName"));
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myModifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getModifierList"));
        }
        return psiModifierList;
    }

    public LightMethodBuilder addModifiers(String ... modifiers) {
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
        return this;
    }

    public LightMethodBuilder addModifier(String modifier) {
        ((LightModifierList)this.myModifierList).addModifier(modifier);
        return this;
    }

    public LightMethodBuilder setModifiers(String ... modifiers) {
        ((LightModifierList)this.myModifierList).clearModifiers();
        this.addModifiers(modifiers);
        return this;
    }

    public PsiType getReturnType() {
        return this.myReturnType == null ? null : (PsiType)this.myReturnType.compute();
    }

    public LightMethodBuilder setMethodReturnType(Computable<PsiType> returnType) {
        this.myReturnType = returnType;
        return this;
    }

    public LightMethodBuilder setMethodReturnType(PsiType returnType) {
        return this.setMethodReturnType((Computable<PsiType>)new Computable.PredefinedValueComputable((Object)returnType));
    }

    public LightMethodBuilder setMethodReturnType(final @NotNull String returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "setMethodReturnType"));
        }
        return this.setMethodReturnType((Computable<PsiType>)new Computable.NotNullCachedComputable<PsiType>(){

            @NotNull
            protected PsiType internalCompute() {
                PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)LightMethodBuilder.this.myManager.getProject()).getElementFactory().createTypeByFQClassName(returnType, LightMethodBuilder.this.getResolveScope());
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder$1", "internalCompute"));
                }
                return psiClassType;
            }
        });
    }

    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.myParameterList;
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getParameterList"));
        }
        return psiParameterList;
    }

    public LightMethodBuilder addParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        ((LightParameterListBuilder)this.myParameterList).addParameter(parameter);
        return this;
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull String type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        return this.addParameter(name, JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText(type, (PsiElement)this));
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull PsiType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        return this.addParameter(new LightParameter(name, type, (PsiElement)this, (Language)JavaLanguage.INSTANCE));
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull PsiType type, boolean isVarArgs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (isVarArgs && !(type instanceof PsiEllipsisType)) {
            type = new PsiEllipsisType(type);
        }
        return this.addParameter(new LightParameter(name, type, (PsiElement)this, (Language)JavaLanguage.INSTANCE, isVarArgs));
    }

    public LightMethodBuilder addException(PsiClassType type) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(type);
        return this;
    }

    public LightMethodBuilder addException(String fqName) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(fqName);
        return this;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myThrowsList;
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getThrowsList"));
        }
        return psiReferenceList;
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public LightMethodBuilder setConstructor(boolean constructor) {
        this.myConstructor = constructor;
        return this;
    }

    public boolean isConstructor() {
        return this.myConstructor;
    }

    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this);
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "getSignature"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getSignature"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightMethodBuilder", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        }
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public LightMethodBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightMethodBuilder setMethodKind(String debugKindName) {
        this.myMethodKind = debugKindName;
        return this;
    }

    @Override
    public String toString() {
        return this.myMethodKind + ":" + this.getName();
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.myBaseIcon != null ? this.myBaseIcon : (this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON);
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public LightMethodBuilder setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return this;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass == null ? null : containingClass.getContainingFile();
    }

    @Override
    public PsiElement getContext() {
        PsiElement navElement = this.getNavigationElement();
        if (navElement != this) {
            return navElement;
        }
        PsiClass cls = this.getContainingClass();
        if (cls != null) {
            return cls;
        }
        return this.getContainingFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LightMethodBuilder that = (LightMethodBuilder)((Object)o);
        if (this.myConstructor != that.myConstructor) {
            return false;
        }
        if (this.myBaseIcon != null ? !this.myBaseIcon.equals(that.myBaseIcon) : that.myBaseIcon != null) {
            return false;
        }
        if (this.myContainingClass != null ? !this.myContainingClass.equals(that.myContainingClass) : that.myContainingClass != null) {
            return false;
        }
        if (!this.myMethodKind.equals(that.myMethodKind)) {
            return false;
        }
        if (!this.myModifierList.equals(that.myModifierList)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myParameterList.equals(that.myParameterList)) {
            return false;
        }
        return !(this.myReturnType != null ? !this.myReturnType.equals(that.myReturnType) : that.myReturnType != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myReturnType != null ? this.myReturnType.hashCode() : 0);
        result = 31 * result + this.myModifierList.hashCode();
        result = 31 * result + this.myParameterList.hashCode();
        result = 31 * result + (this.myBaseIcon != null ? this.myBaseIcon.hashCode() : 0);
        result = 31 * result + (this.myContainingClass != null ? this.myContainingClass.hashCode() : 0);
        result = 31 * result + (this.myConstructor ? 1 : 0);
        result = 31 * result + this.myMethodKind.hashCode();
        return result;
    }

    public LightMethodBuilder addTypeParameter(PsiTypeParameter parameter) {
        ((LightTypeParameterListBuilder)this.myTypeParameterList).addParameter(new LightTypeParameter(parameter));
        return this;
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

