/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldStubImpl
extends StubBase<PsiField>
implements PsiFieldStub {
    private final StringRef myName;
    private final TypeInfo myType;
    private final StringRef myInitializer;
    private final byte myFlags;
    private static final int ENUM_CONST = 1;
    private static final int DEPRECATED = 2;
    private static final int DEPRECATED_ANNOTATION = 4;

    public PsiFieldStubImpl(StubElement parent, String name, @NotNull TypeInfo type, @Nullable String initializer, byte flags) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "<init>"));
        }
        this(parent, StringRef.fromString((String)name), type, StringRef.fromString((String)initializer), flags);
    }

    public PsiFieldStubImpl(StubElement parent, StringRef name, @NotNull TypeInfo type, @Nullable StringRef initializer, byte flags) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "<init>"));
        }
        super(parent, (IStubElementType)(PsiFieldStubImpl.isEnumConst(flags) ? JavaStubElementTypes.ENUM_CONSTANT : JavaStubElementTypes.FIELD));
        this.myName = name;
        this.myType = type;
        this.myInitializer = initializer;
        this.myFlags = flags;
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myType.applyAnnotations(this) : this.myType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "getType"));
        }
        return typeInfo;
    }

    @Override
    public String getInitializerText() {
        return StringRef.toString((StringRef)this.myInitializer);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public boolean isEnumConstant() {
        return PsiFieldStubImpl.isEnumConst(this.myFlags);
    }

    private static boolean isEnumConst(byte flags) {
        return (flags & 1) != 0;
    }

    @Override
    public boolean isDeprecated() {
        return (this.myFlags & 2) != 0;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return (this.myFlags & 4) != 0;
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public static byte packFlags(boolean isEnumConst, boolean isDeprecated, boolean hasDeprecatedAnnotation) {
        byte flags = 0;
        if (isEnumConst) {
            flags = (byte)(flags | 1);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 2);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiFieldStub[");
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        if (this.isEnumConstant()) {
            builder.append("enumconst ");
        }
        builder.append(this.myName).append(':').append(this.myType);
        if (this.myInitializer != null) {
            builder.append('=').append(this.myInitializer);
        }
        builder.append("]");
        return builder.toString();
    }
}

