/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResolveScopeManagerImpl
extends ResolveScopeManager {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<VirtualFile, GlobalSearchScope> myDefaultResolveScopesCache = new ConcurrentFactoryMap<VirtualFile, GlobalSearchScope>(){

        protected GlobalSearchScope create(VirtualFile key) {
            ResolveScopeProvider resolveScopeProvider;
            GlobalSearchScope scope = null;
            Object[] arr$ = (ResolveScopeProvider[])ResolveScopeProvider.EP_NAME.getExtensions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (scope = (resolveScopeProvider = arr$[i$]).getResolveScope(key, ResolveScopeManagerImpl.this.myProject)) == null; ++i$) {
            }
            if (scope == null) {
                scope = ResolveScopeManagerImpl.this.getInherentResolveScope(key);
            }
            for (ResolveScopeEnlarger enlarger : (ResolveScopeEnlarger[])ResolveScopeEnlarger.EP_NAME.getExtensions()) {
                SearchScope extra = enlarger.getAdditionalResolveScope(key, ResolveScopeManagerImpl.this.myProject);
                if (extra == null) continue;
                scope = scope.union(extra);
            }
            return scope;
        }
    };

    public ResolveScopeManagerImpl(Project project, ProjectRootManager projectRootManager, PsiManager psiManager) {
        this.myProject = project;
        this.myProjectRootManager = projectRootManager;
        this.myManager = psiManager;
        ((PsiManagerImpl)psiManager).registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                ResolveScopeManagerImpl.this.myDefaultResolveScopesCache.clear();
            }
        });
    }

    private GlobalSearchScope getDefaultResolveScope(@NotNull PsiFile psiFile, @NotNull VirtualFile vFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getDefaultResolveScope"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getDefaultResolveScope"));
        }
        return this.myDefaultResolveScopesCache.get(vFile);
    }

    private GlobalSearchScope getInherentResolveScope(VirtualFile vFile) {
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean includeTests = projectFileIndex.isInTestSourceContent(vFile);
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        }
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        List orderEntries = projectFileIndex.getOrderEntriesForFile(vFile);
        LibraryOrderEntry lib = null;
        for (OrderEntry entry : orderEntries) {
            if (entry instanceof JdkOrderEntry) {
                return LibraryScopeCache.getInstance(this.myProject).getScopeForSdk((JdkOrderEntry)entry);
            }
            if (entry instanceof LibraryOrderEntry) {
                lib = (LibraryOrderEntry)entry;
                modulesLibraryUsedIn.add(entry.getOwnerModule());
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(entry.getOwnerModule());
        }
        GlobalSearchScope allCandidates = LibraryScopeCache.getInstance(this.myProject).getScopeForLibraryUsedIn(modulesLibraryUsedIn);
        if (lib != null) {
            final LibraryRuntimeClasspathScope preferred = new LibraryRuntimeClasspathScope(this.myProject, lib);
            return new DelegatingGlobalSearchScope(allCandidates, new Object[]{preferred}){

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    if (file1 == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl$3", "compare"));
                    }
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl$3", "compare"));
                    }
                    boolean c1 = preferred.contains(file1);
                    boolean c2 = preferred.contains(file2);
                    if (c1 && !c2) {
                        return 1;
                    }
                    if (c2 && !c1) {
                        return -1;
                    }
                    return super.compare(file1, file2);
                }
            };
        }
        return allCandidates;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        PsiFile contextFile;
        VirtualFile vFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
            contextFile = null;
        } else {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof PsiCodeFragment) {
                GlobalSearchScope forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope();
                if (forcedScope != null) {
                    GlobalSearchScope globalSearchScope = forcedScope;
                    if (globalSearchScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                    }
                    return globalSearchScope;
                }
                PsiElement context = containingFile.getContext();
                if (context == null) {
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
                    if (globalSearchScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                    }
                    return globalSearchScope;
                }
                GlobalSearchScope globalSearchScope = this.getResolveScope(context);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            PsiFile psiFile = contextFile = containingFile != null ? FileContextUtil.getContextFile((PsiElement)containingFile) : null;
            if (contextFile == null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            if (contextFile instanceof FileResolveScopeProvider) {
                GlobalSearchScope globalSearchScope = ((FileResolveScopeProvider)contextFile).getFileResolveScope();
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            vFile = contextFile.getOriginalFile().getVirtualFile();
        }
        if (vFile == null || contextFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getDefaultResolveScope(contextFile, vFile);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    public GlobalSearchScope getDefaultResolveScope(VirtualFile vFile) {
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null);
        return this.getDefaultResolveScope(psiFile, vFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        VirtualFile vFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
        } else {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
                }
                return globalSearchScope;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
                }
                return globalSearchScope;
            }
            vFile = virtualFile.getParent();
        }
        if (vFile == null) {
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
            }
            return globalSearchScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean isTest = projectFileIndex.isInTestSourceContent(vFile);
            GlobalSearchScope globalSearchScope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
            }
            return globalSearchScope;
        }
        PsiFile f = element.getContainingFile();
        VirtualFile vf = f == null ? null : f.getVirtualFile();
        GlobalSearchScope globalSearchScope = f == null || vf == null || vf.isDirectory() || allScope.contains(vf) ? allScope : GlobalSearchScope.fileScope((PsiFile)f).uniteWith(allScope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
        }
        return globalSearchScope;
    }
}

