/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PackagePrefixElementFinder;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiPackageImplementationHelperImpl
extends PsiPackageImplementationHelper {
    @Override
    public GlobalSearchScope adjustAllScope(PsiPackage psiPackage, GlobalSearchScope globalSearchScope) {
        return NonClasspathClassFinder.addNonClasspathScope(psiPackage.getProject(), globalSearchScope);
    }

    @Override
    public VirtualFile[] occursInPackagePrefixes(PsiPackage psiPackage) {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = ModuleManager.getInstance((Project)psiPackage.getProject()).getModules()) {
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                List sourceFolders = contentEntry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES);
                for (SourceFolder sourceFolder : sourceFolders) {
                    VirtualFile file;
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    if (!packagePrefix.startsWith(psiPackage.getQualifiedName()) || (file = sourceFolder.getFile()) == null) continue;
                    result.add(file);
                }
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @Override
    public void handleQualifiedNameChange(final PsiPackage psiPackage, final String newQualifiedName) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final String oldQualifedName = psiPackage.getQualifiedName();
        boolean anyChanged = PsiPackageImplementationHelperImpl.changePackagePrefixes(psiPackage, oldQualifedName, newQualifiedName);
        if (anyChanged) {
            UndoManager.getInstance((Project)psiPackage.getProject()).undoableActionPerformed((UndoableAction)new GlobalUndoableAction(){

                public void undo() {
                    PsiPackageImplementationHelperImpl.changePackagePrefixes(psiPackage, newQualifiedName, oldQualifedName);
                }

                public void redo() {
                    PsiPackageImplementationHelperImpl.changePackagePrefixes(psiPackage, oldQualifedName, newQualifiedName);
                }
            });
        }
    }

    private static boolean changePackagePrefixes(PsiPackage psiPackage, String oldQualifiedName, String newQualifiedName) {
        Module[] modules = ModuleManager.getInstance((Project)psiPackage.getProject()).getModules();
        ArrayList<ModifiableRootModel> modelsToCommit = new ArrayList<ModifiableRootModel>();
        for (Module module : modules) {
            boolean anyChange = false;
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    if (!packagePrefix.startsWith(oldQualifiedName)) continue;
                    sourceFolder.setPackagePrefix(newQualifiedName + packagePrefix.substring(oldQualifiedName.length()));
                    anyChange = true;
                }
            }
            if (anyChange) {
                modelsToCommit.add(rootModel);
                continue;
            }
            rootModel.dispose();
        }
        if (!modelsToCommit.isEmpty()) {
            ModifiableRootModel[] rootModels = modelsToCommit.toArray(new ModifiableRootModel[modelsToCommit.size()]);
            if (rootModels.length > 0) {
                ModifiableModelCommitter.multiCommit(rootModels, ModuleManager.getInstance((Project)rootModels[0].getProject()).getModifiableModel());
            }
            return true;
        }
        return false;
    }

    @Override
    public void navigate(final PsiPackage psiPackage, final boolean requestFocus) {
        final Project project = psiPackage.getProject();
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.PROJECT_VIEW);
        window.activate(null);
        window.getActivation().doWhenDone(new Runnable(){

            @Override
            public void run() {
                ProjectView projectView = ProjectView.getInstance(project);
                PsiDirectory[] directories = PsiPackageImplementationHelperImpl.suggestMostAppropriateDirectories(psiPackage);
                if (directories.length == 0) {
                    return;
                }
                projectView.select(directories[0], directories[0].getVirtualFile(), requestFocus);
            }
        });
    }

    private static PsiDirectory[] suggestMostAppropriateDirectories(PsiPackage psiPackage) {
        Project project = psiPackage.getProject();
        PsiDirectory[] directories = null;
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            Document document = editor.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiFile);
                directories = module != null ? psiPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module)) : psiPackage.getDirectories(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
            }
        }
        if (directories == null || directories.length == 0) {
            directories = psiPackage.getDirectories();
        }
        return directories;
    }

    @Override
    public boolean packagePrefixExists(PsiPackage psiPackage) {
        return PackagePrefixElementFinder.getInstance(psiPackage.getProject()).packagePrefixExists(psiPackage.getQualifiedName());
    }

    @Override
    public Object[] getDirectoryCachedValueDependencies(PsiPackage psiPackage) {
        return new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)psiPackage.getProject())};
    }
}

