/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;

    public ClsJavaCodeReferenceElementImpl(PsiElement parent, String canonicalText) {
        String canonical;
        this.myParent = parent;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName((String)this.myCanonicalText, (boolean)false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText((String)canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl((PsiElement)this, classParameters);
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    private JavaResolveResult advancedResolveImpl() {
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve = this.resolveElement();
        if (resolve instanceof PsiClass) {
            HashMap substitutionMap = new HashMap();
            int index = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiClass)resolve))) {
                if (index >= typeElements.length) {
                    PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
                    if (parameterOwner == resolve) {
                        substitutionMap.put(parameter, null);
                    } else if (parameterOwner instanceof PsiClass) {
                        PsiElement containingClass = this.myParent;
                        while ((containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true)) != null) {
                            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)((PsiClass)parameterOwner), (PsiClass)((PsiClass)containingClass), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                            if (superClassSubstitutor == null) continue;
                            substitutionMap.put(parameter, superClassSubstitutor.substitute(parameter));
                            break;
                        }
                    }
                } else {
                    substitutionMap.put(parameter, typeElements[index].getType());
                }
                ++index;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve, this.myCanonicalText, (Map<PsiTypeParameter, PsiType>)substitutionMap);
            return new CandidateInfo(resolve, PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)substitutionMap));
        }
        return new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null && !containingClass.hasModifierProperty("static")) {
            String outerClassRef = StringUtil.getPackageName((String)canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText((String)outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl((PsiElement)this, classParameters).getTypeArguments();
            PsiTypeParameter[] typeParameters = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (args == null || i >= args.length) continue;
                substitutionMap.put(typeParameters[i], args[i]);
            }
            this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
        }
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolve"));
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file);
        if (results.length == 0) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement() {
        PsiElement element;
        for (element = this.getParent(); element != null && (!(element instanceof PsiClass) || element instanceof PsiTypeParameter); element = element.getParent()) {
            PsiMethod method;
            PsiTypeParameterList list;
            if (!(element instanceof PsiMethod) || (list = (method = (PsiMethod)element).getTypeParameterList()) == null) continue;
            PsiTypeParameter[] parameters = list.getTypeParameters();
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                PsiTypeParameter parameter = parameters[i];
                if (!this.myQualifiedName.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        if (element == null) {
            return null;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)element))) {
            if (!this.myQualifiedName.equals(parameter.getName())) continue;
            return parameter;
        }
        return this.resolveClassPreferringMyJar();
    }

    @Nullable
    private PsiClass resolveClassPreferringMyJar() {
        VirtualFile jarFile;
        PsiClass[] classes = JavaPsiFacade.getInstance((Project)this.getProject()).findClasses(this.myQualifiedName, this.getResolveScope());
        if (classes.length == 0) {
            return null;
        }
        if (classes.length > 1 && (jarFile = PsiUtil.getJarFile((PsiElement)this)) != null) {
            for (PsiClass aClass : classes) {
                if (!Comparing.equal((Object)PsiUtil.getJarFile((PsiElement)aClass), (Object)jarFile)) continue;
                return aClass;
            }
        }
        return classes[0];
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    public String getReferenceName() {
        return PsiNameHelper.getShortClassName((String)this.myCanonicalText);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "bindToElement"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "appendMirrorText"));
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray = this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl", "getTypeParameters"));
        }
        return psiTypeArray;
    }

    public boolean isQualified() {
        return false;
    }

    public PsiElement getQualifier() {
        return null;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public JavaResolveResult[] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            JavaResolveResult resolveResult = ref.advancedResolveImpl();
            if (resolveResult.getElement() == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver", "resolve"));
            }
            return javaResolveResultArray;
        }
    }
}

