/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class ClsIdentifierImpl
extends ClsElementImpl
implements PsiIdentifier,
PsiJavaToken {
    private final PsiElement myParent;
    private final String myText;

    ClsIdentifierImpl(@NotNull PsiElement parent, String text) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsIdentifierImpl", "<init>"));
        }
        this.myParent = parent;
        this.myText = text;
    }

    public IElementType getTokenType() {
        return JavaTokenType.IDENTIFIER;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsIdentifierImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    private boolean isCorrectName(String name) {
        return name != null && ClsParsingUtil.isJavaIdentifier(name, ((PsiJavaFile)this.getContainingFile()).getLanguageLevel());
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsIdentifierImpl", "appendMirrorText"));
        }
        String original = this.getText();
        if (this.isCorrectName(original)) {
            buffer.append(original);
        } else {
            buffer.append("$$").append(original).append(" /* Real name is '").append(original).append("' */");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsIdentifierImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaTokenType.IDENTIFIER);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsIdentifierImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitIdentifier((PsiIdentifier)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiIdentifier:" + this.getText();
    }
}

