/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.Bottom;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        public int computeHashCode(PsiTypeParameter object) {
            String name = object.getName();
            return name == null ? 0 : name.hashCode();
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent((PsiElement)element1, (PsiElement)element2);
        }
    };
    private final Map<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor myAddingBoundsSubstitutionVisitor;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this.myAddingBoundsSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.ADD_BOUNDS);
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.SIMPLE);
        this.mySubstitutionMap = new THashMap(map, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl() {
        this.myAddingBoundsSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.ADD_BOUNDS);
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor(SubstituteKind.SIMPLE);
        this.mySubstitutionMap = new THashMap(2, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this();
        this.mySubstitutionMap.put(typeParameter, mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this();
        this.putAllInternal(parentClass, mappings);
    }

    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "substitute"));
        }
        if (this.containsInMap(typeParameter)) {
            return this.getFromMap(typeParameter);
        }
        return JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType((PsiClass)typeParameter);
    }

    private boolean containsInMap(PsiTypeParameter typeParameter) {
        if (typeParameter instanceof LightTypeParameter) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.containsKey(typeParameter);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "getFromMap"));
        }
        if (typeParameter instanceof LightTypeParameter) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.get(typeParameter);
    }

    public PsiType substitute(PsiType type) {
        if (type == null) {
            return null;
        }
        PsiUtil.ensureValidType((PsiType)type);
        PsiType substituted = (PsiType)type.accept((PsiTypeVisitor)this.myAddingBoundsSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type);
    }

    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "substituteWithBoundsPromotion"));
        }
        return this.addBounds(this.substitute(typeParameter), typeParameter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSubstitutorImpl)) {
            return false;
        }
        PsiSubstitutorImpl that = (PsiSubstitutorImpl)o;
        return !(this.mySubstitutionMap != null ? !((Object)this.mySubstitutionMap).equals(that.mySubstitutionMap) : that.mySubstitutionMap != null);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? ((Object)this.mySubstitutionMap).hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
        if (extendsTypes.length > 0) {
            return this.substitute((PsiType)extendsTypes[0]);
        }
        return PsiType.getJavaLangObject((PsiManager)typeParameter.getManager(), (GlobalSearchScope)typeParameter.getResolveScope());
    }

    private PsiType addBounds(PsiType substituted, @NotNull PsiTypeParameter typeParameter) {
        PsiType erasure;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiSubstitutorImpl", "addBounds"));
        }
        PsiType oldSubstituted = substituted;
        PsiElement captureContext = null;
        if (substituted instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType captured = (PsiCapturedWildcardType)substituted;
            substituted = captured.getWildcard();
            captureContext = captured.getContext();
        }
        if (substituted instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiClassType[] boundTypes;
            PsiType originalBound = ((PsiWildcardType)substituted).getBound();
            PsiManager manager = typeParameter.getManager();
            for (PsiClassType boundType : boundTypes = typeParameter.getExtendsListTypes()) {
                PsiType substitutedBoundType = (PsiType)boundType.accept((PsiTypeVisitor)this.mySimpleSubstitutionVisitor);
                PsiWildcardType wildcardType = (PsiWildcardType)substituted;
                if (substitutedBoundType == null || substitutedBoundType instanceof PsiWildcardType || substitutedBoundType.equalsToText("java.lang.Object") || originalBound != null && (TypeConversionUtil.erasure((PsiType)substitutedBoundType).isAssignableFrom(TypeConversionUtil.erasure((PsiType)originalBound)) || TypeConversionUtil.erasure((PsiType)substitutedBoundType).isAssignableFrom(originalBound))) continue;
                if (wildcardType.isExtends()) {
                    PsiType glb = GenericsUtil.getGreatestLowerBound((PsiType)wildcardType.getBound(), (PsiType)substitutedBoundType);
                    if (glb == null) continue;
                    substituted = PsiWildcardType.createExtends((PsiManager)manager, (PsiType)glb);
                    continue;
                }
                substituted = PsiWildcardType.createExtends((PsiManager)manager, (PsiType)substitutedBoundType);
            }
        } else if (substituted instanceof PsiWildcardType && ((PsiWildcardType)substituted).isSuper() && (erasure = TypeConversionUtil.erasure((PsiType)((PsiWildcardType)substituted).getBound())) != null) {
            PsiClassType[] boundTypes;
            for (PsiClassType boundType : boundTypes = typeParameter.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable((PsiType)erasure, (PsiType)boundType)) continue;
                return (PsiType)boundType.accept((PsiTypeVisitor)this.mySimpleSubstitutionVisitor);
            }
        }
        if (captureContext != null) {
            substituted = oldSubstituted instanceof PsiCapturedWildcardType && substituted == ((PsiCapturedWildcardType)oldSubstituted).getWildcard() ? oldSubstituted : PsiCapturedWildcardType.create((PsiWildcardType)((PsiWildcardType)substituted), (PsiElement)captureContext, (PsiTypeParameter)typeParameter);
        }
        return substituted;
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiSubstitutorImpl", "correctExternalSubstitution"));
        }
        if (substituted != null) {
            return substituted;
        }
        return (PsiType)original.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType((PsiType)arrayType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType((PsiType)ellipsisType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
            }

            public PsiType visitType(PsiType type) {
                LOG.error(type.getInternalCanonicalText());
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        return new PsiSubstitutorImpl(this.mySubstitutionMap);
    }

    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "put"));
        }
        PsiSubstitutorImpl ret = this.clone();
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        ret.mySubstitutionMap.put(typeParameter, mapping);
        PsiSubstitutorImpl psiSubstitutorImpl = ret;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "put"));
        }
        return psiSubstitutorImpl;
    }

    private void putAllInternal(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAllInternal"));
        }
        PsiTypeParameter[] params = parentClass.getTypeParameters();
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                this.mySubstitutionMap.put(param, mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            this.mySubstitutionMap.put(param, null);
        }
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        PsiSubstitutorImpl substitutor = this.clone();
        substitutor.putAllInternal(parentClass, mappings);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        return psiSubstitutorImpl;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        if (another instanceof EmptySubstitutorImpl) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutorImpl substitutor = this.clone();
        substitutor.mySubstitutionMap.putAll(anotherImpl.mySubstitutionMap);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        return psiSubstitutorImpl;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                buffer.append(((PsiMethod)owner).getContainingClass().getQualifiedName());
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY;
        }
        return new PsiSubstitutorImpl(map);
    }

    public boolean isValid() {
        Collection<PsiType> substitutorValues = this.mySubstitutionMap.values();
        for (PsiType type : substitutorValues) {
            if (type == null || type.isValid()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        Map<PsiTypeParameter, PsiType> map = Collections.unmodifiableMap(this.mySubstitutionMap);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "getSubstitutionMap"));
        }
        return map;
    }

    private class SubstitutionVisitor
    extends SubstitutionVisitorBase {
        private final SubstituteKind myKind;

        private SubstitutionVisitor(SubstituteKind kind) {
            this.myKind = kind;
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return classType;
            }
            PsiUtilCore.ensureValid((PsiElement)aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                if (PsiSubstitutorImpl.this.containsInMap(typeParameter)) {
                    PsiType result = this.substituteTypeParameter(typeParameter);
                    if (result != null) {
                        PsiUtil.ensureValidType((PsiType)result);
                    }
                    return result;
                }
                return classType;
            }
            HashMap hashMap = new HashMap(2);
            if (!this.processClass(aClass, resolveResult.getSubstitutor(), (Map<PsiTypeParameter, PsiType>)hashMap)) {
                return null;
            }
            PsiClassType result = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType((PsiType)result);
            return result;
        }

        private PsiType substituteTypeParameter(@NotNull PsiTypeParameter typeParameter) {
            if (typeParameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor", "substituteTypeParameter"));
            }
            PsiType t = PsiSubstitutorImpl.this.getFromMap(typeParameter);
            if (this.myKind == SubstituteKind.SIMPLE) {
                return t;
            }
            if (this.myKind == SubstituteKind.ADD_BOUNDS) {
                return PsiSubstitutorImpl.this.addBounds(t, typeParameter);
            }
            return t;
        }

        private PsiType substituteInternal(PsiType type) {
            return (PsiType)type.accept((PsiTypeVisitor)this);
        }

        private boolean processClass(PsiClass resolve, PsiSubstitutor originalSubstitutor, Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            for (PsiTypeParameter param : params = resolve.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                PsiType substituted = this.substituteInternal(original);
                substMap.put(param, substituted);
            }
            if (resolve.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }
    }

    static enum SubstituteKind {
        SIMPLE,
        ADD_BOUNDS;

    }

    private static abstract class SubstitutionVisitorBase
    extends PsiTypeVisitorEx<PsiType> {
        private SubstitutionVisitorBase() {
        }

        public PsiType visitType(PsiType type) {
            LOG.error((Object)type);
            return null;
        }

        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = (PsiType)bound.accept((PsiTypeVisitor)this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                return SubstitutionVisitorBase.handleBoundComposition(wildcardType, (PsiWildcardType)newBound);
            }
            if (newBound instanceof PsiCapturedWildcardType) {
                PsiWildcardType wildcard = ((PsiCapturedWildcardType)newBound).getWildcard();
                if (wildcardType.isExtends() != wildcard.isExtends()) {
                    if (wildcard.isBounded()) {
                        return wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)wildcardType.getManager(), (PsiType)newBound) : PsiWildcardType.createSuper((PsiManager)wildcardType.getManager(), (PsiType)newBound);
                    }
                    return newBound;
                }
                if (!wildcard.isBounded()) {
                    return PsiWildcardType.createUnbounded((PsiManager)wildcardType.getManager());
                }
                return newBound;
            }
            return newBound == PsiType.NULL ? newBound : SubstitutionVisitorBase.rebound(wildcardType, newBound);
        }

        private static PsiType handleBoundComposition(PsiWildcardType wildcardType, PsiWildcardType bound) {
            PsiType newBoundBound = bound.getBound();
            if (bound.isExtends() == wildcardType.isExtends() && newBoundBound != null) {
                return SubstitutionVisitorBase.rebound(wildcardType, newBoundBound);
            }
            if (newBoundBound != null) {
                return wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)wildcardType.getManager(), (PsiType)newBoundBound) : PsiWildcardType.createSuper((PsiManager)wildcardType.getManager(), (PsiType)newBoundBound);
            }
            return PsiWildcardType.createUnbounded((PsiManager)wildcardType.getManager());
        }

        private static PsiWildcardType rebound(PsiWildcardType type, PsiType newBound) {
            LOG.assertTrue(type.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    return PsiWildcardType.createUnbounded((PsiManager)type.getManager());
                }
                return PsiWildcardType.createExtends((PsiManager)type.getManager(), (PsiType)newBound);
            }
            return PsiWildcardType.createSuper((PsiManager)type.getManager(), (PsiType)newBound);
        }

        public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return primitiveType;
        }

        public PsiType visitArrayType(PsiArrayType arrayType) {
            PsiType componentType = arrayType.getComponentType();
            PsiType substitutedComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
            if (substitutedComponentType == null) {
                return null;
            }
            if (substitutedComponentType == componentType) {
                return arrayType;
            }
            return new PsiArrayType(substitutedComponentType);
        }

        public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
            PsiType componentType = ellipsisType.getComponentType();
            PsiType substitutedComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
            if (substitutedComponentType == null) {
                return null;
            }
            if (substitutedComponentType == componentType) {
                return ellipsisType;
            }
            return new PsiEllipsisType(substitutedComponentType);
        }

        @Override
        public PsiType visitTypeVariable(PsiTypeVariable var) {
            return var;
        }

        @Override
        public PsiType visitBottom(Bottom bottom) {
            return bottom;
        }

        public abstract PsiType visitClassType(PsiClassType var1);

        @Nullable
        public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
            List substituted = ContainerUtil.map((Object[])intersectionType.getConjuncts(), (Function)new Function<PsiType, PsiType>(){

                public PsiType fun(PsiType psiType) {
                    return (PsiType)psiType.accept((PsiTypeVisitor)SubstitutionVisitorBase.this);
                }
            });
            return PsiIntersectionType.createIntersection((List)substituted);
        }

        public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
            List substituted = ContainerUtil.map((Collection)disjunctionType.getDisjunctions(), (Function)new Function<PsiType, PsiType>(){

                public PsiType fun(PsiType psiType) {
                    return (PsiType)psiType.accept((PsiTypeVisitor)SubstitutionVisitorBase.this);
                }
            });
            return disjunctionType.newDisjunctionType(substituted);
        }

        public PsiType visitDiamondType(PsiDiamondType diamondType) {
            return diamondType;
        }
    }
}

