/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNameHelperImpl
extends PsiNameHelper {
    private final LanguageLevelProjectExtension myLanguageLevelExtension;

    public PsiNameHelperImpl(Project project) {
        this.myLanguageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project);
    }

    public boolean isIdentifier(@Nullable String text) {
        return this.isIdentifier(text, this.getLanguageLevel());
    }

    @NotNull
    protected LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevelExtension.getLanguageLevel();
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiNameHelperImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    public boolean isIdentifier(@Nullable String text, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiNameHelperImpl", "isIdentifier"));
        }
        return text != null && StringUtil.isJavaIdentifier((String)text) && !JavaLexer.isKeyword(text, languageLevel);
    }

    public boolean isKeyword(@Nullable String text) {
        return text != null && JavaLexer.isKeyword(text, this.getLanguageLevel());
    }

    public boolean isQualifiedName(@Nullable String text) {
        if (text == null) {
            return false;
        }
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = text.indexOf(46, index)) < 0) {
                index1 = text.length();
            }
            if (!this.isIdentifier(text.substring(index, index1))) {
                return false;
            }
            if (index1 == text.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }

    public static PsiNameHelper getInstance() {
        return new PsiNameHelperImpl(){

            @Override
            @NotNull
            protected LanguageLevel getLanguageLevel() {
                LanguageLevel languageLevel = LanguageLevel.HIGHEST;
                if (languageLevel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiNameHelperImpl$1", "getLanguageLevel"));
                }
                return languageLevel;
            }
        };
    }

    private PsiNameHelperImpl() {
        this.myLanguageLevelExtension = null;
    }
}

