/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiImplementationHelperImpl
extends JavaPsiImplementationHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaPsiImplementationHelperImpl");
    private final Project myProject;

    public JavaPsiImplementationHelperImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public PsiClass getOriginalClass(PsiClass psiClass) {
        PsiFile psiFile = psiClass.getContainingFile();
        VirtualFile vFile = psiFile.getVirtualFile();
        Project project = psiClass.getProject();
        final ProjectFileIndex idx = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return psiClass;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        String fqn = psiClass.getQualifiedName();
        if (fqn == null) {
            return psiClass;
        }
        PsiClass original = JavaPsiFacade.getInstance((Project)project).findClass(fqn, new GlobalSearchScope(project, (Set)orderEntries){
            final /* synthetic */ Set val$orderEntries;
            {
                this.val$orderEntries = set;
                super(x0);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl$1", "compare"));
                }
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl$1", "contains"));
                }
                List entries = idx.getOrderEntriesForFile(file);
                for (int i = 0; i < entries.size(); ++i) {
                    OrderEntry entry = (OrderEntry)entries.get(i);
                    if (!this.val$orderEntries.contains(entry)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl$1", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        });
        return original != null ? original : psiClass;
    }

    @Override
    @NotNull
    public PsiElement getClsFileNavigationElement(PsiJavaFile clsFile) {
        String packageName = clsFile.getPackageName();
        PsiClass[] classes = clsFile.getClasses();
        if (classes.length == 0) {
            PsiJavaFile psiJavaFile = clsFile;
            if (psiJavaFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getClsFileNavigationElement"));
            }
            return psiJavaFile;
        }
        String sourceFileName = ((ClsClassImpl)classes[0]).getSourceFileName();
        String relativeFilePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
        VirtualFile vFile = clsFile.getContainingFile().getVirtualFile();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)clsFile.getProject());
        LinkedHashSet sourceRoots = ContainerUtil.newLinkedHashSet();
        for (OrderEntry orderEntry : projectFileIndex.getOrderEntriesForFile(vFile)) {
            if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
            Collections.addAll(sourceRoots, orderEntry.getFiles(OrderRootType.SOURCES));
        }
        for (VirtualFile root : sourceRoots) {
            PsiFile psiSource;
            VirtualFile source = root.findFileByRelativePath(relativeFilePath);
            if (source == null || !((psiSource = clsFile.getManager().findFile(source)) instanceof PsiClassOwner)) continue;
            PsiFile psiFile = psiSource;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getClsFileNavigationElement"));
            }
            return psiFile;
        }
        PsiJavaFile psiJavaFile = clsFile;
        if (psiJavaFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getClsFileNavigationElement"));
        }
        return psiJavaFile;
    }

    @Override
    @Nullable
    public LanguageLevel getClassesLanguageLevel(VirtualFile virtualFile) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        VirtualFile folder = virtualFile.getParent();
        if (sourceRoot != null && folder != null) {
            VirtualFile[] files;
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)folder, (VirtualFile)sourceRoot, (char)'/');
            if (relativePath == null) {
                throw new AssertionError((Object)("Null relative path: folder=" + folder + "; root=" + sourceRoot));
            }
            List orderEntries = index.getOrderEntriesForFile(virtualFile);
            if (orderEntries.isEmpty()) {
                LOG.error("Inconsistent: " + DirectoryIndex.getInstance(this.myProject).getInfoForDirectory(folder).toString());
            }
            for (VirtualFile rootFile : files = ((OrderEntry)orderEntries.get(0)).getFiles(OrderRootType.CLASSES)) {
                PsiJavaFile javaFile;
                VirtualFile classFile = rootFile.findFileByRelativePath(relativePath);
                if (classFile == null || (javaFile = this.getPsiFileInRoot(classFile)) == null) continue;
                return javaFile.getLanguageLevel();
            }
            return LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel();
        }
        return null;
    }

    @Nullable
    private PsiJavaFile getPsiFileInRoot(VirtualFile dirFile) {
        VirtualFile[] children;
        for (VirtualFile child : children = dirFile.getChildren()) {
            PsiFile psiFile;
            if (!StdFileTypes.CLASS.equals(child.getFileType()) || !((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(child)) instanceof PsiJavaFile)) continue;
            return (PsiJavaFile)psiFile;
        }
        return null;
    }

    @Override
    public ASTNode getDefaultImportAnchor(PsiImportList list, PsiImportStatementBase statement) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)list.getProject());
        ImportHelper importHelper = new ImportHelper(settings);
        return importHelper.getDefaultAnchor(list, statement);
    }

    @Override
    @Nullable
    public PsiElement getDefaultMemberAnchor(@NotNull PsiClass aClass, @NotNull PsiMember member) {
        PsiElement lBrace;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getDefaultMemberAnchor"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getDefaultMemberAnchor"));
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)aClass.getProject());
        MemberOrderService service = (MemberOrderService)ServiceManager.getService(MemberOrderService.class);
        PsiElement anchor = service.getAnchor((PsiElement)member, settings.getCommonSettings((Language)JavaLanguage.INSTANCE), (PsiElement)aClass);
        PsiElement newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor);
        if (newAnchor != null) {
            return newAnchor;
        }
        if (anchor != null && anchor != aClass) {
            anchor = anchor.getNextSibling();
            while (anchor instanceof PsiJavaToken && (anchor.getText().equals(",") || anchor.getText().equals(";"))) {
                boolean afterComma = anchor.getText().equals(",");
                anchor = anchor.getNextSibling();
                if (!afterComma || (newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor)) == null) continue;
                return newAnchor;
            }
            if (anchor != null) {
                return anchor;
            }
        }
        if ((lBrace = aClass.getLBrace()) != null) {
            PsiElement result = lBrace.getNextSibling();
            while (result instanceof PsiWhiteSpace) {
                result = result.getNextSibling();
            }
            return result;
        }
        return aClass.getRBrace();
    }

    private static PsiElement skipWhitespaces(PsiClass aClass, PsiElement anchor) {
        if (anchor != null && PsiTreeUtil.skipSiblingsForward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class}) == aClass.getRBrace()) {
            return aClass.getRBrace();
        }
        return null;
    }

    public static int getMemberOrderWeight(PsiElement member, CodeStyleSettings settings) {
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant) {
                return 1;
            }
            return ((PsiField)member).hasModifierProperty("static") ? settings.STATIC_FIELDS_ORDER_WEIGHT + 1 : settings.FIELDS_ORDER_WEIGHT + 1;
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return settings.CONSTRUCTORS_ORDER_WEIGHT + 1;
            }
            return ((PsiMethod)member).hasModifierProperty("static") ? settings.STATIC_METHODS_ORDER_WEIGHT + 1 : settings.METHODS_ORDER_WEIGHT + 1;
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).hasModifierProperty("static") ? settings.STATIC_INNER_CLASSES_ORDER_WEIGHT + 1 : settings.INNER_CLASSES_ORDER_WEIGHT + 1;
        }
        return -1;
    }

    @Override
    public void setupCatchBlock(@NotNull String exceptionName, @NotNull PsiType exceptionType, PsiElement context, @NotNull PsiCatchSection catchSection) {
        PsiCodeBlock codeBlockFromText;
        PsiDirectory directory;
        if (exceptionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "setupCatchBlock"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "setupCatchBlock"));
        }
        if (catchSection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "setupCatchBlock"));
        }
        FileTemplate catchBodyTemplate = FileTemplateManager.getInstance().getCodeTemplate("Catch Statement Body.java");
        LOG.assertTrue(catchBodyTemplate != null);
        Properties props = new Properties();
        props.setProperty("EXCEPTION", exceptionName);
        props.setProperty("EXCEPTION_TYPE", exceptionType.getCanonicalText());
        if (context != null && context.isPhysical() && (directory = context.getContainingFile().getContainingDirectory()) != null) {
            JavaTemplateUtil.setPackageNameAttribute(props, directory);
        }
        try {
            codeBlockFromText = PsiElementFactory.SERVICE.getInstance((Project)this.myProject).createCodeBlockFromText("{\n" + catchBodyTemplate.getText(props) + "\n}", null);
        }
        catch (ProcessCanceledException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Incorrect file template", e);
        }
        catchSection.getCatchBlock().replace((PsiElement)codeBlockFromText);
    }
}

