/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public abstract class XmlFormattingPolicy {
    private Map<Pair<PsiElement, Language>, Block> myRootToBlockMap = new HashMap();
    private boolean myProcessJsp = true;
    protected final FormattingDocumentModel myDocumentModel;
    private boolean myProcessJavaTree = true;

    protected XmlFormattingPolicy(FormattingDocumentModel documentModel) {
        this.myDocumentModel = documentModel;
    }

    public void copyFrom(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myProcessJsp = xmlFormattingPolicy.myProcessJsp;
        this.myRootToBlockMap.putAll(xmlFormattingPolicy.myRootToBlockMap);
        this.myProcessJavaTree = xmlFormattingPolicy.processJavaTree();
    }

    public Block getOrCreateBlockFor(Pair<PsiElement, Language> root) {
        if (!this.myRootToBlockMap.containsKey(root)) {
            this.myRootToBlockMap.put(root, this.createBlockFor(root));
        }
        return this.myRootToBlockMap.get(root);
    }

    private Block createBlockFor(Pair<PsiElement, Language> root) {
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((Language)root.getSecond(), (PsiElement)root.getFirst());
        if (builder != null) {
            Block result = builder.createModel((PsiElement)root.getFirst(), this.getSettings()).getRootBlock();
            if (result instanceof XmlBlock) {
                XmlFormattingPolicy policy = this.getPolicy((XmlBlock)result);
                policy.setRootModels(this.myRootToBlockMap);
                policy.doNotProcessJsp();
            }
            return result;
        }
        return null;
    }

    protected XmlFormattingPolicy getPolicy(XmlBlock result) {
        return result.getPolicy();
    }

    private void doNotProcessJsp() {
        this.myProcessJsp = false;
    }

    private void setRootModels(Map<Pair<PsiElement, Language>, Block> rootToBlockMap) {
        this.myRootToBlockMap = rootToBlockMap;
    }

    public abstract WrapType getWrappingTypeForTagEnd(XmlTag var1);

    public abstract WrapType getWrappingTypeForTagBegin(XmlTag var1);

    public abstract boolean insertLineBreakBeforeTag(XmlTag var1);

    public abstract boolean insertLineBreakBeforeFirstAttribute(XmlAttribute var1);

    public abstract boolean insertLineBreakAfterLastAttribute(XmlAttribute var1);

    public abstract boolean insertLineBreakAfterTagBegin(XmlTag var1);

    public abstract boolean removeLineBreakBeforeTag(XmlTag var1);

    public abstract boolean keepWhiteSpacesInsideTag(XmlTag var1);

    public abstract boolean indentChildrenOf(XmlTag var1);

    public abstract boolean isTextElement(XmlTag var1);

    public abstract int getTextWrap(XmlTag var1);

    public abstract int getAttributesWrap();

    public abstract boolean getShouldAlignAttributes();

    public abstract boolean getShouldAlignText();

    public abstract boolean getShouldKeepWhiteSpaces();

    public abstract boolean getShouldAddSpaceAroundEqualityInAttribute();

    public abstract boolean getShouldAddSpaceAroundTagName();

    public abstract int getKeepBlankLines();

    public abstract boolean getShouldKeepLineBreaks();

    public abstract boolean getShouldKeepLineBreaksInText();

    public abstract boolean getKeepWhiteSpacesInsideCDATA();

    public abstract int getWhiteSpaceAroundCDATAOption();

    public abstract CodeStyleSettings getSettings();

    public boolean processJsp() {
        return this.myProcessJsp;
    }

    public abstract boolean addSpaceIntoEmptyTag();

    public void setRootBlock(ASTNode node, Block rootBlock) {
        this.myRootToBlockMap.put((Pair<PsiElement, Language>)new Pair((Object)node.getPsi(), (Object)node.getPsi().getLanguage()), rootBlock);
    }

    public FormattingDocumentModel getDocumentModel() {
        return this.myDocumentModel;
    }

    public abstract boolean shouldSaveSpacesBetweenTagAndText();

    public boolean processJavaTree() {
        return this.myProcessJavaTree;
    }

    public void dontProcessJavaTree() {
        this.myProcessJavaTree = false;
    }
}

