/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeBlockBlock
extends AbstractJavaBlock {
    private static final int BEFORE_FIRST = 0;
    private static final int BEFORE_LBRACE = 1;
    private static final int INSIDE_BODY = 2;
    private final int myChildrenIndent;

    public CodeBlockBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, CodeBlockBlock.getAlignmentStrategy(alignment, node, settings), indent, settings, javaSettings);
        this.myChildrenIndent = this.isSwitchCodeBlock() && !settings.INDENT_CASE_FROM_SWITCH ? 0 : 1;
    }

    private static AlignmentStrategy getAlignmentStrategy(Alignment alignment, ASTNode baseNode, @NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/formatter/java/CodeBlockBlock", "getAlignmentStrategy"));
        }
        if (baseNode.getElementType() != JavaElementType.CLASS || !settings.ALIGN_MULTILINE_EXTENDS_LIST) {
            return AlignmentStrategy.wrap(alignment, new IElementType[0]);
        }
        ASTNode node = baseNode.getLastChildNode();
        while (node != null) {
            if (node.getElementType() == JavaElementType.IMPLEMENTS_LIST) {
                ASTNode lastChildNode = node.getLastChildNode();
                if (lastChildNode == null || lastChildNode.getElementType() != TokenType.ERROR_ELEMENT) break;
                Alignment alignmentToUse = alignment;
                if (alignment == null) {
                    alignmentToUse = Alignment.createAlignment();
                }
                return AlignmentStrategy.wrap(alignmentToUse, false, JavaTokenType.LBRACE, JavaElementType.JAVA_CODE_REFERENCE, node.getElementType());
            }
            node = FormatterUtil.getPreviousNonWhitespaceSibling(node);
        }
        return AlignmentStrategy.wrap(alignment, new IElementType[0]);
    }

    private boolean isSwitchCodeBlock() {
        return this.myNode.getTreeParent().getElementType() == JavaElementType.SWITCH_STATEMENT;
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Alignment childAlignment = this.createChildAlignment();
        Wrap childWrap = this.createChildWrap();
        this.buildChildren(result, childAlignment, childWrap);
        return result;
    }

    private void buildChildren(ArrayList<Block> result, Alignment childAlignment, Wrap childWrap) {
        ASTNode child = this.myNode.getFirstChildNode();
        int state = 0;
        if (this.myNode.getPsi() instanceof PsiSyntheticClass) {
            state = 2;
        }
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Indent indent = this.calcCurrentIndent(child, state);
                state = CodeBlockBlock.calcNewState(child, state);
                child = child.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT ? this.processCaseAndStatementAfter(result, child, childAlignment, childWrap, indent) : (this.myNode.getElementType() == JavaElementType.CLASS && child.getElementType() == JavaTokenType.LBRACE ? this.composeCodeBlock(result, child, this.getCodeBlockExternalIndent(), this.myChildrenIndent, null) : (this.myNode.getElementType() == JavaElementType.CODE_BLOCK && child.getElementType() == JavaTokenType.LBRACE && this.myNode.getTreeParent().getElementType() == JavaElementType.METHOD ? this.composeCodeBlock(result, child, indent, this.myChildrenIndent, childWrap) : this.processChild(result, child, this.chooseAlignment(child, childAlignment), childWrap, indent)));
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
    }

    @Nullable
    private Alignment chooseAlignment(@NotNull ASTNode child, @Nullable Alignment defaultAlignment) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/java/CodeBlockBlock", "chooseAlignment"));
        }
        if (defaultAlignment != null) {
            return defaultAlignment;
        }
        if (child.getElementType() != JavaTokenType.RBRACE) {
            return defaultAlignment;
        }
        ASTNode parent = child.getTreeParent();
        if (parent == null || parent.getElementType() != JavaElementType.ANONYMOUS_CLASS) {
            return defaultAlignment;
        }
        ASTNode whiteSpaceCandidate = parent.getTreePrev();
        if (whiteSpaceCandidate == null || whiteSpaceCandidate.getElementType() != TokenType.WHITE_SPACE) {
            return defaultAlignment;
        }
        return StringUtil.countNewLines((CharSequence)whiteSpaceCandidate.getChars()) > 0 ? this.myAlignment : defaultAlignment;
    }

    @Nullable
    private ASTNode processCaseAndStatementAfter(ArrayList<Block> result, ASTNode child, Alignment childAlignment, Wrap childWrap, Indent indent) {
        ArrayList<Block> localResult = new ArrayList<Block>();
        this.processChild(localResult, child, AlignmentStrategy.getNullStrategy(), null, Indent.getNoneIndent());
        Indent childIndent = Indent.getNormalIndent();
        for (child = child.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT || CodeBlockBlock.isRBrace(child)) {
                result.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
                return child.getTreePrev();
            }
            if (FormatterUtil.containsWhiteSpacesOnly(child)) continue;
            if (child.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                childIndent = Indent.getNoneIndent();
            }
            boolean breakOrReturn = CodeBlockBlock.isBreakOrReturn(child);
            this.processChild(localResult, child, AlignmentStrategy.getNullStrategy(), null, childIndent);
            if (!breakOrReturn) continue;
            result.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
            return child;
        }
        result.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
        return null;
    }

    private static boolean isBreakOrReturn(ASTNode child) {
        IElementType elementType = child.getElementType();
        return JavaElementType.BREAK_STATEMENT == elementType || JavaElementType.RETURN_STATEMENT == elementType;
    }

    private SyntheticCodeBlock createCaseSectionBlock(ArrayList<Block> localResult, Alignment childAlignment, Indent indent, Wrap childWrap) {
        SyntheticCodeBlock result = new SyntheticCodeBlock(localResult, childAlignment, this.getSettings(), this.myJavaSettings, indent, childWrap){

            @Override
            @NotNull
            public ChildAttributes getChildAttributes(int newChildIndex) {
                Block previousBlock;
                IElementType prevElementType = null;
                if (newChildIndex > 0 && (previousBlock = this.getSubBlocks().get(newChildIndex - 1)) instanceof AbstractBlock) {
                    prevElementType = ((AbstractBlock)previousBlock).getNode().getElementType();
                }
                if (prevElementType == JavaElementType.BLOCK_STATEMENT || prevElementType == JavaElementType.BREAK_STATEMENT || prevElementType == JavaElementType.RETURN_STATEMENT) {
                    ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
                    if (childAttributes == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CodeBlockBlock$1", "getChildAttributes"));
                    }
                    return childAttributes;
                }
                ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CodeBlockBlock$1", "getChildAttributes"));
                }
                return childAttributes;
            }
        };
        result.setChildAttributes(new ChildAttributes(Indent.getNormalIndent(), null));
        result.setIsIncomplete(true);
        return result;
    }

    private static int calcNewState(ASTNode child, int state) {
        switch (state) {
            case 0: {
                if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
                    return 0;
                }
                if (CodeBlockBlock.isLBrace(child)) {
                    return 2;
                }
                return 1;
            }
            case 1: {
                if (CodeBlockBlock.isLBrace(child)) {
                    return 2;
                }
                return 1;
            }
        }
        return 2;
    }

    private static boolean isLBrace(ASTNode child) {
        return child.getElementType() == JavaTokenType.LBRACE;
    }

    private Indent calcCurrentIndent(ASTNode child, int state) {
        if (CodeBlockBlock.isRBrace(child) || child.getElementType() == JavaTokenType.AT) {
            return Indent.getNoneIndent();
        }
        if (state == 0) {
            return Indent.getNoneIndent();
        }
        if (child.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT) {
            return this.getCodeBlockInternalIndent(this.myChildrenIndent);
        }
        if (state == 1) {
            if (CodeBlockBlock.isLBrace(child)) {
                return Indent.getNoneIndent();
            }
            return Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        }
        if (CodeBlockBlock.isRBrace(child)) {
            return Indent.getNoneIndent();
        }
        return this.getCodeBlockInternalIndent(this.myChildrenIndent);
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT, JavaElementType.MODIFIER_LIST})) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CodeBlockBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.getSubBlocks().size() == newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CodeBlockBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(this.getCodeBlockInternalIndent(this.myChildrenIndent), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CodeBlockBlock", "getChildAttributes"));
        }
        return childAttributes;
    }
}

