/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEntryWrapper;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import com.intellij.psi.codeStyle.arrangement.engine.RestoreFoldArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementEngine {
    public void arrange(@NotNull Editor editor, @NotNull PsiFile file, Collection<TextRange> ranges) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        this.arrange(file, ranges, new RestoreFoldArrangementCallback(editor));
    }

    public void arrange(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        this.arrange(file, ranges, null);
    }

    public void arrange(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges, final @Nullable ArrangementCallback callback) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(file.getLanguage());
        if (rearranger == null) {
            return;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)file.getProject()).getCurrentSettings();
        ArrangementSettings arrangementSettings = settings.getCommonSettings(file.getLanguage()).getArrangementSettings();
        if (arrangementSettings == null && rearranger instanceof ArrangementStandardSettingsAware) {
            arrangementSettings = ((ArrangementStandardSettingsAware)rearranger).getDefaultSettings();
        }
        if (arrangementSettings == null) {
            return;
        }
        final DocumentEx documentEx = document instanceof DocumentEx && !((DocumentEx)document).isInBulkUpdate() ? (DocumentEx)document : null;
        final Context context = Context.from(rearranger, document, (PsiElement)file, ranges, arrangementSettings, settings);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (documentEx != null) {
                    // empty if block
                }
                try {
                    ArrangementEngine.doArrange(context);
                    if (callback != null) {
                        callback.afterArrangement(context.moveInfos);
                    }
                }
                finally {
                    if (documentEx != null) {
                        // empty if block
                    }
                }
            }
        });
    }

    private static <E extends ArrangementEntry> void doArrange(Context<E> context) {
        ArrayList entries = new ArrayList();
        Stack stack = new Stack();
        entries.addAll(context.wrappers);
        stack.push((Object)new StackEntry(0, context.wrappers.size()));
        while (!stack.isEmpty()) {
            ArrangementEntryWrapper wrapper;
            List children;
            StackEntry stackEntry = (StackEntry)stack.peek();
            if (stackEntry.current >= stackEntry.end) {
                List<ArrangementEntryWrapper<E>> subEntries = entries.subList(stackEntry.start, stackEntry.end);
                if (subEntries.size() > 1) {
                    ArrangementEngine.doArrange(subEntries, context);
                }
                subEntries.clear();
                stack.pop();
                continue;
            }
            if ((children = (wrapper = (ArrangementEntryWrapper)entries.get(stackEntry.current++)).getChildren()).isEmpty()) continue;
            entries.addAll(children);
            stack.push((Object)new StackEntry(stackEntry.end, children.size()));
        }
    }

    @NotNull
    public static <E extends ArrangementEntry> List<E> arrange(@NotNull Collection<E> entries, @NotNull List<? extends ArrangementMatchRule> rules, @NotNull List<? extends ArrangementMatchRule> rulesByPriority) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (rulesByPriority == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        ArrayList arranged = ContainerUtilRt.newArrayList();
        LinkedHashSet unprocessed = ContainerUtilRt.newLinkedHashSet();
        ArrayList dependent = ContainerUtilRt.newArrayList();
        for (ArrangementEntry entry : entries) {
            List dependencies = entry.getDependencies();
            if (dependencies == null) {
                unprocessed.add(entry);
                continue;
            }
            if (dependencies.size() == 1 && dependencies.get(0) == entry.getParent()) {
                arranged.add(entry);
                continue;
            }
            HashSet hashSet = new HashSet((Collection)dependencies);
            dependent.add(Pair.create((Object)hashSet, (Object)entry));
        }
        HashSet matched = new HashSet();
        MultiMap elementsByRule = new MultiMap();
        for (ArrangementMatchRule arrangementMatchRule : rulesByPriority) {
            matched.clear();
            for (ArrangementEntry entry : unprocessed) {
                if (!entry.canBeMatched() || !arrangementMatchRule.getMatcher().isMatched(entry)) continue;
                elementsByRule.putValue((Object)arrangementMatchRule, (Object)entry);
                matched.add(entry);
            }
            unprocessed.removeAll((Collection<?>)matched);
        }
        for (ArrangementMatchRule arrangementMatchRule : rules) {
            if (!elementsByRule.containsKey((Object)arrangementMatchRule)) continue;
            Collection arrangedEntries = elementsByRule.get((Object)arrangementMatchRule);
            if (StdArrangementTokens.Order.BY_NAME.equals((Object)arrangementMatchRule.getOrderType())) {
                ArrangementEngine.sortByName((List)arrangedEntries);
            }
            arranged.addAll(arrangedEntries);
        }
        arranged.addAll(unprocessed);
        for (int i = 0; i < arranged.size() && !dependent.isEmpty(); ++i) {
            ArrangementEntry arrangementEntry = (ArrangementEntry)arranged.get(i);
            ArrayList shouldBeAddedAfterCurrentElement = ContainerUtil.newArrayList();
            Iterator iterator = dependent.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                ((Set)pair.first).remove(arrangementEntry);
                if (!((Set)pair.first).isEmpty()) continue;
                iterator.remove();
                shouldBeAddedAfterCurrentElement.add(pair.second);
            }
            arranged.addAll(i + 1, shouldBeAddedAfterCurrentElement);
        }
        ArrayList arrayList = arranged;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        return arrayList;
    }

    private static <E extends ArrangementEntry> void sortByName(@NotNull List<E> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "sortByName"));
        }
        if (entries.size() < 2) {
            return;
        }
        final TObjectIntHashMap weights = new TObjectIntHashMap();
        int i = 0;
        for (ArrangementEntry e : entries) {
            weights.put((Object)e, ++i);
        }
        ContainerUtil.sort(entries, (Comparator)new Comparator<E>(){

            @Override
            public int compare(E e1, E e2) {
                String name2;
                String name1 = e1 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e1).getName() : null;
                String string = name2 = e2 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e2).getName() : null;
                if (name1 != null && name2 != null) {
                    return name1.compareTo(name2);
                }
                if (name1 == null && name2 == null) {
                    return weights.get(e1) - weights.get(e2);
                }
                if (name2 == null) {
                    return -1;
                }
                return 1;
            }
        });
    }

    private static <E extends ArrangementEntry> void doArrange(@NotNull List<ArrangementEntryWrapper<E>> wrappers, @NotNull Context<E> context) {
        if (wrappers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "doArrange"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "doArrange"));
        }
        if (wrappers.isEmpty()) {
            return;
        }
        HashMap map = ContainerUtilRt.newHashMap();
        ArrayList arranged = ContainerUtilRt.newArrayList();
        ArrayList toArrange = ContainerUtilRt.newArrayList();
        for (ArrangementEntryWrapper<E> wrapper : wrappers) {
            E entry = wrapper.getEntry();
            map.put(wrapper.getEntry(), wrapper);
            if (!entry.canBeMatched()) {
                if (toArrange.isEmpty()) {
                    arranged.addAll(ArrangementEngine.arrange(toArrange, context.rules, context.rulesByPriority));
                }
                arranged.add(entry);
                toArrange.clear();
                continue;
            }
            toArrange.add(entry);
        }
        if (!toArrange.isEmpty()) {
            arranged.addAll(ArrangementEngine.arrange(toArrange, context.rules, context.rulesByPriority));
        }
        context.changer.prepare(wrappers, context);
        for (int i = arranged.size() - 1; i >= 0; --i) {
            ArrangementEntryWrapper<E> previousInitial;
            ArrangementEntryWrapper arrangedWrapper = (ArrangementEntryWrapper)map.get(arranged.get(i));
            ArrangementEntryWrapper<E> initialWrapper = wrappers.get(i);
            ArrangementEntryWrapper previous = i > 0 ? (ArrangementEntryWrapper)map.get(arranged.get(i - 1)) : null;
            ArrangementEntryWrapper<E> arrangementEntryWrapper = previousInitial = i > 0 ? wrappers.get(i - 1) : null;
            if (arrangedWrapper.equals(initialWrapper) && (previous != null && previous.equals(previousInitial) || previous == null && previousInitial == null)) continue;
            context.changer.replace(arrangedWrapper, initialWrapper, previous, context);
        }
    }

    private static class RangeMarkerAwareChanger<E extends ArrangementEntry>
    implements Changer<E> {
        @NotNull
        private final List<ArrangementEntryWrapper<E>> myWrappers;
        @NotNull
        private final DocumentEx myDocument;

        RangeMarkerAwareChanger(@NotNull DocumentEx document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "<init>"));
            }
            this.myWrappers = new ArrayList<ArrangementEntryWrapper<E>>();
            this.myDocument = document;
        }

        @Override
        public void prepare(@NotNull List<ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context) {
            if (toArrange == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "prepare"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "prepare"));
            }
            this.myWrappers.clear();
            this.myWrappers.addAll(toArrange);
            for (ArrangementEntryWrapper<E> wrapper : toArrange) {
                wrapper.updateBlankLines(this.myDocument);
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @NotNull Context<E> context) {
            if (newWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "replace"));
            }
            if (oldWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "replace"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "replace"));
            }
            int blankLinesBefore = oldWrapper.getBlankLinesBefore();
            ArrangementEntryWrapper<E> parentWrapper = oldWrapper.getParent();
            int desiredBlankLinesNumber = context.rearranger.getBlankLines(context.settings, parentWrapper == null ? null : (ArrangementEntry)parentWrapper.getEntry(), previous == null ? null : (ArrangementEntry)previous.getEntry(), newWrapper.getEntry());
            if ((desiredBlankLinesNumber < 0 || desiredBlankLinesNumber == blankLinesBefore) && newWrapper.equals(oldWrapper)) {
                return;
            }
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            int insertionOffset = oldWrapper.getStartOffset();
            if (oldWrapper.getStartOffset() > newWrapper.getStartOffset()) {
                insertionOffset -= newWrapper.getEndOffset() - newWrapper.getStartOffset();
            }
            if (newWrapper.getStartOffset() != oldWrapper.getStartOffset() || !newWrapper.equals(oldWrapper)) {
                context.addMoveInfo(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                this.myDocument.moveText(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                for (int i = this.myWrappers.size() - 1; i >= 0; --i) {
                    ArrangementEntryWrapper<E> w = this.myWrappers.get(i);
                    if (w == newWrapper) continue;
                    if (w.getStartOffset() >= oldWrapper.getStartOffset() && w.getStartOffset() < newWrapper.getStartOffset()) {
                        w.applyShift(newWrapper.getEndOffset() - newWrapper.getStartOffset());
                        continue;
                    }
                    if (oldWrapper == w || w.getStartOffset() > oldWrapper.getStartOffset() || w.getStartOffset() <= newWrapper.getStartOffset()) continue;
                    w.applyShift(newWrapper.getStartOffset() - newWrapper.getEndOffset());
                }
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff > 0) {
                this.myDocument.insertString(insertionOffset, StringUtil.repeat((String)"\n", (int)lineFeedsDiff));
                this.shiftOffsets(lineFeedsDiff, insertionOffset);
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff < 0) {
                int replacementStartOffset = this.getBlankLineOffset(-lineFeedsDiff, insertionOffset);
                this.myDocument.deleteString(replacementStartOffset, insertionOffset);
                this.shiftOffsets(replacementStartOffset - insertionOffset, insertionOffset);
            }
            if (desiredBlankLinesNumber < 0 || lineFeedsDiff == 0 || parentWrapper == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents.add(parentWrapper);
                parentWrapper.setEndOffset(parentWrapper.getEndOffset() + lineFeedsDiff);
            } while ((parentWrapper = parentWrapper.getParent()) != null);
            while (!parents.isEmpty()) {
                for (ArrangementEntryWrapper wrapper = ((ArrangementEntryWrapper)parents.removeLast()).getNext(); wrapper != null; wrapper = wrapper.getNext()) {
                    wrapper.applyShift(lineFeedsDiff);
                }
            }
        }

        private int getBlankLineOffset(int blankLinesNumber, int startOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            if (startLine <= 0) {
                return 0;
            }
            CharSequence text = this.myDocument.getCharsSequence();
            int i = this.myDocument.getLineStartOffset(startLine - 1) - 1;
            while (i >= 0) {
                if (--blankLinesNumber <= 0) {
                    return i + 1;
                }
                i = CharArrayUtil.lastIndexOf((CharSequence)text, (String)"\n", (int)(i - 1));
            }
            return 0;
        }

        private void shiftOffsets(int shift, int changeOffset) {
            ArrangementEntryWrapper<E> wrapper;
            for (int i = this.myWrappers.size() - 1; i >= 0 && (wrapper = this.myWrappers.get(i)).getStartOffset() >= changeOffset; --i) {
                wrapper.applyShift(shift);
            }
        }
    }

    private static class DefaultChanger<E extends ArrangementEntry>
    implements Changer<E> {
        @NotNull
        private String myParentText;
        private int myParentShift;

        private DefaultChanger() {
        }

        @Override
        public void prepare(@NotNull List<ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context) {
            if (toArrange == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "prepare"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "prepare"));
            }
            ArrangementEntryWrapper<E> parent = toArrange.get(0).getParent();
            if (parent == null) {
                this.myParentText = context.document.getText();
                this.myParentShift = 0;
            } else {
                this.myParentText = ((Object)context.document.getCharsSequence().subSequence(parent.getStartOffset(), parent.getEndOffset())).toString();
                this.myParentShift = parent.getStartOffset();
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @NotNull Context<E> context) {
            ArrangementEntryWrapper<E> parentWrapper;
            int desiredBlankLinesNumber;
            if (newWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "replace"));
            }
            if (oldWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "replace"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "replace"));
            }
            int blankLinesBefore = 0;
            TIntArrayList lineFeedOffsets = new TIntArrayList();
            int oldStartLine = context.document.getLineNumber(oldWrapper.getStartOffset());
            if (oldStartLine > 0) {
                int lastLineFeed = context.document.getLineStartOffset(oldStartLine) - 1;
                lineFeedOffsets.add(lastLineFeed);
                for (int i = lastLineFeed - 1 - this.myParentShift; i >= 0 && this.myParentText.charAt(i = CharArrayUtil.shiftBackward((CharSequence)this.myParentText, (int)i, (String)" \t")) == '\n'; --i) {
                    ++blankLinesBefore;
                    lineFeedOffsets.add(i + this.myParentShift);
                }
            }
            if ((desiredBlankLinesNumber = context.rearranger.getBlankLines(context.settings, (parentWrapper = oldWrapper.getParent()) == null ? null : (ArrangementEntry)parentWrapper.getEntry(), previous == null ? null : (ArrangementEntry)previous.getEntry(), newWrapper.getEntry())) == blankLinesBefore && newWrapper.equals(oldWrapper)) {
                return;
            }
            String newEntryText = this.myParentText.substring(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift);
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            if (lineFeedsDiff == 0 || desiredBlankLinesNumber < 0) {
                context.addMoveInfo(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift, oldWrapper.getStartOffset());
                context.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), (CharSequence)newEntryText);
                return;
            }
            if (lineFeedsDiff > 0) {
                StringBuilder buffer = new StringBuilder(StringUtil.repeat((String)"\n", (int)lineFeedsDiff));
                buffer.append(newEntryText);
                context.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), (CharSequence)buffer);
            } else {
                int replacementStartOffset = lineFeedOffsets.get(-lineFeedsDiff) + 1;
                context.document.replaceString(replacementStartOffset, oldWrapper.getEndOffset(), (CharSequence)newEntryText);
            }
            ArrangementEntryWrapper<E> parent = oldWrapper.getParent();
            if (parent == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents.add(parent);
                parent.setEndOffset(parent.getEndOffset() + lineFeedsDiff);
            } while ((parent = parent.getParent()) != null);
            while (!parents.isEmpty()) {
                for (ArrangementEntryWrapper wrapper = ((ArrangementEntryWrapper)parents.removeLast()).getNext(); wrapper != null; wrapper = wrapper.getNext()) {
                    wrapper.applyShift(lineFeedsDiff);
                }
            }
        }
    }

    private static interface Changer<E extends ArrangementEntry> {
        public void prepare(@NotNull List<ArrangementEntryWrapper<E>> var1, @NotNull Context<E> var2);

        public void replace(@NotNull ArrangementEntryWrapper<E> var1, @NotNull ArrangementEntryWrapper<E> var2, @Nullable ArrangementEntryWrapper<E> var3, @NotNull Context<E> var4);
    }

    private static class StackEntry {
        public int start;
        public int current;
        public int end;

        StackEntry(int start, int count) {
            this.start = start;
            this.current = start;
            this.end = start + count;
        }
    }

    private static class Context<E extends ArrangementEntry> {
        @NotNull
        public final List<ArrangementMoveInfo> moveInfos;
        @NotNull
        public final Rearranger<E> rearranger;
        @NotNull
        public final Collection<ArrangementEntryWrapper<E>> wrappers;
        @NotNull
        public final Document document;
        @NotNull
        public final List<? extends ArrangementMatchRule> rules;
        @NotNull
        public final List<? extends ArrangementMatchRule> rulesByPriority;
        @NotNull
        public final CodeStyleSettings settings;
        @NotNull
        public final Changer changer;

        private Context(@NotNull Rearranger<E> rearranger, @NotNull Collection<ArrangementEntryWrapper<E>> wrappers, @NotNull Document document, @NotNull List<? extends ArrangementMatchRule> rules, @NotNull List<? extends ArrangementMatchRule> rulesByPriority, @NotNull CodeStyleSettings settings, @NotNull Changer changer) {
            if (rearranger == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (wrappers == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (rules == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (rulesByPriority == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (changer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            this.moveInfos = ContainerUtilRt.newArrayList();
            this.rearranger = rearranger;
            this.wrappers = wrappers;
            this.document = document;
            this.rules = rules;
            this.rulesByPriority = rulesByPriority;
            this.settings = settings;
            this.changer = changer;
        }

        public void addMoveInfo(int oldStart, int oldEnd, int newStart) {
            this.moveInfos.add(new ArrangementMoveInfo(oldStart, oldEnd, newStart));
        }

        public static <T extends ArrangementEntry> Context<T> from(@NotNull Rearranger<T> rearranger, @NotNull Document document, @NotNull PsiElement root, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings arrangementSettings, @NotNull CodeStyleSettings codeStyleSettings) {
            if (rearranger == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (arrangementSettings == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (codeStyleSettings == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            List entries = rearranger.parse(root, document, ranges, arrangementSettings);
            ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>> wrappers = new ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>>();
            ArrangementEntryWrapper<ArrangementEntry> previous = null;
            for (ArrangementEntry entry : entries) {
                ArrangementEntryWrapper<ArrangementEntry> wrapper = new ArrangementEntryWrapper<ArrangementEntry>(entry);
                if (previous != null) {
                    previous.setNext(wrapper);
                    wrapper.setPrevious(previous);
                }
                wrappers.add(wrapper);
                previous = wrapper;
            }
            Changer changer = document instanceof DocumentEx ? new RangeMarkerAwareChanger((DocumentEx)document) : new DefaultChanger();
            List rulesByPriority = ArrangementUtil.getRulesSortedByPriority((ArrangementSettings)arrangementSettings);
            return new Context<T>(rearranger, wrappers, document, arrangementSettings.getRules(), rulesByPriority, codeStyleSettings, changer);
        }
    }
}

