/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NonClasspathResolveScopeEnlarger
extends ResolveScopeEnlarger {
    @Override
    public SearchScope getAdditionalResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/NonClasspathResolveScopeEnlarger", "getAdditionalResolveScope"));
        }
        String fileExtension = file.getExtension();
        if ("class".equals(fileExtension) || "java".equals(fileExtension)) {
            for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)project)) {
                if (!(finder instanceof NonClasspathClassFinder)) continue;
                List<VirtualFile> roots = ((NonClasspathClassFinder)finder).getClassRoots();
                for (VirtualFile root : roots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                    return NonClasspathDirectoriesScope.compose(roots);
                }
            }
        }
        return null;
    }
}

