/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.components.StorageScheme;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProjectFormatPanel {
    private static final String STORAGE_FORMAT_PROPERTY = "default.storage.format";
    public static final String DIR_BASED = ".idea (directory based)";
    private static final String FILE_BASED = ".ipr (file based)";
    private JComboBox myStorageFormatCombo;
    private JPanel myWholePanel;

    public ProjectFormatPanel() {
        this.$$$setupUI$$$();
        this.myStorageFormatCombo.insertItemAt(DIR_BASED, 0);
        this.myStorageFormatCombo.insertItemAt(FILE_BASED, 1);
        this.myStorageFormatCombo.setSelectedItem(PropertiesComponent.getInstance().getOrInit(STORAGE_FORMAT_PROPERTY, DIR_BASED));
    }

    public JPanel getPanel() {
        return this.myWholePanel;
    }

    public JComboBox getStorageFormatComboBox() {
        return this.myStorageFormatCombo;
    }

    public void updateData(WizardContext context) {
        StorageScheme format = FILE_BASED.equals(this.myStorageFormatCombo.getSelectedItem()) ? StorageScheme.DEFAULT : StorageScheme.DIRECTORY_BASED;
        context.setProjectStorageFormat(format);
        ProjectFormatPanel.setDefaultFormat(this.isDefault());
    }

    public static void setDefaultFormat(boolean aDefault) {
        PropertiesComponent.getInstance().setValue(STORAGE_FORMAT_PROPERTY, aDefault ? FILE_BASED : DIR_BASED);
    }

    public void setVisible(boolean visible) {
        this.myWholePanel.setVisible(visible);
    }

    public boolean isDefault() {
        return FILE_BASED.equals(this.myStorageFormatCombo.getSelectedItem());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("Project format:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.myStorageFormatCombo = jComboBox = new JComboBox();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        jPanel.add(jComboBox, gridBagConstraints2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

