/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;

public abstract class JpsExportableOrderEntry<E extends JpsDependencyElement>
extends JpsOrderEntry<E>
implements ExportableOrderEntry {
    public JpsExportableOrderEntry(JpsRootModel rootModel, E dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public boolean isExported() {
        JpsJavaDependencyExtension extension = this.getExtension();
        return extension != null && extension.isExported();
    }

    public void setExported(boolean value) {
        JpsJavaExtensionService.getInstance().getOrCreateDependencyExtension(this.myDependencyElement).setExported(value);
    }

    @NotNull
    public DependencyScope getScope() {
        JpsJavaDependencyExtension extension = this.getExtension();
        DependencyScope dependencyScope = extension != null ? DependencyScope.valueOf((String)extension.getScope().name()) : DependencyScope.COMPILE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsExportableOrderEntry", "getScope"));
        }
        return dependencyScope;
    }

    @Nullable
    private JpsJavaDependencyExtension getExtension() {
        return JpsJavaExtensionService.getInstance().getDependencyExtension(this.myDependencyElement);
    }

    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/project/model/impl/module/dependencies/JpsExportableOrderEntry", "setScope"));
        }
        JpsJavaDependencyExtension extension = JpsJavaExtensionService.getInstance().getOrCreateDependencyExtension(this.myDependencyElement);
        extension.setScope(JpsJavaDependencyScope.valueOf((String)scope.name()));
    }
}

