/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProfileEx;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileManager
extends ApplicationProfileManager
implements SeverityProvider,
NamedComponent {
    @NonNls
    protected static final String INSPECTION_DIR = "inspection";
    @NonNls
    protected static final String FILE_SPEC = "$ROOT_CONFIG$/inspection";
    private final List<ProfileChangeAdapter> myProfileChangeAdapters = ContainerUtil.createLockFreeCopyOnWriteList();
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProfileManager");

    public static InspectionProfileManager getInstance() {
        return (InspectionProfileManager)ServiceManager.getService(InspectionProfileManager.class);
    }

    protected abstract void initProfiles();

    public abstract Profile loadProfile(@NotNull String var1) throws IOException, JDOMException;

    @NotNull
    public String getComponentName() {
        if ("InspectionProfileManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getComponentName"));
        }
        return "InspectionProfileManager";
    }

    public void addProfileChangeListener(@NotNull ProfileChangeAdapter listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManager", "addProfileChangeListener"));
        }
        this.myProfileChangeAdapters.add(listener);
    }

    public void addProfileChangeListener(@NotNull ProfileChangeAdapter listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManager", "addProfileChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/profile/codeInspection/InspectionProfileManager", "addProfileChangeListener"));
        }
        ContainerUtil.add((Object)listener, this.myProfileChangeAdapters, (Disposable)parentDisposable);
    }

    public void removeProfileChangeListener(@NotNull ProfileChangeAdapter listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManager", "removeProfileChangeListener"));
        }
        this.myProfileChangeAdapters.remove(listener);
    }

    public void fireProfileChanged(Profile profile) {
        if (profile instanceof ProfileEx) {
            ((ProfileEx)profile).profileChanged();
        }
        for (ProfileChangeAdapter adapter : this.myProfileChangeAdapters) {
            adapter.profileChanged(profile);
        }
    }

    public void fireProfileChanged(Profile oldProfile, Profile profile, NamedScope scope) {
        for (ProfileChangeAdapter adapter : this.myProfileChangeAdapters) {
            adapter.profileActivated(oldProfile, profile);
        }
    }

    @Nullable
    public static File getProfileDirectory() {
        String directoryPath = PathManager.getConfigPath() + File.separator + INSPECTION_DIR;
        File directory = new File(directoryPath);
        if (!directory.exists() && !directory.mkdir()) {
            return null;
        }
        return directory;
    }

    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManager", "getProfile"));
        }
        return this.getProfile(name, true);
    }
}

