/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateDialog
extends DialogWrapper {
    private static final String WHOLE_PROJECT = "<whole project>";
    @NotNull
    private final Project myProject;
    private JPanel myPanel;
    private JTextField myName;
    private EditorTextField myDescription;
    private JComboBox myModuleCombo;
    private JLabel myModuleLabel;
    private JBCheckBox myReplaceParameters;
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateDialog.class);

    protected SaveProjectAsTemplateDialog(@NotNull Project project, @Nullable VirtualFile descriptionFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/platform/templates/SaveProjectAsTemplateDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle("Save Project As Template");
        this.myName.setText(project.getName());
        Object[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length < 2) {
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            ArrayList<String> items = new ArrayList<String>(ContainerUtil.map((Object[])modules, (Function)new Function<Module, String>(){

                public String fun(Module module) {
                    return module.getName();
                }
            }));
            items.add(WHOLE_PROJECT);
            this.myModuleCombo.setModel(new CollectionComboBoxModel(items, (Object)WHOLE_PROJECT));
        }
        this.myDescription.setFileType(FileTypeManager.getInstance().getFileTypeByExtension(".html"));
        if (descriptionFile != null) {
            try {
                String s = VfsUtilCore.loadText((VirtualFile)descriptionFile);
                this.myDescription.setText(s);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "save.project.as.template.dialog";
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.myName.getText())) {
            return new ValidationInfo("Template name should not be empty");
        }
        return null;
    }

    protected void doOKAction() {
        File file = this.getTemplateFile();
        if (file.exists()) {
            if (Messages.showYesNoDialog((Component)this.myPanel, (String)(FileUtil.getNameWithoutExtension((File)file) + " exists already.\n" + "Do you want to replace it with the new one?"), (String)"Template Already Exists", (Icon)Messages.getWarningIcon()) == 1) {
                return;
            }
            file.delete();
        }
        super.doOKAction();
    }

    File getTemplateFile() {
        String name = this.myName.getText();
        return ArchivedTemplatesFactory.getTemplateFile(name);
    }

    String getDescription() {
        return this.myDescription.getText();
    }

    boolean isReplaceParameters() {
        return this.myReplaceParameters.isSelected();
    }

    @Nullable
    Module getModuleToSave() {
        String item = (String)this.myModuleCombo.getSelectedItem();
        if (item == null || item.equals(WHOLE_PROJECT)) {
            return null;
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(item);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        JComboBox jComboBox;
        EditorTextField editorTextField;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Description:");
        jBLabel2.setDisplayedMnemonic('D');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myDescription = editorTextField = new EditorTextField();
        jPanel.add((Component)((Object)editorTextField), new GridConstraints(2, 1, 2, 1, 0, 3, 3, 3, null, new Dimension(-1, 60), null));
        this.myModuleCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jLabel = new JLabel();
        jLabel.setText("Save:");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceParameters = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Replace parameters with placeholders");
        jBCheckBox.setMnemonic('R');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

