/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ManageProjectTemplatesDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JBList myTemplatesList;
    private final JTextPane myDescriptionPane;

    ManageProjectTemplatesDialog() {
        super(false);
        this.setTitle("Manage Project Templates");
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined", new WizardContext(null));
        CollectionListModel<ProjectTemplate> model = new CollectionListModel<ProjectTemplate>(Arrays.asList(templates)){

            public void remove(int index) {
                ProjectTemplate template = (ProjectTemplate)this.getElementAt(index);
                super.remove(index);
                if (template instanceof LocalArchivedTemplate) {
                    URL path = ((LocalArchivedTemplate)template).getArchivePath();
                    new File(path.getPath()).delete();
                }
            }
        };
        this.myTemplatesList = new JBList((ListModel)model);
        this.myTemplatesList.setEmptyText("No user-defined project templates");
        this.myTemplatesList.setPreferredSize(new Dimension(300, 100));
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append(((ProjectTemplate)value).getName());
            }
        });
        this.myTemplatesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplate template = ManageProjectTemplatesDialog.this.getSelectedTemplate();
                ManageProjectTemplatesDialog.this.myDescriptionPane.setText(template == null ? null : template.getDescription());
            }
        });
        this.myPanel = new JPanel(new BorderLayout(0, 5));
        this.myPanel.add(ToolbarDecorator.createDecorator((JList)this.myTemplatesList).disableUpDownActions().createPanel());
        this.myDescriptionPane = new JTextPane();
        this.myDescriptionPane.setPreferredSize(new Dimension(300, 50));
        Messages.installHyperlinkSupport((JTextPane)this.myDescriptionPane);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myDescriptionPane, (int)22, (int)30), "South");
        if (templates.length > 0) {
            this.myTemplatesList.setSelectedValue((Object)templates[0], true);
        }
        this.init();
    }

    @Nullable
    private ProjectTemplate getSelectedTemplate() {
        return (ProjectTemplate)this.myTemplatesList.getSelectedValue();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperAction(CommonBundle.getCloseButtonText()){

            protected void doAction(ActionEvent e) {
                ManageProjectTemplatesDialog.this.doCancelAction();
            }
        }};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ManageProjectTemplatesDialog", "createActions"));
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTemplatesList;
    }
}

