/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchivedProjectTemplate
implements ProjectTemplate {
    protected final String myDisplayName;
    @Nullable
    private final String myCategory;

    public ArchivedProjectTemplate(@NotNull String displayName, @Nullable String category) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/platform/templates/ArchivedProjectTemplate", "<init>"));
        }
        this.myDisplayName = displayName;
        this.myCategory = category;
    }

    @NotNull
    public String getName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedProjectTemplate", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return this.getModuleType().getIcon();
    }

    protected abstract ModuleType getModuleType();

    @NotNull
    public ModuleBuilder createModuleBuilder() {
        TemplateModuleBuilder templateModuleBuilder = new TemplateModuleBuilder(this, this.getModuleType(), this.getInputFields());
        if (templateModuleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedProjectTemplate", "createModuleBuilder"));
        }
        return templateModuleBuilder;
    }

    @NotNull
    public abstract List<WizardInputField> getInputFields();

    @NotNull
    public abstract List<String> getFeaturedFrameworks();

    @Nullable
    public ValidationInfo validateSettings() {
        return null;
    }

    public abstract ZipInputStream getStream() throws IOException;

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }
}

