/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.GeneralSettings;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.NewDirectoryProjectDialog;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class NewDirectoryProjectAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(NewDirectoryProjectAction.class);

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        NewDirectoryProjectDialog dlg = new NewDirectoryProjectDialog(project);
        dlg.show();
        if (dlg.getExitCode() != 0) {
            return;
        }
        this.generateProject(project, dlg);
    }

    protected Object showSettings(DirectoryProjectGenerator generator, VirtualFile baseDir) throws ProcessCanceledException {
        return generator.showGenerationSettings(baseDir);
    }

    @Nullable
    protected Project generateProject(Project project, NewDirectoryProjectDialog dlg) {
        int rc;
        final DirectoryProjectGenerator generator = dlg.getProjectGenerator();
        final File location = new File(dlg.getNewProjectLocation());
        if (!location.exists() && !location.mkdirs()) {
            Messages.showErrorDialog((Project)project, (String)("Cannot create directory '" + location + "'"), (String)"Create Project");
            return null;
        }
        final VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location);
            }
        });
        LOG.assertTrue(baseDir != null, (Object)("Couldn't find '" + location + "' in VFS"));
        baseDir.refresh(false, true);
        if (baseDir.getChildren().length > 0 && (rc = Messages.showYesNoDialog((Project)project, (String)("The directory '" + location + "' is not empty. Would you like to create a project from existing sources instead?"), (String)"Create New Project", (Icon)Messages.getQuestionIcon())) == 0) {
            return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        }
        String generatorName = generator == null ? "empty" : ConvertUsagesUtil.ensureProperKey(generator.getName());
        UsageTrigger.trigger("NewDirectoryProjectAction." + generatorName);
        Object settings = null;
        if (generator != null) {
            try {
                settings = this.showSettings(generator, baseDir);
            }
            catch (ProcessCanceledException e1) {
                return null;
            }
        }
        GeneralSettings.getInstance().setLastProjectCreationLocation(location.getParent());
        final Object finalSettings = settings;
        return PlatformProjectOpenProcessor.doOpenProject(baseDir, null, false, -1, new ProjectOpenedCallback(){

            public void projectOpened(Project project, Module module) {
                if (generator != null) {
                    generator.generateProject(project, baseDir, finalSettings, module);
                }
            }
        }, false);
    }
}

