/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FacetBasedPackagingElementType<E extends PackagingElement<?>, F extends Facet>
extends PackagingElementType<E> {
    private final FacetTypeId<F> myFacetType;

    protected FacetBasedPackagingElementType(@NotNull @NonNls String id, @NotNull String presentableName, FacetTypeId<F> facetType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "<init>"));
        }
        super(id, presentableName);
        this.myFacetType = facetType;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "canCreate"));
        }
        return !this.getFacets(context).isEmpty();
    }

    public Icon getCreateElementIcon() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetType).getIcon();
    }

    @NotNull
    public List<? extends E> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "chooseAndCreate"));
        }
        List<F> facets = this.getFacets(context);
        ChooseFacetsDialog dialog = new ChooseFacetsDialog(context.getProject(), facets, this.getDialogTitle(), this.getDialogDescription());
        dialog.show();
        if (dialog.isOK()) {
            ArrayList<E> elements = new ArrayList<E>();
            for (Facet facet : dialog.getChosenElements()) {
                elements.add(this.createElement(context.getProject(), facet));
            }
            ArrayList<E> arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "chooseAndCreate"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType", "chooseAndCreate"));
        }
        return list;
    }

    private List<F> getFacets(ArtifactEditorContext context) {
        Module[] modules = context.getModulesProvider().getModules();
        ArrayList facets = new ArrayList();
        for (Module module : modules) {
            facets.addAll(context.getFacetsProvider().getFacetsByType(module, this.myFacetType));
        }
        return facets;
    }

    protected abstract E createElement(Project var1, F var2);

    protected abstract String getDialogTitle();

    protected abstract String getDialogDescription();

    protected abstract String getItemText(F var1);

    private class ChooseFacetsDialog
    extends ChooseElementsDialog<F> {
        private ChooseFacetsDialog(Project project, List<? extends F> items, String title, String description) {
            super(project, items, title, description, true);
        }

        @Override
        protected String getItemText(F item) {
            return FacetBasedPackagingElementType.this.getItemText(item);
        }

        @Override
        protected Icon getItemIcon(F item) {
            return FacetTypeRegistry.getInstance().findFacetType(FacetBasedPackagingElementType.this.myFacetType).getIcon();
        }
    }
}

