/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.impl.compiler.ArtifactsProcessingItemsBuilderContext;
import com.intellij.packaging.impl.compiler.IncrementalCompilerInstructionCreatorBase;
import com.intellij.packaging.impl.compiler.SkipAllInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class PackIntoArchiveInstructionCreator
extends IncrementalCompilerInstructionCreatorBase {
    private final DestinationInfo myJarDestination;
    private final JarInfo myJarInfo;
    private final String myPathInJar;

    public PackIntoArchiveInstructionCreator(ArtifactsProcessingItemsBuilderContext context, JarInfo jarInfo, String pathInJar, DestinationInfo jarDestination) {
        super(context);
        this.myJarInfo = jarInfo;
        this.myPathInJar = pathInJar;
        this.myJarDestination = jarDestination;
    }

    public void addFileCopyInstruction(@NotNull VirtualFile file, @NotNull String outputFileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/PackIntoArchiveInstructionCreator", "addFileCopyInstruction"));
        }
        if (outputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/PackIntoArchiveInstructionCreator", "addFileCopyInstruction"));
        }
        String pathInJar = this.childPathInJar(outputFileName);
        if (this.myContext.addDestination(file, new JarDestinationInfo(pathInJar, this.myJarInfo, this.myJarDestination))) {
            this.myJarInfo.addContent(pathInJar, file);
        }
    }

    private String childPathInJar(String fileName) {
        return this.myPathInJar.length() == 0 ? fileName : this.myPathInJar + "/" + fileName;
    }

    @Override
    public PackIntoArchiveInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/PackIntoArchiveInstructionCreator", "subFolder"));
        }
        return new PackIntoArchiveInstructionCreator(this.myContext, this.myJarInfo, this.childPathInJar(directoryName), this.myJarDestination);
    }

    public IncrementalCompilerInstructionCreator archive(@NotNull String archiveFileName) {
        if (archiveFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/PackIntoArchiveInstructionCreator", "archive"));
        }
        JarInfo jarInfo = new JarInfo();
        String outputPath = this.myJarDestination.getOutputPath() + "/" + archiveFileName;
        if (!this.myContext.registerJarFile(jarInfo, outputPath)) {
            return new SkipAllInstructionCreator(this.myContext);
        }
        JarDestinationInfo destination = new JarDestinationInfo(this.childPathInJar(archiveFileName), this.myJarInfo, this.myJarDestination);
        jarInfo.addDestination(destination);
        return new PackIntoArchiveInstructionCreator(this.myContext, jarInfo, "", destination);
    }
}

