/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.packagingCompiler.ExplodedDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.impl.compiler.ArtifactsProcessingItemsBuilderContext;
import com.intellij.packaging.impl.compiler.IncrementalCompilerInstructionCreatorBase;
import com.intellij.packaging.impl.compiler.PackIntoArchiveInstructionCreator;
import com.intellij.packaging.impl.compiler.SkipAllInstructionCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyToDirectoryInstructionCreator
extends IncrementalCompilerInstructionCreatorBase {
    private final String myOutputPath;
    @Nullable
    private final VirtualFile myOutputFile;

    public CopyToDirectoryInstructionCreator(ArtifactsProcessingItemsBuilderContext context, String outputPath, @Nullable VirtualFile outputFile) {
        super(context);
        this.myOutputPath = outputPath;
        this.myOutputFile = outputFile;
    }

    public void addFileCopyInstruction(@NotNull VirtualFile file, @NotNull String outputFileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/CopyToDirectoryInstructionCreator", "addFileCopyInstruction"));
        }
        if (outputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/CopyToDirectoryInstructionCreator", "addFileCopyInstruction"));
        }
        this.myContext.addDestination(file, new ExplodedDestinationInfo(this.myOutputPath + "/" + outputFileName, this.outputChild(outputFileName)));
    }

    @Override
    public CopyToDirectoryInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/CopyToDirectoryInstructionCreator", "subFolder"));
        }
        return new CopyToDirectoryInstructionCreator(this.myContext, this.myOutputPath + "/" + directoryName, this.outputChild(directoryName));
    }

    public IncrementalCompilerInstructionCreator archive(@NotNull String archiveFileName) {
        if (archiveFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/CopyToDirectoryInstructionCreator", "archive"));
        }
        JarInfo jarInfo = new JarInfo();
        String jarOutputPath = this.myOutputPath + "/" + archiveFileName;
        if (!this.myContext.registerJarFile(jarInfo, jarOutputPath)) {
            return new SkipAllInstructionCreator(this.myContext);
        }
        VirtualFile outputFile = this.outputChild(archiveFileName);
        ExplodedDestinationInfo destination = new ExplodedDestinationInfo(jarOutputPath, outputFile);
        jarInfo.addDestination(destination);
        return new PackIntoArchiveInstructionCreator(this.myContext, jarInfo, "", destination);
    }

    @Nullable
    private VirtualFile outputChild(String name) {
        return this.myOutputFile != null ? this.myOutputFile.findChild(name) : null;
    }
}

