/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.ExplodedDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.impl.compiler.ArtifactCompilerCompileItem;
import com.intellij.packaging.impl.compiler.ArtifactsCompilerInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsProcessingItemsBuilderContext
implements ArtifactIncrementalCompilerContext {
    protected final Map<VirtualFile, ArtifactCompilerCompileItem> myItemsBySource;
    private final Map<String, VirtualFile> mySourceByOutput;
    private final Map<String, JarInfo> myJarByPath;
    private final CompileContext myCompileContext;
    private final boolean myPrintToLog;

    public ArtifactsProcessingItemsBuilderContext(CompileContext compileContext) {
        this.myCompileContext = compileContext;
        this.myItemsBySource = new HashMap<VirtualFile, ArtifactCompilerCompileItem>();
        this.mySourceByOutput = new HashMap<String, VirtualFile>();
        this.myJarByPath = new HashMap<String, JarInfo>();
        this.myPrintToLog = ArtifactsCompilerInstance.FULL_LOG.isDebugEnabled();
    }

    public boolean addDestination(@NotNull VirtualFile sourceFile, @NotNull DestinationInfo destinationInfo) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext", "addDestination"));
        }
        if (destinationInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext", "addDestination"));
        }
        if (destinationInfo instanceof ExplodedDestinationInfo && sourceFile.equals(destinationInfo.getOutputFile())) {
            return false;
        }
        if (this.checkOutputPath(destinationInfo.getOutputPath(), sourceFile)) {
            if (this.myPrintToLog) {
                ArtifactsCompilerInstance.FULL_LOG.debug("  " + sourceFile.getPath() + " -> " + destinationInfo);
            }
            this.getOrCreateProcessingItem(sourceFile).addDestination(destinationInfo);
            return true;
        }
        return false;
    }

    public Collection<ArtifactCompilerCompileItem> getProcessingItems() {
        return this.myItemsBySource.values();
    }

    public boolean checkOutputPath(String outputPath, VirtualFile sourceFile) {
        VirtualFile old = this.mySourceByOutput.get(outputPath);
        if (old == null) {
            this.mySourceByOutput.put(outputPath, sourceFile);
            return true;
        }
        return false;
    }

    public ArtifactCompilerCompileItem getItemBySource(VirtualFile source) {
        return this.myItemsBySource.get(source);
    }

    public boolean registerJarFile(@NotNull JarInfo jarInfo, @NotNull String outputPath) {
        if (jarInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext", "registerJarFile"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext", "registerJarFile"));
        }
        if (this.mySourceByOutput.containsKey(outputPath) || this.myJarByPath.containsKey(outputPath)) {
            return false;
        }
        this.myJarByPath.put(outputPath, jarInfo);
        return true;
    }

    @Nullable
    public JarInfo getJarInfo(String outputPath) {
        return this.myJarByPath.get(outputPath);
    }

    @Nullable
    public VirtualFile getSourceByOutput(String outputPath) {
        return this.mySourceByOutput.get(outputPath);
    }

    public CompileContext getCompileContext() {
        return this.myCompileContext;
    }

    public ArtifactCompilerCompileItem getOrCreateProcessingItem(VirtualFile sourceFile) {
        ArtifactCompilerCompileItem item = this.myItemsBySource.get(sourceFile);
        if (item == null) {
            item = new ArtifactCompilerCompileItem(sourceFile);
            this.myItemsBySource.put(sourceFile, item);
        }
        return item;
    }
}

