/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.ExplodedDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.IgnoredFileFilter;
import com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.compiler.impl.packagingCompiler.JarsBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.generic.GenericCompilerCacheState;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.GenericCompilerProcessingItem;
import com.intellij.openapi.compiler.generic.VirtualFilePersistentState;
import com.intellij.openapi.compiler.make.BuildParticipant;
import com.intellij.openapi.compiler.make.BuildParticipantProvider;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactSortingUtil;
import com.intellij.packaging.impl.compiler.ArtifactBuildTarget;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactCompilerCompileItem;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemOutputState;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.packaging.impl.compiler.ArtifactsProcessingItemsBuilderContext;
import com.intellij.packaging.impl.compiler.CopyToDirectoryInstructionCreator;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactsCompilerInstance
extends GenericCompilerInstance<ArtifactBuildTarget, ArtifactCompilerCompileItem, String, VirtualFilePersistentState, ArtifactPackagingItemOutputState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.compiler.ArtifactsCompilerInstance");
    public static final Logger FULL_LOG = Logger.getInstance((String)"#com.intellij.full-artifacts-compiler-log");
    private ArtifactsProcessingItemsBuilderContext myBuilderContext;

    public ArtifactsCompilerInstance(CompileContext context) {
        super(context);
    }

    @Override
    @NotNull
    public List<ArtifactBuildTarget> getAllTargets() {
        List<ArtifactBuildTarget> list = this.getArtifactTargets(false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "getAllTargets"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ArtifactBuildTarget> getSelectedTargets() {
        List<ArtifactBuildTarget> list = this.getArtifactTargets(true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "getSelectedTargets"));
        }
        return list;
    }

    private List<ArtifactBuildTarget> getArtifactTargets(final boolean selectedOnly) {
        final ArrayList<ArtifactBuildTarget> targets = new ArrayList<ArtifactBuildTarget>();
        new ReadAction(){

            protected void run(Result result) {
                Set<Artifact> artifacts = selectedOnly ? ArtifactCompileScope.getArtifactsToBuild(ArtifactsCompilerInstance.this.getProject(), ArtifactsCompilerInstance.this.myContext.getCompileScope(), true) : new HashSet<Artifact>(Arrays.asList(ArtifactManager.getInstance((Project)ArtifactsCompilerInstance.this.getProject()).getArtifacts()));
                HashMap<String, Artifact> artifactsMap = new HashMap<String, Artifact>();
                for (Artifact artifact : artifacts) {
                    artifactsMap.put(artifact.getName(), artifact);
                }
                for (String name : ArtifactSortingUtil.getInstance(ArtifactsCompilerInstance.this.getProject()).getArtifactsSortedByInclusion()) {
                    Artifact artifact = (Artifact)artifactsMap.get(name);
                    if (artifact == null) continue;
                    targets.add(new ArtifactBuildTarget(artifact));
                }
                for (BuildParticipantProvider provider : (BuildParticipantProvider[])BuildParticipantProvider.EXTENSION_POINT_NAME.getExtensions()) {
                    for (Module module : ModuleManager.getInstance((Project)ArtifactsCompilerInstance.this.getProject()).getModules()) {
                        Collection participants = provider.getParticipants(module);
                        for (BuildParticipant participant : participants) {
                            Artifact artifact = participant.createArtifact(ArtifactsCompilerInstance.this.myContext);
                            if (artifact == null) continue;
                            LOG.debug("additional artifact to build: " + artifact);
                            targets.add(new ArtifactBuildTarget(artifact));
                        }
                    }
                }
            }
        }.execute();
        return targets;
    }

    @Override
    public void processObsoleteTarget(@NotNull String targetId, @NotNull List<GenericCompilerCacheState<String, VirtualFilePersistentState, ArtifactPackagingItemOutputState>> obsoleteItems) {
        if (targetId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "processObsoleteTarget"));
        }
        if (obsoleteItems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "processObsoleteTarget"));
        }
        this.deleteFiles(obsoleteItems, Collections.<GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState>>emptyList());
    }

    @Override
    @NotNull
    public List<ArtifactCompilerCompileItem> getItems(@NotNull ArtifactBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "getItems"));
        }
        this.myBuilderContext = new ArtifactsProcessingItemsBuilderContext(this.myContext);
        final Artifact artifact = target.getArtifact();
        Map selfIncludingArtifacts = (Map)new ReadAction<Map<String, String>>(){

            protected void run(Result<Map<String, String>> result) {
                result.setResult(ArtifactSortingUtil.getInstance(ArtifactsCompilerInstance.this.getProject()).getArtifactToSelfIncludingNameMap());
            }
        }.execute().getResultObject();
        String selfIncludingName = (String)selfIncludingArtifacts.get(artifact.getName());
        if (selfIncludingName != null) {
            String name = selfIncludingName.equals(artifact.getName()) ? "it" : "'" + selfIncludingName + "' artifact";
            this.myContext.addMessage(CompilerMessageCategory.ERROR, "Cannot build '" + artifact.getName() + "' artifact: " + name + " includes itself in the output layout", null, -1, -1);
            List<ArtifactCompilerCompileItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "getItems"));
            }
            return list;
        }
        final String outputPath = artifact.getOutputPath();
        if (outputPath == null || outputPath.length() == 0) {
            this.myContext.addMessage(CompilerMessageCategory.ERROR, "Cannot build '" + artifact.getName() + "' artifact: output path is not specified", null, -1, -1);
            List<ArtifactCompilerCompileItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "getItems"));
            }
            return list;
        }
        DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                ArtifactsCompilerInstance.this.collectItems(artifact, outputPath);
            }
        });
        ArrayList<ArtifactCompilerCompileItem> arrayList = new ArrayList<ArtifactCompilerCompileItem>(this.myBuilderContext.getProcessingItems());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "getItems"));
        }
        return arrayList;
    }

    private void collectItems(@NotNull Artifact artifact, @NotNull String outputPath) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "collectItems"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "collectItems"));
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
        CopyToDirectoryInstructionCreator instructionCreator = new CopyToDirectoryInstructionCreator(this.myBuilderContext, outputPath, outputFile);
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)this.getProject()).getResolvingContext();
        FULL_LOG.debug("Collecting items for " + artifact.getName());
        rootElement.computeIncrementalCompilerInstructions((IncrementalCompilerInstructionCreator)instructionCreator, resolvingContext, (ArtifactIncrementalCompilerContext)this.myBuilderContext, artifact.getArtifactType());
    }

    private boolean doBuild(@NotNull Artifact artifact, List<GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState>> changedItems, Set<ArtifactCompilerCompileItem> processedItems, final @NotNull Set<String> writtenPaths, Set<String> deletedJars) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "doBuild"));
        }
        if (writtenPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "doBuild"));
        }
        FULL_LOG.debug("Building " + artifact.getName());
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        final DeploymentUtil deploymentUtil = DeploymentUtil.getInstance();
        final IgnoredFileFilter fileFilter = new IgnoredFileFilter();
        THashSet changedJars = new THashSet();
        for (String deletedJar : deletedJars) {
            ContainerUtil.addIfNotNull((Object)this.myBuilderContext.getJarInfo(deletedJar), (Collection)changedJars);
        }
        try {
            this.onBuildStartedOrFinished(artifact, false);
            if (this.myContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                return false;
            }
            int i = 0;
            for (GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState> item : changedItems) {
                final ArtifactCompilerCompileItem sourceItem = item.getItem();
                this.myContext.getProgressIndicator().checkCanceled();
                final Ref exception = Ref.create(null);
                new ReadAction((Set)changedJars){
                    final /* synthetic */ Set val$changedJars;
                    {
                        this.val$changedJars = set2;
                    }

                    protected void run(Result result) {
                        VirtualFile sourceFile = sourceItem.getFile();
                        for (DestinationInfo destination : sourceItem.getDestinations()) {
                            if (destination instanceof ExplodedDestinationInfo) {
                                ExplodedDestinationInfo explodedDestination = (ExplodedDestinationInfo)destination;
                                File toFile = new File(FileUtil.toSystemDependentName((String)explodedDestination.getOutputPath()));
                                try {
                                    if (sourceFile.isInLocalFileSystem()) {
                                        File ioFromFile = VfsUtilCore.virtualToIoFile((VirtualFile)sourceFile);
                                        if (ioFromFile.exists()) {
                                            deploymentUtil.copyFile(ioFromFile, toFile, ArtifactsCompilerInstance.this.myContext, writtenPaths, fileFilter);
                                            continue;
                                        }
                                        LOG.debug("Cannot copy " + ioFromFile.getAbsolutePath() + ": file doesn't exist");
                                        continue;
                                    }
                                    ArtifactsCompilerInstance.this.extractFile(sourceFile, toFile, writtenPaths, fileFilter);
                                    continue;
                                }
                                catch (IOException e) {
                                    exception.set((Object)e);
                                    return;
                                }
                            }
                            this.val$changedJars.add(((JarDestinationInfo)destination).getJarInfo());
                        }
                    }
                }.execute();
                if (exception.get() != null) {
                    throw (IOException)exception.get();
                }
                this.myContext.getProgressIndicator().setFraction((double)(++i) * 1.0 / (double)changedItems.size());
                processedItems.add(sourceItem);
                if (!testMode) continue;
                CompilerManagerImpl.addRecompiledPath(FileUtil.toSystemDependentName((String)sourceItem.getFile().getPath()));
            }
            JarsBuilder builder = new JarsBuilder((Set<JarInfo>)changedJars, fileFilter, this.myContext);
            boolean processed = builder.buildJars(writtenPaths);
            if (!processed) {
                return false;
            }
            HashSet<Object> recompiledSources = new HashSet<Object>();
            for (JarInfo jarInfo : builder.getJarsToBuild()) {
                for (Pair<String, VirtualFile> pair : jarInfo.getPackedFiles()) {
                    recompiledSources.add(pair.getSecond());
                }
            }
            for (VirtualFile virtualFile : recompiledSources) {
                ArtifactCompilerCompileItem item = this.myBuilderContext.getItemBySource(virtualFile);
                LOG.assertTrue(item != null, (Object)virtualFile);
                processedItems.add(item);
                if (!testMode) continue;
                CompilerManagerImpl.addRecompiledPath(FileUtil.toSystemDependentName((String)item.getFile().getPath()));
            }
            this.onBuildStartedOrFinished(artifact, true);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            this.myContext.addMessage(CompilerMessageCategory.ERROR, e.getLocalizedMessage(), null, -1, -1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFile(VirtualFile sourceFile, File toFile, Set<String> writtenPaths, FileFilter fileFilter) throws IOException {
        if (!writtenPaths.add(toFile.getPath())) {
            return;
        }
        if (!FileUtil.createParentDirs((File)toFile)) {
            this.myContext.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory for '" + toFile.getAbsolutePath() + "' file", null, -1, -1);
            return;
        }
        BufferedInputStream input = ArtifactCompilerUtil.getJarEntryInputStream(sourceFile, this.myContext);
        if (input == null) {
            return;
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(toFile));
        try {
            FileUtil.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            input.close();
            output.close();
        }
    }

    private void onBuildStartedOrFinished(@NotNull Artifact artifact, boolean finished) throws Exception {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "onBuildStartedOrFinished"));
        }
        for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
            ArtifactProperties properties = artifact.getProperties(provider);
            if (finished) {
                properties.onBuildFinished(artifact, this.myContext);
                continue;
            }
            properties.onBuildStarted(artifact, this.myContext);
        }
    }

    private static THashSet<String> createPathsHashSet() {
        return new THashSet(FileUtil.PATH_HASHING_STRATEGY);
    }

    @Override
    public void processItems(final @NotNull ArtifactBuildTarget target, final @NotNull List<GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState>> changedItems, @NotNull List<GenericCompilerCacheState<String, VirtualFilePersistentState, ArtifactPackagingItemOutputState>> obsoleteItems, @NotNull GenericCompilerInstance.OutputConsumer<ArtifactCompilerCompileItem> consumer) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "processItems"));
        }
        if (changedItems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "processItems"));
        }
        if (obsoleteItems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "processItems"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/packaging/impl/compiler/ArtifactsCompilerInstance", "processItems"));
        }
        final THashSet<String> deletedJars = this.deleteFiles(obsoleteItems, changedItems);
        final THashSet<String> writtenPaths = ArtifactsCompilerInstance.createPathsHashSet();
        final Ref built = Ref.create((Object)false);
        final HashSet processedItems = new HashSet();
        CompilerUtil.runInContext(this.myContext, "Copying files", new ThrowableRunnable<RuntimeException>(){

            public void run() throws RuntimeException {
                built.set((Object)ArtifactsCompilerInstance.this.doBuild(target.getArtifact(), changedItems, processedItems, writtenPaths, (Set)deletedJars));
            }
        });
        if (!((Boolean)built.get()).booleanValue()) {
            return;
        }
        this.myContext.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.updating.caches", (Object[])new Object[0]));
        this.myContext.getProgressIndicator().setText2("");
        for (String path : writtenPaths) {
            consumer.addFileToRefresh(new File(path));
        }
        for (ArtifactCompilerCompileItem item : processedItems) {
            consumer.addProcessedItem(item);
        }
        ArtifactsCompiler.addWrittenPaths(this.myContext, writtenPaths);
        ArtifactsCompiler.addChangedArtifact(this.myContext, target.getArtifact());
    }

    private THashSet<String> deleteFiles(List<GenericCompilerCacheState<String, VirtualFilePersistentState, ArtifactPackagingItemOutputState>> obsoleteItems, List<GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState>> changedItems) {
        this.myContext.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.deleting.outdated.files", (Object[])new Object[0]));
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        THashSet deletedJars = new THashSet();
        THashSet notDeletedJars = new THashSet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting outdated files...");
        }
        THashSet pathToDelete = new THashSet();
        for (GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState> item : changedItems) {
            ArtifactPackagingItemOutputState cached = item.getCachedOutputState();
            if (cached == null) continue;
            for (Pair destination : cached.myDestinations) {
                pathToDelete.add(destination.getFirst());
            }
        }
        for (GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState> item : changedItems) {
            for (DestinationInfo destination : item.getItem().getDestinations()) {
                pathToDelete.remove(destination.getOutputPath());
            }
        }
        for (GenericCompilerProcessingItem<ArtifactCompilerCompileItem, VirtualFilePersistentState, ArtifactPackagingItemOutputState> item : obsoleteItems) {
            for (DestinationInfo destination : ((ArtifactPackagingItemOutputState)((GenericCompilerCacheState)((Object)item)).getOutputState()).myDestinations) {
                pathToDelete.add(destination.getFirst());
            }
        }
        int notDeletedFilesCount = 0;
        ArrayList<File> filesToRefresh = new ArrayList<File>();
        for (String fullPath : pathToDelete) {
            int end = fullPath.indexOf("!/");
            boolean isJar = end != -1;
            String filePath = isJar ? fullPath.substring(0, end) : fullPath;
            boolean deleted = false;
            if (isJar) {
                if (notDeletedJars.contains((Object)filePath)) continue;
                deleted = deletedJars.contains((Object)filePath);
            }
            File file = new File(FileUtil.toSystemDependentName((String)filePath));
            if (!deleted) {
                filesToRefresh.add(file);
                deleted = FileUtil.delete((File)file);
            }
            if (deleted) {
                if (isJar) {
                    deletedJars.add((Object)filePath);
                }
                if (!testMode) continue;
                CompilerManagerImpl.addDeletedPath(file.getAbsolutePath());
                continue;
            }
            if (isJar) {
                notDeletedJars.add((Object)filePath);
            }
            if (notDeletedFilesCount++ > 50) {
                this.myContext.addMessage(CompilerMessageCategory.WARNING, "Deletion of outdated files stopped because too many files cannot be deleted", null, -1, -1);
                break;
            }
            this.myContext.addMessage(CompilerMessageCategory.WARNING, "Cannot delete file '" + filePath + "'", null, -1, -1);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cannot delete file " + file);
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        return deletedJars;
    }
}

