/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.VirtualFilePersistentState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactBuildTarget;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemExternalizer;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemOutputState;
import com.intellij.packaging.impl.compiler.ArtifactsCompilerInstance;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsCompiler
extends GenericCompiler<String, VirtualFilePersistentState, ArtifactPackagingItemOutputState> {
    private static final Key<Set<String>> WRITTEN_PATHS_KEY = Key.create((String)"artifacts_written_paths");
    private static final Key<Set<Artifact>> CHANGED_ARTIFACTS = Key.create((String)"affected_artifacts");

    public ArtifactsCompiler() {
        super("artifacts_compiler", 0, GenericCompiler.CompileOrderPlace.PACKAGING);
    }

    @Nullable
    public static ArtifactsCompiler getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getInstance"));
        }
        ArtifactsCompiler[] compilers = (ArtifactsCompiler[])CompilerManager.getInstance((Project)project).getCompilers(ArtifactsCompiler.class);
        return compilers.length == 1 ? compilers[0] : null;
    }

    public static void addChangedArtifact(CompileContext context, Artifact artifact) {
        Set artifacts = (Set)context.getUserData(CHANGED_ARTIFACTS);
        if (artifacts == null) {
            artifacts = new THashSet();
            context.putUserData(CHANGED_ARTIFACTS, (Object)artifacts);
        }
        artifacts.add(artifact);
    }

    public static void addWrittenPaths(CompileContext context, Set<String> writtenPaths) {
        Set paths = (Set)context.getUserData(WRITTEN_PATHS_KEY);
        if (paths == null) {
            paths = new THashSet();
            context.putUserData(WRITTEN_PATHS_KEY, (Object)paths);
        }
        paths.addAll(writtenPaths);
    }

    @Override
    @NotNull
    public KeyDescriptor<String> getItemKeyDescriptor() {
        KeyDescriptor keyDescriptor = STRING_KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getItemKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @Override
    @NotNull
    public DataExternalizer<VirtualFilePersistentState> getSourceStateExternalizer() {
        DataExternalizer<VirtualFilePersistentState> dataExternalizer = VirtualFilePersistentState.EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getSourceStateExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public DataExternalizer<ArtifactPackagingItemOutputState> getOutputStateExternalizer() {
        ArtifactPackagingItemExternalizer artifactPackagingItemExternalizer = new ArtifactPackagingItemExternalizer();
        if (artifactPackagingItemExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getOutputStateExternalizer"));
        }
        return artifactPackagingItemExternalizer;
    }

    @Override
    @NotNull
    public GenericCompilerInstance<ArtifactBuildTarget, ? extends CompileItem<String, VirtualFilePersistentState, ArtifactPackagingItemOutputState>, String, VirtualFilePersistentState, ArtifactPackagingItemOutputState> createInstance(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "createInstance"));
        }
        ArtifactsCompilerInstance artifactsCompilerInstance = new ArtifactsCompilerInstance(context);
        if (artifactsCompilerInstance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "createInstance"));
        }
        return artifactsCompilerInstance;
    }

    @NotNull
    public String getDescription() {
        if ("Artifacts Packaging Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getDescription"));
        }
        return "Artifacts Packaging Compiler";
    }

    @Nullable
    public static Set<Artifact> getChangedArtifacts(CompileContext compileContext) {
        return (Set)compileContext.getUserData(CHANGED_ARTIFACTS);
    }

    @Nullable
    public static Set<String> getWrittenPaths(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactsCompiler", "getWrittenPaths"));
        }
        return (Set)context.getUserData(WRITTEN_PATHS_KEY);
    }
}

