/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public class ArtifactCompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.compiler.ArtifactCompilerUtil");

    private ArtifactCompilerUtil() {
    }

    @Nullable
    public static BufferedInputStream getJarEntryInputStream(VirtualFile sourceFile, CompileContext context) throws IOException {
        String fullPath = sourceFile.getPath();
        int jarEnd = fullPath.indexOf("!/");
        LOG.assertTrue(jarEnd != -1, (Object)fullPath);
        String pathInJar = fullPath.substring(jarEnd + "!/".length());
        String jarPath = fullPath.substring(0, jarEnd);
        final ZipFile jarFile = new ZipFile(new File(FileUtil.toSystemDependentName((String)jarPath)));
        ZipEntry entry = jarFile.getEntry(pathInJar);
        if (entry == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Cannot extract '" + pathInJar + "' from '" + jarFile.getName() + "': entry not found", null, -1, -1);
            return null;
        }
        return new BufferedInputStream(jarFile.getInputStream(entry)){

            @Override
            public void close() throws IOException {
                super.close();
                jarFile.close();
            }
        };
    }

    public static File getJarFile(VirtualFile jarEntry) {
        String fullPath = jarEntry.getPath();
        return new File(FileUtil.toSystemDependentName((String)fullPath.substring(fullPath.indexOf("!/"))));
    }

    @NotNull
    public static Set<VirtualFile> getArtifactOutputsContainingSourceFiles(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactCompilerUtil", "getArtifactOutputsContainingSourceFiles"));
        }
        ArrayList allOutputs = new ArrayList();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            ContainerUtil.addIfNotNull((Object)artifact.getOutputFile(), allOutputs);
        }
        final HashSet roots = new HashSet();
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            Processor processor = new Processor<PackagingElement<?>>(){

                public boolean process(@NotNull PackagingElement<?> element) {
                    VirtualFile file;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactCompilerUtil$2", "process"));
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement && (file = ((FileOrDirectoryCopyPackagingElement)element).findFile()) != null) {
                        roots.add(file);
                    }
                    return true;
                }
            };
            ArtifactUtil.processRecursivelySkippingIncludedArtifacts(artifact, processor, context);
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            Facet[] facets;
            for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
                if (!(facet instanceof FacetRootsProvider)) continue;
                roots.addAll(((FacetRootsProvider)facet).getFacetRoots());
            }
        }
        HashSet<VirtualFile> affectedOutputPaths = new HashSet<VirtualFile>();
        for (VirtualFile output : allOutputs) {
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)output, (VirtualFile)root, (boolean)false)) continue;
                affectedOutputPaths.add(output);
            }
        }
        HashSet<VirtualFile> hashSet = affectedOutputPaths;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactCompilerUtil", "getArtifactOutputsContainingSourceFiles"));
        }
        return hashSet;
    }

    public static boolean containsArtifacts(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            if (!ArtifactBuildTargetType.INSTANCE.getTypeId().equals(scope.getTypeId())) continue;
            return true;
        }
        return false;
    }

    public static MultiMap<String, Artifact> createOutputToArtifactMap(final Project project) {
        final MultiMap result = MultiMap.create((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        new ReadAction(){

            protected void run(Result r) {
                for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
                    String outputPath = artifact.getOutputFilePath();
                    if (StringUtil.isEmpty((String)outputPath)) continue;
                    result.putValue((Object)outputPath, (Object)artifact);
                }
            }
        }.execute();
        return result;
    }
}

