/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactSortingUtil;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactSortingUtilImpl
extends ArtifactSortingUtil {
    private final Project myProject;
    private CachedValue<Map<String, String>> myArtifactToSelfIncludingName;
    private CachedValue<List<String>> mySortedArtifacts;

    public ArtifactSortingUtilImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public Map<String, String> getArtifactToSelfIncludingNameMap() {
        if (this.myArtifactToSelfIncludingName == null) {
            this.myArtifactToSelfIncludingName = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, String>>(){

                public CachedValueProvider.Result<Map<String, String>> compute() {
                    return CachedValueProvider.Result.create((Object)ArtifactSortingUtilImpl.this.computeArtifactToSelfIncludingNameMap(), (Object[])new Object[]{ArtifactManager.getInstance((Project)ArtifactSortingUtilImpl.this.myProject).getModificationTracker()});
                }
            }, false);
        }
        return (Map)this.myArtifactToSelfIncludingName.getValue();
    }

    @Override
    public List<String> getArtifactsSortedByInclusion() {
        if (this.mySortedArtifacts == null) {
            this.mySortedArtifacts = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<List<String>>(){

                public CachedValueProvider.Result<List<String>> compute() {
                    return CachedValueProvider.Result.create((Object)ArtifactSortingUtilImpl.this.doGetSortedArtifacts(), (Object[])new Object[]{ArtifactManager.getInstance((Project)ArtifactSortingUtilImpl.this.myProject).getModificationTracker()});
                }
            }, false);
        }
        return (List)this.mySortedArtifacts.getValue();
    }

    private List<String> doGetSortedArtifacts() {
        GraphGenerator<String> graph = this.createArtifactsGraph();
        DFSTBuilder builder = new DFSTBuilder(graph);
        builder.buildDFST();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(graph.getNodes());
        Collections.sort(names, builder.comparator());
        return names;
    }

    private Map<String, String> computeArtifactToSelfIncludingNameMap() {
        final HashMap<String, String> result = new HashMap<String, String>();
        GraphGenerator<String> graph = this.createArtifactsGraph();
        block0: for (String artifactName : graph.getNodes()) {
            Iterator in = graph.getIn((Object)artifactName);
            while (in.hasNext()) {
                String next = (String)in.next();
                if (!next.equals(artifactName)) continue;
                result.put(artifactName, artifactName);
                continue block0;
            }
        }
        final DFSTBuilder builder = new DFSTBuilder(graph);
        builder.buildDFST();
        if (builder.isAcyclic() && result.isEmpty()) {
            return Collections.emptyMap();
        }
        TIntArrayList sccs = builder.getSCCs();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                if (size > 1) {
                    for (int j = 0; j < size; ++j) {
                        String artifactName = (String)builder.getNodeByTNumber(this.myTNumber + j);
                        result.put(artifactName, artifactName);
                    }
                }
                this.myTNumber += size;
                return true;
            }
        });
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            String artifactName = (String)builder.getNodeByTNumber(i);
            if (result.containsKey(artifactName)) continue;
            Iterator in = graph.getIn((Object)artifactName);
            while (in.hasNext()) {
                String name = (String)result.get(in.next());
                if (name == null) continue;
                result.put(artifactName, name);
            }
        }
        return result;
    }

    private GraphGenerator<String> createArtifactsGraph() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new ArtifactsGraph(artifactManager)));
    }

    private class ArtifactsGraph
    implements GraphGenerator.SemiGraph<String> {
        private final ArtifactManager myArtifactManager;
        private final Set<String> myArtifactNames;

        public ArtifactsGraph(ArtifactManager artifactManager) {
            this.myArtifactManager = artifactManager;
            this.myArtifactNames = new LinkedHashSet<String>();
            for (Artifact artifact : this.myArtifactManager.getSortedArtifacts()) {
                this.myArtifactNames.add(artifact.getName());
            }
        }

        public Collection<String> getNodes() {
            return this.myArtifactNames;
        }

        public Iterator<String> getIn(String name) {
            final LinkedHashSet included = new LinkedHashSet();
            PackagingElementResolvingContext context = this.myArtifactManager.getResolvingContext();
            Artifact artifact = context.getArtifactModel().findArtifact(name);
            if (artifact != null) {
                ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, new PackagingElementProcessor<ArtifactPackagingElement>(){

                    @Override
                    public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/artifacts/ArtifactSortingUtilImpl$ArtifactsGraph$1", "process"));
                        }
                        if (path == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/artifacts/ArtifactSortingUtilImpl$ArtifactsGraph$1", "process"));
                        }
                        String artifactName = element.getArtifactName();
                        if (ArtifactsGraph.this.myArtifactNames.contains(artifactName)) {
                            included.add(artifactName);
                        }
                        return true;
                    }
                }, context, false);
            }
            return included.iterator();
        }
    }
}

