/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import org.jetbrains.annotations.NotNull;

public class ArtifactPointerImpl
implements ArtifactPointer {
    private String myName;
    private Artifact myArtifact;

    public ArtifactPointerImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "<init>"));
        }
        this.myName = name;
    }

    public ArtifactPointerImpl(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "<init>"));
        }
        this.myArtifact = artifact;
        this.myName = artifact.getName();
    }

    @NotNull
    public String getArtifactName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "getArtifactName"));
        }
        return string;
    }

    public Artifact getArtifact() {
        return this.myArtifact;
    }

    @NotNull
    public String getArtifactName(@NotNull ArtifactModel artifactModel) {
        if (artifactModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "getArtifactName"));
        }
        if (this.myArtifact != null) {
            String string = artifactModel.getArtifactByOriginal(this.myArtifact).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "getArtifactName"));
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "getArtifactName"));
        }
        return string;
    }

    public Artifact findArtifact(@NotNull ArtifactModel artifactModel) {
        if (artifactModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl", "findArtifact"));
        }
        if (this.myArtifact != null) {
            return artifactModel.getArtifactByOriginal(this.myArtifact);
        }
        return artifactModel.findArtifact(this.myName);
    }

    void setArtifact(Artifact artifact) {
        this.myArtifact = artifact;
    }

    void setName(String name) {
        this.myName = name;
    }
}

