/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.scopeView.nodes.BasePsiNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeModelBuilder {
    public static final Key<Integer> FILE_COUNT = Key.create((String)"FILE_COUNT");
    public static final String SCANNING_PACKAGES_MESSAGE = AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]);
    private final ProjectFileIndex myFileIndex;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.packageDependencies.ui.TreeModelBuilder");
    private final boolean myShowModuleGroups;
    private final boolean myShowModules;
    private final boolean myFlattenPackages;
    private final boolean myCompactEmptyMiddlePackages;
    private boolean myShowFiles;
    private final Marker myMarker;
    private final boolean myAddUnmarkedFiles;
    private final PackageDependenciesNode myRoot;
    private final Map<VirtualFile, DirectoryNode> myModuleDirNodes = new HashMap<VirtualFile, DirectoryNode>();
    private final Map<Module, ModuleNode> myModuleNodes = new HashMap<Module, ModuleNode>();
    private final Map<String, ModuleGroupNode> myModuleGroupNodes = new HashMap<String, ModuleGroupNode>();
    private int myScannedFileCount = 0;
    private int myTotalFileCount = 0;
    private int myMarkedFileCount = 0;
    private JTree myTree;
    protected final VirtualFile myBaseDir;
    protected VirtualFile[] myContentRoots;

    public FileTreeModelBuilder(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir();
        this.myContentRoots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        boolean multiModuleProject = ModuleManager.getInstance((Project)this.myProject).getModules().length > 1;
        this.myShowModules = settings.UI_SHOW_MODULES && multiModuleProject;
        this.myFlattenPackages = settings.UI_FLATTEN_PACKAGES;
        this.myCompactEmptyMiddlePackages = settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        this.myShowFiles = settings.UI_SHOW_FILES;
        this.myShowModuleGroups = settings.UI_SHOW_MODULE_GROUPS && multiModuleProject;
        this.myMarker = marker;
        this.myAddUnmarkedFiles = !settings.UI_FILTER_LEGALS;
        this.myRoot = new RootNode(this.myProject);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public void setTree(DnDAwareTree tree) {
        this.myTree = tree;
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Set<PsiFile> files, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new FileTreeModelBuilder(project, marker, settings).build(files, showProgress);
    }

    public static synchronized TreeModel createTreeModel(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new FileTreeModelBuilder(project, marker, settings).build(project, false);
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Marker marker) {
        return new FileTreeModelBuilder(project, marker, new DependenciesPanel.DependencyPanelSettings()).build(project, showProgress);
    }

    private void countFiles(Project project) {
        Integer fileCount = (Integer)project.getUserData(FILE_COUNT);
        if (fileCount == null) {
            this.myFileIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory()) {
                        FileTreeModelBuilder.this.counting();
                    }
                    return true;
                }
            });
            project.putUserData(FILE_COUNT, (Object)this.myTotalFileCount);
        } else {
            this.myTotalFileCount = fileCount;
        }
    }

    public static void clearCaches(Project project) {
        project.putUserData(FILE_COUNT, null);
    }

    public TreeModel build(Project project, boolean showProgress) {
        return this.build(project, showProgress, null);
    }

    public TreeModel build(final Project project, boolean showProgress, final @Nullable Runnable successRunnable) {
        final Runnable buildingRunnable = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.setText(SCANNING_PACKAGES_MESSAGE);
                    indicator.setIndeterminate(true);
                }
                FileTreeModelBuilder.this.countFiles(project);
                if (indicator != null) {
                    indicator.setIndeterminate(false);
                }
                FileTreeModelBuilder.this.myFileIndex.iterateContent((ContentIterator)new MyContentIterator());
            }
        };
        final TreeModel treeModel = new TreeModel(this.myRoot);
        if (showProgress) {
            Task.Backgroundable backgroundable = new Task.Backgroundable(project, AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packageDependencies/ui/FileTreeModelBuilder$3", "run"));
                    }
                    buildingRunnable.run();
                }

                public void onSuccess() {
                    if (project.isDisposed()) {
                        return;
                    }
                    FileTreeModelBuilder.this.myRoot.setSorted(false);
                    FileTreeModelBuilder.this.myRoot.sortChildren();
                    treeModel.reload(FileTreeModelBuilder.this.myRoot);
                    if (successRunnable != null) {
                        successRunnable.run();
                    }
                }
            };
            ProgressManager.getInstance().run((Task)backgroundable);
        } else {
            buildingRunnable.run();
        }
        treeModel.setTotalFileCount(this.myTotalFileCount);
        treeModel.setMarkedFileCount(this.myMarkedFileCount);
        return treeModel;
    }

    private void counting() {
        ++this.myTotalFileCount;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            FileTreeModelBuilder.update(indicator, true, -1.0);
        }
    }

    private static void update(ProgressIndicator indicator, boolean indeterminate, double fraction) {
        if (indicator instanceof PanelProgressIndicator) {
            ((PanelProgressIndicator)indicator).update(SCANNING_PACKAGES_MESSAGE, indeterminate, fraction);
        } else if (fraction != -1.0) {
            indicator.setFraction(fraction);
        }
    }

    private TreeModel build(final Set<PsiFile> files, boolean showProgress) {
        if (files.size() == 1) {
            this.myShowFiles = true;
        }
        Runnable buildingRunnable = new Runnable(){

            @Override
            public void run() {
                for (PsiFile file : files) {
                    if (file == null) continue;
                    FileTreeModelBuilder.this.buildFileNode(file.getVirtualFile(), null);
                }
            }
        };
        if (showProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]), false, this.myProject);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator());
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private PackageDependenciesNode buildFileNode(VirtualFile file, PackageDependenciesNode lastParent) {
        boolean isMarked;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (file == null || !file.isValid()) {
            return null;
        }
        if (indicator != null) {
            FileTreeModelBuilder.update(indicator, false, (double)this.myScannedFileCount++ / (double)this.myTotalFileCount);
        }
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file);
        if (isMarked) {
            ++this.myMarkedFileCount;
        }
        if (isMarked || this.myAddUnmarkedFiles) {
            PackageDependenciesNode dirNode;
            PackageDependenciesNode packageDependenciesNode = dirNode = !this.myCompactEmptyMiddlePackages && lastParent != null ? lastParent : this.getFileParentNode(file);
            if (this.myShowFiles) {
                FileNode fileNode = new FileNode(file, this.myProject, isMarked);
                dirNode.add(fileNode);
            } else {
                dirNode.addFile(file, isMarked);
            }
            return dirNode;
        }
        return null;
    }

    @NotNull
    public PackageDependenciesNode getFileParentNode(VirtualFile file) {
        LOG.assertTrue(file != null);
        VirtualFile containingDirectory = file.getParent();
        PackageDependenciesNode packageDependenciesNode = this.getModuleDirNode(containingDirectory, this.myFileIndex.getModuleForFile(file), null);
        if (packageDependenciesNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/FileTreeModelBuilder", "getFileParentNode"));
        }
        return packageDependenciesNode;
    }

    public boolean hasFileNode(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packageDependencies/ui/FileTreeModelBuilder", "hasFileNode"));
        }
        return this.myModuleDirNodes.containsKey(file);
    }

    @Nullable
    public DefaultMutableTreeNode removeNode(PsiElement element, PsiDirectory parent) {
        TreeNode treeNode;
        PackageDependenciesNode[] classOrDirNodes;
        LOG.assertTrue(parent != null, (Object)(element instanceof PsiFile && ((PsiFile)element).getVirtualFile() != null ? ((PsiFile)element).getVirtualFile().getPath() : element));
        VirtualFile parentVirtualFile = parent.getVirtualFile();
        Module module = this.myFileIndex.getModuleForFile(parentVirtualFile);
        if (element instanceof PsiDirectory && this.myFlattenPackages) {
            PackageDependenciesNode moduleNode = this.getModuleNode(module);
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile virtualFile = psiDirectory.getVirtualFile();
            PackageDependenciesNode dirNode = this.getModuleDirNode(virtualFile, this.myFileIndex.getModuleForFile(virtualFile), null);
            dirNode.removeFromParent();
            return moduleNode;
        }
        DefaultMutableTreeNode dirNode = this.myModuleDirNodes.get(parentVirtualFile);
        if (dirNode == null) {
            return null;
        }
        if (dirNode instanceof DirectoryNode) {
            DirectoryNode wrapper = ((DirectoryNode)dirNode).getWrapper();
            while (wrapper != null) {
                dirNode = wrapper;
                this.myModuleDirNodes.put(wrapper.getDirectory(), null);
                wrapper = ((DirectoryNode)dirNode).getWrapper();
            }
        }
        if ((classOrDirNodes = FileTreeModelBuilder.findNodeForPsiElement((PackageDependenciesNode)dirNode, element)) != null) {
            for (PackageDependenciesNode classNode : classOrDirNodes) {
                classNode.removeFromParent();
            }
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)dirNode.getParent();
        DefaultMutableTreeNode node = dirNode;
        if (element == parent) {
            this.myModuleDirNodes.put(parentVirtualFile, null);
            dirNode.removeFromParent();
            node = parentNode;
        }
        while (node != null && node.getChildCount() == 0) {
            PsiDirectory directory = parent.getParentDirectory();
            parentNode = (DefaultMutableTreeNode)node.getParent();
            node.removeFromParent();
            if (node instanceof DirectoryNode) {
                while (node != null) {
                    this.myModuleDirNodes.put(((DirectoryNode)node).getDirectory(), null);
                    node = ((DirectoryNode)node).getCompactedDirNode();
                }
            } else if (node instanceof ModuleNode) {
                this.myModuleNodes.put(((ModuleNode)node).getModule(), null);
            } else if (node instanceof ModuleGroupNode) {
                this.myModuleGroupNodes.put(((ModuleGroupNode)node).getModuleGroupName(), null);
            }
            node = parentNode;
            parent = directory;
        }
        if (this.myCompactEmptyMiddlePackages && node instanceof DirectoryNode && node.getChildCount() == 1 && (treeNode = node.getChildAt(0)) instanceof DirectoryNode) {
            node.removeAllChildren();
            for (int i = treeNode.getChildCount() - 1; i >= 0; --i) {
                node.add((MutableTreeNode)treeNode.getChildAt(i));
            }
            ((DirectoryNode)node).setCompactedDirNode((DirectoryNode)treeNode);
        }
        return parentNode != null ? parentNode : this.myRoot;
    }

    @Nullable
    public PackageDependenciesNode addFileNode(PsiFile file) {
        VirtualFile dirToReload;
        boolean isMarked;
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file.getVirtualFile());
        if (!isMarked) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        LOG.assertTrue(vFile != null);
        PackageDependenciesNode rootToReload = this.myModuleDirNodes.get(dirToReload);
        if (rootToReload == null && this.myFlattenPackages) {
            Module module = this.myFileIndex.getModuleForFile(vFile);
            boolean moduleNodeExist = this.myModuleNodes.get(module) != null;
            rootToReload = this.getModuleNode(module);
            if (!moduleNodeExist) {
                rootToReload = null;
            }
        } else {
            for (dirToReload = vFile.getParent(); (rootToReload == null || rootToReload instanceof DirectoryNode && ((DirectoryNode)rootToReload).getCompactedDirNode() != null) && dirToReload != null; dirToReload = dirToReload.getParent()) {
                rootToReload = this.myModuleDirNodes.get(dirToReload);
            }
        }
        PackageDependenciesNode dirNode = this.getFileParentNode(vFile);
        if (FileTreeModelBuilder.findNodeForPsiElement(dirNode, (PsiElement)file) == null) {
            dirNode.add(new FileNode(vFile, this.myProject, isMarked));
        }
        return rootToReload;
    }

    @Nullable
    public PackageDependenciesNode addDirNode(PsiDirectory dir) {
        VirtualFile vFile = dir.getVirtualFile();
        if (this.myMarker == null) {
            return null;
        }
        final boolean[] isMarked = new boolean[]{this.myMarker.isMarked(vFile)};
        VirtualFile dirToReload = vFile.getParent();
        PackageDependenciesNode rootToReload = this.myModuleDirNodes.get(dirToReload);
        if (rootToReload == null && this.myFlattenPackages) {
            Module module = this.myFileIndex.getModuleForFile(vFile);
            boolean moduleNodeExist = this.myModuleNodes.get(module) != null;
            rootToReload = this.getModuleNode(module);
            if (!moduleNodeExist) {
                rootToReload = null;
            }
        } else {
            while (rootToReload == null && dirToReload != null) {
                dirToReload = dirToReload.getParent();
                rootToReload = this.myModuleDirNodes.get(dirToReload);
            }
        }
        this.myFileIndex.iterateContentUnderDirectory(vFile, (ContentIterator)new MyContentIterator(){

            @Override
            public boolean processFile(VirtualFile fileOrDir) {
                isMarked[0] = isMarked[0] | FileTreeModelBuilder.this.myMarker.isMarked(fileOrDir);
                return super.processFile(fileOrDir);
            }
        });
        if (!isMarked[0]) {
            return null;
        }
        this.getModuleDirNode(vFile, this.myFileIndex.getModuleForFile(vFile), null);
        return rootToReload != null ? rootToReload : this.myRoot;
    }

    @Nullable
    public PackageDependenciesNode findNode(PsiFileSystemItem file, PsiElement psiElement) {
        if (file instanceof PsiDirectory) {
            return this.getModuleDirNode(file.getVirtualFile(), this.myFileIndex.getModuleForFile(file.getVirtualFile()), null);
        }
        PackageDependenciesNode parent = this.getFileParentNode(file.getVirtualFile());
        PackageDependenciesNode[] nodes = FileTreeModelBuilder.findNodeForPsiElement(parent, (PsiElement)file);
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        for (PackageDependenciesNode node : nodes) {
            if (node.getPsiElement() != psiElement) continue;
            return node;
        }
        return nodes[0];
    }

    @Nullable
    public static PackageDependenciesNode[] findNodeForPsiElement(PackageDependenciesNode parent, PsiElement element) {
        HashSet result = new HashSet();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode treeNode = parent.getChildAt(i);
            if (!(treeNode instanceof PackageDependenciesNode)) continue;
            PackageDependenciesNode node = (PackageDependenciesNode)treeNode;
            if (element instanceof PsiDirectory && node.getPsiElement() == element) {
                return new PackageDependenciesNode[]{node};
            }
            if (!(element instanceof PsiFile)) continue;
            PsiFile psiFile = null;
            if (node instanceof BasePsiNode) {
                psiFile = ((BasePsiNode)node).getContainingFile();
            } else if (node instanceof FileNode) {
                psiFile = (PsiFile)node.getPsiElement();
            }
            if (psiFile == null || !Comparing.equal((Object)psiFile.getVirtualFile(), (Object)((PsiFile)element).getVirtualFile())) continue;
            result.add(node);
        }
        return result.isEmpty() ? null : result.toArray(new PackageDependenciesNode[result.size()]);
    }

    private PackageDependenciesNode getModuleDirNode(VirtualFile virtualFile, Module module, DirectoryNode childNode) {
        if (virtualFile == null) {
            return this.getModuleNode(module);
        }
        PackageDependenciesNode directoryNode = this.myModuleDirNodes.get(virtualFile);
        if (directoryNode != null) {
            if (this.myCompactEmptyMiddlePackages) {
                DirectoryNode parentWrapper;
                final DirectoryNode nestedNode = ((DirectoryNode)directoryNode).getCompactedDirNode();
                if (nestedNode != null) {
                    boolean expand = false;
                    if (this.myTree != null) {
                        expand = !this.myTree.isCollapsed(new TreePath(directoryNode.getPath()));
                    }
                    DirectoryNode parentWrapper2 = nestedNode.getWrapper();
                    while (parentWrapper2.getWrapper() != null) {
                        parentWrapper2 = parentWrapper2.getWrapper();
                    }
                    for (int i = parentWrapper2.getChildCount() - 1; i >= 0; --i) {
                        nestedNode.add((MutableTreeNode)parentWrapper2.getChildAt(i));
                    }
                    ((DirectoryNode)directoryNode).setCompactedDirNode(null);
                    parentWrapper2.add(nestedNode);
                    nestedNode.removeUpReference();
                    if (this.myTree != null && expand) {
                        Runnable expandRunnable = new Runnable(){

                            @Override
                            public void run() {
                                FileTreeModelBuilder.this.myTree.expandPath(new TreePath(nestedNode.getPath()));
                            }
                        };
                        SwingUtilities.invokeLater(expandRunnable);
                    }
                    return parentWrapper2;
                }
                if (directoryNode.getParent() == null && (parentWrapper = ((DirectoryNode)directoryNode).getWrapper()) != null) {
                    while (parentWrapper.getWrapper() != null) {
                        parentWrapper = parentWrapper.getWrapper();
                    }
                    return parentWrapper;
                }
            }
            return directoryNode;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
        directoryNode = new DirectoryNode(virtualFile, this.myProject, this.myCompactEmptyMiddlePackages, this.myFlattenPackages, this.myBaseDir, this.myContentRoots);
        this.myModuleDirNodes.put(virtualFile, (DirectoryNode)directoryNode);
        VirtualFile directory = virtualFile.getParent();
        if (!this.myFlattenPackages && directory != null) {
            if (this.myCompactEmptyMiddlePackages && !Comparing.equal((Object)sourceRoot, (Object)virtualFile) && !Comparing.equal((Object)contentRoot, (Object)virtualFile)) {
                ((DirectoryNode)directoryNode).setCompactedDirNode(childNode);
            }
            if (fileIndex.getModuleForFile(directory) == module) {
                DirectoryNode parentDirectoryNode = this.myModuleDirNodes.get(directory);
                if (parentDirectoryNode != null || !this.myCompactEmptyMiddlePackages || sourceRoot != null && VfsUtil.isAncestor((VirtualFile)directory, (VirtualFile)sourceRoot, (boolean)false) && fileIndex.getSourceRootForFile(directory) != null || Comparing.equal((Object)directory, (Object)contentRoot)) {
                    this.getModuleDirNode(directory, module, (DirectoryNode)directoryNode).add(directoryNode);
                } else {
                    directoryNode = this.getModuleDirNode(directory, module, (DirectoryNode)directoryNode);
                }
            } else {
                this.getModuleNode(module).add(directoryNode);
            }
        } else if (Comparing.equal((Object)contentRoot, (Object)virtualFile)) {
            this.getModuleNode(module).add(directoryNode);
        } else {
            Object root = !Comparing.equal((Object)sourceRoot, (Object)virtualFile) && sourceRoot != null ? sourceRoot : (contentRoot != null ? contentRoot : null);
            if (root != null) {
                this.getModuleDirNode((VirtualFile)root, module, null).add(directoryNode);
            }
        }
        return directoryNode;
    }

    @Nullable
    private PackageDependenciesNode getModuleNode(Module module) {
        if (module == null || !this.myShowModules) {
            return this.myRoot;
        }
        ModuleNode node = this.myModuleNodes.get(module);
        if (node != null) {
            return node;
        }
        node = new ModuleNode(module);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        String[] groupPath = moduleManager.getModuleGroupPath(module);
        if (groupPath == null) {
            this.myModuleNodes.put(module, node);
            this.myRoot.add(node);
            return node;
        }
        this.myModuleNodes.put(module, node);
        if (this.myShowModuleGroups) {
            this.getParentModuleGroup(groupPath).add(node);
        } else {
            this.myRoot.add(node);
        }
        return node;
    }

    private PackageDependenciesNode getParentModuleGroup(String[] groupPath) {
        String key = StringUtil.join((String[])groupPath);
        ModuleGroupNode groupNode = this.myModuleGroupNodes.get(key);
        if (groupNode == null) {
            groupNode = new ModuleGroupNode(new ModuleGroup(groupPath), this.myProject);
            this.myModuleGroupNodes.put(key, groupNode);
            this.myRoot.add(groupNode);
        }
        if (groupPath.length > 1) {
            String[] path = new String[groupPath.length - 1];
            System.arraycopy(groupPath, 0, path, 0, groupPath.length - 1);
            PackageDependenciesNode node = this.getParentModuleGroup(path);
            node.add(groupNode);
        }
        return groupNode;
    }

    private class MyContentIterator
    implements ContentIterator {
        PackageDependenciesNode lastParent = null;
        VirtualFile dir;

        private MyContentIterator() {
        }

        public boolean processFile(VirtualFile fileOrDir) {
            if (!fileOrDir.isDirectory()) {
                if (this.lastParent != null && !Comparing.equal((Object)this.dir, (Object)fileOrDir.getParent())) {
                    this.lastParent = null;
                }
                this.lastParent = FileTreeModelBuilder.this.buildFileNode(fileOrDir, this.lastParent);
                this.dir = fileOrDir.getParent();
            } else {
                this.lastParent = null;
            }
            return true;
        }
    }
}

