/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePane;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class NewWelcomeScreen
extends JPanel
implements WelcomeScreen {
    public NewWelcomeScreen() {
        super(new BorderLayout());
        this.add((Component)NewWelcomeScreen.createHeaderPanel(), "North");
        this.add((Component)NewWelcomeScreen.createFooterPanel(), "South");
        this.add((Component)NewWelcomeScreen.createInnerPanel(this), "Center");
    }

    private static WelcomePane createInnerPanel(WelcomeScreen screen) {
        WelcomeScreenGroup root = new WelcomeScreenGroup(null, "Root", new AnAction[0]);
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup quickStart = (ActionGroup)actionManager.getAction("WelcomeScreen.QuickStart");
        for (AnAction child : quickStart.getChildren(null)) {
            root.add(child);
        }
        root.add((AnAction)NewWelcomeScreen.buildRootGroup(AllIcons.General.Configure, "Configure", "WelcomeScreen.Configure"));
        root.add((AnAction)NewWelcomeScreen.buildRootGroup(AllIcons.General.ReadHelp, "Docs and How-Tos", "WelcomeScreen.Documentation"));
        AnAction register = actionManager.getAction("WelcomeScreen.Register");
        if (register != null) {
            root.add(register);
        }
        return new WelcomePane((ActionGroup)root, screen);
    }

    private static WelcomeScreenGroup buildRootGroup(Icon groupIcon, String groupText, String groupId) {
        WelcomeScreenGroup docs = new WelcomeScreenGroup(groupIcon, groupText, new AnAction[0]);
        ActionGroup docsActions = (ActionGroup)ActionManager.getInstance().getAction(groupId);
        for (AnAction child : docsActions.getChildren(null)) {
            docs.add(child);
        }
        return docs;
    }

    private static JPanel createFooterPanel() {
        JLabel versionLabel = new JLabel(ApplicationNamesInfo.getInstance().getFullProductName() + " " + ApplicationInfo.getInstance().getFullVersion() + " Build " + ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode());
        NewWelcomeScreen.makeSmallFont(versionLabel);
        versionLabel.setForeground(WelcomeScreenColors.FOOTER_FOREGROUND);
        JPanel footerPanel = new JPanel(new FlowLayout(0, 0, 0));
        footerPanel.setBackground(WelcomeScreenColors.FOOTER_BACKGROUND);
        footerPanel.setBorder(new EmptyBorder(2, 5, 2, 5){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(WelcomeScreenColors.BORDER_COLOR);
                g.drawLine(x, y, x + width, y);
            }
        });
        footerPanel.add(versionLabel);
        footerPanel.add(NewWelcomeScreen.makeSmallFont(new JLabel(".  ")));
        footerPanel.add(NewWelcomeScreen.makeSmallFont((JLabel)new LinkLabel("Check", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                UpdateChecker.updateAndShowResult(null, false, null, UpdateSettings.getInstance());
            }
        })));
        footerPanel.add(NewWelcomeScreen.makeSmallFont(new JLabel(" for updates now.")));
        return footerPanel;
    }

    private static JLabel makeSmallFont(JLabel label) {
        label.setFont(label.getFont().deriveFont(10.0f));
        return label;
    }

    private static JPanel createHeaderPanel() {
        JPanel header = new JPanel(new BorderLayout());
        JLabel welcome = new JLabel("Welcome to " + ApplicationNamesInfo.getInstance().getFullProductName(), IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getWelcomeScreenLogoUrl()), 2);
        welcome.setBorder(new EmptyBorder(10, 15, 10, 15));
        welcome.setFont(welcome.getFont().deriveFont(32.0f));
        welcome.setIconTextGap(20);
        welcome.setForeground(WelcomeScreenColors.WELCOME_HEADER_FOREGROUND);
        header.add(welcome);
        header.setBackground(WelcomeScreenColors.WELCOME_HEADER_BACKGROUND);
        header.setBorder(new BottomLineBorder());
        return header;
    }

    public JComponent getWelcomePanel() {
        return this;
    }

    public void setupFrame(JFrame frame) {
        frame.setResizable(false);
        frame.pack();
        Point location = DimensionService.getInstance().getLocation("WELCOME_SCREEN", null);
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        frame.setLocation(new Point(screenBounds.x + (screenBounds.width - frame.getWidth()) / 2, screenBounds.y + (screenBounds.height - frame.getHeight()) / 3));
    }

    public void dispose() {
    }

    private static class WelcomeScreenGroup
    extends DefaultActionGroup {
        private WelcomeScreenGroup(Icon icon, String text, AnAction ... actions) {
            super(text, true);
            for (AnAction action : actions) {
                this.add(action);
            }
            this.getTemplatePresentation().setText(text);
            this.getTemplatePresentation().setIcon(icon);
        }
    }
}

